#!/bin/sh
# $1 - prov_type $2 - path to cpro sbindir
arg_prov_type=$1
cpro_sbin_dir=$2

cpconfig=$cpro_sbin_dir/cpconfig
type=`printf "%03d\n" $arg_prov_type`

providers=`$cpconfig -ini '\cryptography\Defaults\Provider' -enum section`
prov_types=`echo "$providers" | while read line; do $cpconfig -ini '\cryptography\Defaults\Provider\'"$line"'\Type' -view 2>/dev/null; done`
echo "$prov_types" | grep ^$arg_prov_type$ > /dev/null
if test $? -eq 1; then
  $cpconfig -ini '\cryptography\Defaults\Provider Types\Type '$type -delsection >&-
else
  echo "section [Defaults\Provider] for type $arg_prov_type is not empty!"
fi
