/*
 * Copyright(C) 2003  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 229334 $
 * \date $Date:: 2021-06-27 20:15:25 +0300#$
 * \author $Author: dim $
 *
 * \brief    ,    
 */

#ifndef __ENCODEAND_H
#define __ENCODEAND_H

#include "PKIXCMP.h"

/* This class is to fix the bug in ASN1C reference counting. When you
 * copy ASN1C_... class (generated by ASN1C compiler) like this:
 *
 * ASN1C_ResponderID objCopy(sourceObj);
 *
 * AND corresponding ASN1T_... class inherits ASN1TPDU:
 *
 * typedef struct EXTERN ASN1T_ResponderID : public ASN1TPDU { ... };
 * 
 * You get ASN1CTXT leak, because the reference counter for context is
 * incremented twice (in ASN1CType ctor and in ASN1C_...::getCopy), but
 * decremented only once (in ASN1CType dtor), because objCopt.msgData is
 * a reference, and no dtor is called for object allocated in ASN1C_...::getCopy.
 */

template <typename ASN1_T> inline void conditionalCtxtUnref( ASN1_T& /*t*/ ) { return; }

template <typename T>
class Asn1CtxtUnrefInDestructor : public T {
public:
    Asn1CtxtUnrefInDestructor( T& src ): T(src) { }
    ~Asn1CtxtUnrefInDestructor() { conditionalCtxtUnref(this->msgData); }
    static void conditionalCtxtUnref( ASN1TPDU& t ) { t.unsetContext(); }
};
#endif // __ENCODEAND_H
