/****************************************************************************
*                                                                           *
* windef.h -- Basic Windows Type Definitions                                *
*                                                                           *
* Copyright (c) 1985-1999, Microsoft Corp. All rights reserved.             *
*                                                                           *
****************************************************************************/


#ifndef _WINSCARD_
#define _WINSCARD_

#ifdef HAVE_CPRO_CONFIG_H
#include "myconfig.h"
#endif

#if defined(ANDROID)
  typedef unsigned int PCSC_DWORD;
  typedef long PCSC_LONG;
#elif defined(IOS) || defined(DARWIN)
  typedef unsigned int PCSC_DWORD;
  typedef int PCSC_LONG;
#else
  typedef unsigned long PCSC_DWORD;
  typedef long PCSC_LONG;
#endif

typedef PCSC_DWORD * LPPCSC_DWORD,* PPCSC_DWORD;

typedef PCSC_LONG * LPPCSC_LONG,* PPCSC_LONG;

#ifdef __cplusplus
extern "C" {
#endif

#ifndef WINSCARDAPI
#define WINSCARDAPI
#endif
#ifndef WINSCARDDATA
#define WINSCARDDATA
#endif

        typedef long SCARDCONTEXT;
        typedef SCARDCONTEXT *PSCARDCONTEXT;
        typedef SCARDCONTEXT *LPSCARDCONTEXT;
        typedef long SCARDHANDLE;
        typedef SCARDHANDLE *PSCARDHANDLE;
        typedef SCARDHANDLE *LPSCARDHANDLE;

typedef struct _SCARD_IO_REQUEST{
    PCSC_LONG dwProtocol;   // Protocol identifier
    PCSC_LONG cbPciLength;  // Protocol Control Information Length
} SCARD_IO_REQUEST, *PSCARD_IO_REQUEST, *LPSCARD_IO_REQUEST;
typedef const SCARD_IO_REQUEST *LPCSCARD_IO_REQUEST;

WINSCARDDATA extern const SCARD_IO_REQUEST
    g_rgSCardT0Pci,
    g_rgSCardT1Pci,
    g_rgSCardRawPci;
#define SCARD_PCI_T0  (&g_rgSCardT0Pci)
#define SCARD_PCI_T1  (&g_rgSCardT1Pci)
#define SCARD_PCI_RAW (&g_rgSCardRawPci)

#define SCARD_AUTOALLOCATE (PCSC_DWORD)(-1)

#define SCARD_SCOPE_USER     0  // The context is a user context, and any
                                // database operations are performed within the
                                // domain of the user.
#define SCARD_SCOPE_TERMINAL 1  // The context is that of the current terminal,
                                // and any database operations are performed
                                // within the domain of that terminal.  (The
                                // calling application must have appropriate
                                // access permissions for any database actions.)
#define SCARD_SCOPE_SYSTEM    2 // The context is the system context, and any
                                // database operations are performed within the
                                // domain of the system.  (The calling
                                // application must have appropriate access
                                // permissions for any database actions.)

//
////////////////////////////////////////////////////////////////////////////////
//
//  Card/Reader Communication Services
//
//      The following services provide means for communication with the card.
//

#define SCARD_SHARE_EXCLUSIVE 1 // This application is not willing to share this
                                // card with other applications.
#define SCARD_SHARE_SHARED    2 // This application is willing to share this
                                // card with other applications.
#define SCARD_SHARE_DIRECT    3 // This application demands direct control of
                                // the reader, so it is not available to other
                                // applications.

#define SCARD_LEAVE_CARD      0 // Don't do anything special on close
#define SCARD_RESET_CARD      1 // Reset the card on close
#define SCARD_UNPOWER_CARD    2 // Power down the card on close
#define SCARD_EJECT_CARD      3 // Eject the card on close

#define MAXIMUM_ATTR_STRING_LENGTH 32   // Nothing bigger than this from getAttr
#define MAXIMUM_SMARTCARD_READERS  10   // Limit the readers on the system

#define SCARD_ATTR_VALUE(Class, Tag) ((((ULONG)(Class)) << 16) | ((ULONG)(Tag)))
#define SCARD_CLASS_VENDOR_INFO     1   
#define SCARD_CLASS_COMMUNICATIONS  2   
#define SCARD_CLASS_PROTOCOL        3   
#define SCARD_CLASS_POWER_MGMT      4   
#define SCARD_CLASS_SECURITY        5   
#define SCARD_CLASS_MECHANICAL      6   
#define SCARD_CLASS_VENDOR_DEFINED  7   
#define SCARD_CLASS_IFD_PROTOCOL    8   
#define SCARD_CLASS_ICC_STATE       9   
#define SCARD_CLASS_SYSTEM     0x7fff   
#define SCARD_ATTR_VENDOR_NAME SCARD_ATTR_VALUE(SCARD_CLASS_VENDOR_INFO, 0x0100) 
#define SCARD_ATTR_VENDOR_IFD_TYPE SCARD_ATTR_VALUE(SCARD_CLASS_VENDOR_INFO, 0x0101) 
#define SCARD_ATTR_VENDOR_IFD_VERSION SCARD_ATTR_VALUE(SCARD_CLASS_VENDOR_INFO, 0x0102) 
#define SCARD_ATTR_VENDOR_IFD_SERIAL_NO SCARD_ATTR_VALUE(SCARD_CLASS_VENDOR_INFO, 0x0103) 

//
// Various constants
//

#define SCARD_ATR_LENGTH 33  // ISO 7816-3 spec.

///////////////////////////////////////////////////////////////////////////////
//
//  Protocol Flag definitions
//

#define SCARD_PROTOCOL_UNDEFINED    0x00000000  // There is no active protocol.
#define SCARD_PROTOCOL_T0           0x00000001  // T=0 is the active protocol.
#define SCARD_PROTOCOL_T1           0x00000002  // T=1 is the active protocol.
#define SCARD_PROTOCOL_RAW          0x00010000  // Raw is the active protocol.

        /*
         * Gets a stringified error response
         */
        char *pcsc_stringify_error(long);

extern WINSCARDAPI PCSC_LONG WINAPI
SCardEstablishContext(
    IN  PCSC_DWORD dwScope,
    IN  LPCVOID pvReserved1,
    IN  LPCVOID pvReserved2,
    OUT LPSCARDCONTEXT phContext);

extern WINSCARDAPI PCSC_LONG WINAPI
SCardControl(
    IN   SCARDHANDLE hCard,
    IN   PCSC_DWORD dwControlCode,
    IN   LPCVOID pbSendBuffer,
    IN   PCSC_DWORD cbSendLength,
    OUT  LPVOID pbRecvBuffer,
    IN   PCSC_DWORD cbRecvLength,
    OUT  LPPCSC_DWORD lpBytesReturned);

extern WINSCARDAPI PCSC_LONG WINAPI 
SCardGetAttrib(
    IN   SCARDHANDLE hCard,
    IN   PCSC_DWORD dwAttrId,
    OUT  LPBYTE pbAttr,
    OUT  LPPCSC_DWORD pcbAttrLen);
extern WINSCARDAPI PCSC_LONG WINAPI
SCardReleaseContext(
    IN      SCARDCONTEXT hContext);

extern WINSCARDAPI PCSC_LONG WINAPI
SCardIsValidContext(
    IN      SCARDCONTEXT hContext);

extern WINSCARDAPI PCSC_LONG WINAPI
SCardConnect(
    IN      SCARDCONTEXT hContext,
    IN      LPCSTR szReader,
    IN      PCSC_DWORD dwShareMode,
    IN      PCSC_DWORD dwPreferredProtocols,
    OUT     LPSCARDHANDLE phCard,
    OUT     LPPCSC_DWORD pdwActiveProtocol);

extern WINSCARDAPI PCSC_LONG WINAPI
SCardReconnect(
    IN      SCARDHANDLE hCard,
    IN      PCSC_DWORD dwShareMode,
    IN      PCSC_DWORD dwPreferredProtocols,
    IN      PCSC_DWORD dwInitialization,
    OUT     LPPCSC_DWORD pdwActiveProtocol);

extern WINSCARDAPI PCSC_LONG WINAPI
SCardDisconnect(
    IN      SCARDHANDLE hCard,
    IN      PCSC_DWORD dwDisposition);

extern WINSCARDAPI PCSC_LONG WINAPI
SCardBeginTransaction(
    IN      SCARDHANDLE hCard);

extern WINSCARDAPI PCSC_LONG WINAPI
SCardEndTransaction(
    IN      SCARDHANDLE hCard,
    IN      PCSC_DWORD dwDisposition);

extern WINSCARDAPI PCSC_LONG WINAPI
SCardCancelTransaction(
    IN      SCARDHANDLE hCard);
//
// NOTE:    This call corresponds to the PC/SC SCARDCOMM::Cancel routine,
//          terminating a blocked SCardBeginTransaction service.
//


extern WINSCARDAPI PCSC_LONG WINAPI
SCardState(
    IN SCARDHANDLE hCard,
    OUT LPPCSC_DWORD pdwState,
    OUT LPPCSC_DWORD pdwProtocol,
    OUT LPBYTE pbAtr,
    IN OUT LPPCSC_DWORD pcbAtrLen);
//
// NOTE:    SCardState is an obsolete routine.  PC/SC has replaced it with
//          SCardStatus.
//

extern WINSCARDAPI PCSC_LONG WINAPI
SCardStatus(
    IN SCARDHANDLE hCard,
    OUT LPSTR szReaderName,
    IN OUT LPPCSC_DWORD pcchReaderLen,
    OUT LPPCSC_DWORD pdwState,
    OUT LPPCSC_DWORD pdwProtocol,
    OUT LPBYTE pbAtr,
    IN OUT LPPCSC_DWORD pcbAtrLen);

extern WINSCARDAPI PCSC_LONG WINAPI
SCardListReaders(
    IN      SCARDCONTEXT hContext,
    IN      LPCSTR mszGroups,
    OUT     LPSTR mszReaders,
    IN OUT  LPPCSC_DWORD pcchReaders);

extern WINSCARDAPI PCSC_LONG WINAPI
SCardTransmit(
    IN SCARDHANDLE hCard,
    IN LPCSCARD_IO_REQUEST pioSendPci,
    IN const BYTE *pbSendBuffer,
    IN PCSC_DWORD cbSendLength,
    IN OUT LPSCARD_IO_REQUEST pioRecvPci,
    OUT LPBYTE pbRecvBuffer,
    IN OUT LPPCSC_DWORD pcbRecvLength);

extern WINSCARDAPI PCSC_LONG WINAPI
    SCardListReaderGroups(
    IN SCARDCONTEXT hContext,
    OUT LPTSTR mszGroups, 
    OUT LPPCSC_DWORD pcchGroups);

typedef struct {
    LPCSTR      szReader;       // reader name
    LPVOID      pvUserData;     // user defined data
    PCSC_DWORD  dwCurrentState; // current state of reader at time of call
    PCSC_DWORD  dwEventState;   // state of reader after state change
    PCSC_DWORD  cbAtr;          // Number of bytes in the returned ATR.
    BYTE        rgbAtr[36];     // Atr of inserted card, (extra alignment bytes)
} SCARD_READERSTATE, *PSCARD_READERSTATE, *LPSCARD_READERSTATE;

#define SCARD_STATE_UNAWARE     0x00000000  // The application is unaware of the
                                            // current state, and would like to
                                            // know.  The use of this value
                                            // results in an immediate return
                                            // from state transition monitoring
                                            // services.  This is represented by
                                            // all bits set to zero.
#define SCARD_STATE_IGNORE      0x00000001  // The application requested that
                                            // this reader be ignored.  No other
                                            // bits will be set.
#define SCARD_STATE_CHANGED     0x00000002  // This implies that there is a
                                            // difference between the state
                                            // believed by the application, and
                                            // the state known by the Service
                                            // Manager.  When this bit is set,
                                            // the application may assume a
                                            // significant state change has
                                            // occurred on this reader.
#define SCARD_STATE_UNKNOWN     0x00000004  // This implies that the given
                                            // reader name is not recognized by
                                            // the Service Manager.  If this bit
                                            // is set, then SCARD_STATE_CHANGED
                                            // and SCARD_STATE_IGNORE will also
                                            // be set.
#define SCARD_STATE_UNAVAILABLE 0x00000008  // This implies that the actual
                                            // state of this reader is not
                                            // available.  If this bit is set,
                                            // then all the following bits are
                                            // clear.
#define SCARD_STATE_EMPTY       0x00000010  // This implies that there is not
                                            // card in the reader.  If this bit
                                            // is set, all the following bits
                                            // will be clear.
#define SCARD_STATE_PRESENT     0x00000020  // This implies that there is a card
                                            // in the reader.
#define SCARD_STATE_ATRMATCH    0x00000040  // This implies that there is a card
                                            // in the reader with an ATR
                                            // matching one of the target cards.
                                            // If this bit is set,
                                            // SCARD_STATE_PRESENT will also be
                                            // set.  This bit is only returned
                                            // on the SCardLocateCard() service.
#define SCARD_STATE_EXCLUSIVE   0x00000080  // This implies that the card in the
                                            // reader is allocated for exclusive
                                            // use by another application.  If
                                            // this bit is set,
                                            // SCARD_STATE_PRESENT will also be
                                            // set.
#define SCARD_STATE_INUSE       0x00000100  // This implies that the card in the
                                            // reader is in use by one or more
                                            // other applications, but may be
                                            // connected to in shared mode.  If
                                            // this bit is set,
                                            // SCARD_STATE_PRESENT will also be
                                            // set.
#define SCARD_STATE_MUTE        0x00000200  // This implies that the card in the
                                            // reader is unresponsive or not
                                            // supported by the reader or
                                            // software.
#define SCARD_STATE_UNPOWERED   0x00000400  // This implies that the card in the
                                            // reader has not been powered up.

#ifndef INFINITE
#define INFINITE 0xFFFFFFFF
#endif
extern WINSCARDAPI PCSC_LONG WINAPI
SCardGetStatusChange(
    IN      SCARDCONTEXT hContext,
    IN      PCSC_DWORD dwTimeout,
    IN OUT  LPSCARD_READERSTATE rgReaderStates,
    IN      PCSC_DWORD cReaders);

#ifdef __cplusplus
}
#endif
#endif /* _WINSCARD_ */

