#ifndef CP_SRDTSC_H
#define CP_SRDTSC_H

#include "srdtsc.h"

#ifdef __cplusplus
extern "C" {
#endif

#if !defined(NO_LEOH_READTSC) /*  cp_read_tsc */
#define cp_read_tsc NULL
#elif defined _M_ARM
static DWORD CPCAPI cp_read_tsc(ULONGLONG *pTSC, LPVOID lpArg)
{
    LARGE_INTEGER i;
    UNUSED(lpArg);
    if (!QueryPerformanceCounter(&i))
	return (DWORD)NTE_FAIL;
    *pTSC = i.QuadPart;
    return S_OK;
}
#elif defined(UNIX) && (defined(IOS) || (defined(DARWIN) && defined(__arm64__)))
// for mach_absolute_time
# include <mach/mach_time.h>
static DWORD cp_read_tsc(ULONGLONG * pTSC, LPVOID lpArg)
{
    UNUSED(lpArg);
    *pTSC = mach_absolute_time();
    return S_OK;
}
#elif defined(ANDROID) || defined(KOS) || ( defined(LINUX) && defined(PROCESSOR_TYPE) && (PROCESSOR_TYPE == PROC_TYPE_ARM || PROCESSOR_TYPE == PROC_TYPE_ARM64 || PROCESSOR_TYPE == PROC_TYPE_MIPS32 || PROCESSOR_TYPE == PROC_TYPE_RISCV64) )
// for clock_gettime
# include <time.h>
static inline DWORD cp_read_tsc(ULONGLONG *pTSC, LPVOID lpArg)
{
    struct timespec t;
    const long ns_in_s = 1000000000;

    UNUSED(lpArg);
    if (0 != clock_gettime(CLOCK_REALTIME, &t))
	return (DWORD)NTE_FAIL;
    *pTSC = t.tv_nsec;
    *pTSC += (ULONGLONG)t.tv_sec * ns_in_s;
    return S_OK;
}
#else
# error No TSC source defined
#endif /*   cp_read_tsc */

#ifdef __cplusplus
}
#endif

#endif /* CP_SRDTSC_H */
