/*
 * Copyright (c) 2000,  -
 *
 *         
 * ,     ,    ,  
 *  :
 *
 * 1)       
 *         ,   
 *        .
 *
 * 2)       
 *         ,   
 *           /   ,
 *      .
 *
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 *
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef PROCESSOR_TYPE_H_INCLUDED
#define PROCESSOR_TYPE_H_INCLUDED

/* Code types for USE_CODE #define */
#define USE_CODE_C	    1
#define USE_CODE_ASM	    2
#define USE_CODE_ASM64	    3
#define USE_CODE_ASM_E2K64  4
#define USE_CODE_ASM_ARM64  5

/* Processor types for PROCESSOR_TYPE #define */
#define PROC_TYPE_SPARC 1
#define PROC_TYPE_I386  2
#define PROC_TYPE_X64	3
#define PROC_TYPE_PPC32	4
#define PROC_TYPE_PPC64	5
#define PROC_TYPE_ARM	6
#define PROC_TYPE_ARM64 7
#define PROC_TYPE_MIPS32 8
#define PROC_TYPE_E2K32 9
#define PROC_TYPE_E2K64 10
#define PROC_TYPE_RISCV64 11

#if !defined(PROCESSOR_TYPE)
    /*
     *   :
     * TODO:XXX    MSDN
     */
#  if defined(_WIN32)
#    if defined(_M_IX86)
#      define PROCESSOR_TYPE PROC_TYPE_I386
#    elif defined(_M_ARM64)
#      define PROCESSOR_TYPE PROC_TYPE_ARM64
#    elif defined(_M_ARM64EC)
#      define PROCESSOR_TYPE PROC_TYPE_ARM64
#    elif defined(_M_X64)
#      define PROCESSOR_TYPE PROC_TYPE_X64
#    endif //defined(_M_IX86) or defined(_M_X64)
#  endif //defined(_WIN32)
#endif //defined(PROCESSOR_TYPE)
     /*
      *     Mac OS X, AIX, Solaris  .
      * PROCESSOR_TYPE   configure
      */
#if !defined(PROCESSOR_TYPE)
      /*
       *      :
       * Agner Fog, "Calling conventions for different C++
       * compilers and operating systems",
       * <http://www.agner.org/optimize/calling_conventions.pdf>
       */
#  if defined(__amd64) || defined(__x86_64__)
#    define PROCESSOR_TYPE PROC_TYPE_X64
#  elif defined(__i386__) || defined(__i386)
#    define PROCESSOR_TYPE PROC_TYPE_I386
#  elif defined(__powerpc64__)
       /* Linux/PPC64 */
#    define PROCESSOR_TYPE PROC_TYPE_PPC64
#  elif defined(__powerpc__) || defined(__POWERPC__)
       /*
	*   IBM
	* <http://publib.boulder.ibm.com/infocenter/comphelp/v8v101/index.jsp?topic=%2Fcom.ibm.xlcpp8a.doc%2Fcompiler%2Fref%2Fruopt64b.htm>
	* TODO:XX  ,    
	*/
#    if __64BIT__ 
#      define PROCESSOR_TYPE PROC_TYPE_PPC64
#    else
#      define PROCESSOR_TYPE PROC_TYPE_PPC32
#    endif
	/*
	 *   Oracle(Sun)
	 * <http://docs.oracle.com/cd/E19060-01/stud8.compiler/817-0926/Comp_Options_App.html#15342>
	 * TODO:XX  ,    
	 */
#  elif defined(__sparc)
#    define PROCESSOR_TYPE PROC_TYPE_SPARC
#  elif defined(__sparcv9)
       // TODO:XXX :
       // D:\4_0\build\CSP\src\RuNetCSP\param.c
       // D:\4_0\build\CSP\src\RuNetCSP\G28147C.c
#    define PROCESSOR_TYPE PROC_TYPE_SPARC
#  elif defined(__arm64__) || defined(__aarch64__)
#    define PROCESSOR_TYPE PROC_TYPE_ARM64
#  elif defined(__ARM_ARCH__) || defined(__arm__)
       // TODO:
       //  
       // , -  ARM-  
#    define PROCESSOR_TYPE PROC_TYPE_ARM
#  elif defined(__mips__)
#    define PROCESSOR_TYPE PROC_TYPE_MIPS32
#  elif defined(__e2k__)
#    if defined(__ptr64__)
#       define PROCESSOR_TYPE PROC_TYPE_E2K64
#    else
#       define PROCESSOR_TYPE PROC_TYPE_E2K32
#    endif 
#  elif defined(__riscv)
#	define PROCESSOR_TYPE PROC_TYPE_RISCV64
#  endif
#endif //defined(PROCESSOR_TYPE)
#if !defined(PROCESSOR_TYPE)
#  error "PROCESSOR_TYPE - Can't autodected"
#endif //defined(PROCESSOR_TYPE)

#if !defined(USE_CODE)
#  if defined(DISABLE_SSE_AVX) || defined (_M_ARM64) || defined (_M_ARM64EC)
#    define USE_CODE USE_CODE_C
#  else // defined(DISABLE_SSE_AVX)
#    if PROCESSOR_TYPE == PROC_TYPE_I386
#      define USE_CODE USE_CODE_ASM
#    elif PROCESSOR_TYPE == PROC_TYPE_X64
#      define USE_CODE USE_CODE_ASM64
#    elif PROCESSOR_TYPE == PROC_TYPE_E2K64
#      define USE_CODE USE_CODE_ASM_E2K64
#    elif PROCESSOR_TYPE == PROC_TYPE_ARM64
#      define USE_CODE USE_CODE_ASM_ARM64
#    else
#      define USE_CODE USE_CODE_C
#    endif /* PROCESSOR_TYPE_* */
#  endif // defined(DISABLE_SSE_AVX)
#endif /* !USE_CODE */
#if !defined(USE_CODE)
#  error "USE_CODE - Can't autodected"
#endif // !defined(USE_CODE)

       //TODO:  
       //TODO:XXXX - HAVE_MMX_INSTRUCTIONS    
#if !defined(HAVE_MMX_INSTRUCTIONS)
#  if (PROCESSOR_TYPE == PROC_TYPE_X64) || \
      (PROCESSOR_TYPE == PROC_TYPE_I386 && !defined(IOS))
#    define HAVE_MMX_INSTRUCTIONS 1 //    
				    //  FPU
#  endif /* PROCESSOR_TYPE_* */
#endif /* !defined(HAVE_MMX_INSTRUCTIONS) */

#if !defined(SIZEOF_VOID_P)
#  if PROCESSOR_TYPE == PROC_TYPE_SPARC
#     if defined(__sparcv9)
#	define SIZEOF_VOID_P 8
#     else
#	define SIZEOF_VOID_P 4
#     endif /* __sparcv9 */
#  elif PROCESSOR_TYPE == PROC_TYPE_I386 || PROCESSOR_TYPE == PROC_TYPE_PPC32 || PROCESSOR_TYPE == PROC_TYPE_MIPS32 || PROCESSOR_TYPE == PROC_TYPE_E2K32 || PROCESSOR_TYPE == PROC_TYPE_ARM
#    define SIZEOF_VOID_P 4
#  elif PROCESSOR_TYPE == PROC_TYPE_X64 || PROCESSOR_TYPE == PROC_TYPE_PPC64 || PROCESSOR_TYPE == PROC_TYPE_ARM64 || PROCESSOR_TYPE == PROC_TYPE_E2K64 || PROCESSOR_TYPE == PROC_TYPE_RISCV64
#    define SIZEOF_VOID_P 8
#  else 
#    error PROCESSOR_TYPE not defined
#  endif /* PROCESSOR_TYPE */
#endif /* !defined(SIZEOF_VOID_P) */

#if PROCESSOR_TYPE == PROC_TYPE_SPARC || PROCESSOR_TYPE == PROC_TYPE_PPC32 || PROCESSOR_TYPE == PROC_TYPE_PPC64 || ( defined(__BYTE_ORDER__) && __BYTE_ORDER__ == __ORDER_BIG_ENDIAN__ )
#define WORDS_BIGENDIAN 1
#endif

#endif // PROCESSOR_TYPE_H_INCLUDED
