/*!
* \file $RCSfile$
* \version $Revision: 294270 $
* \date $Date:: 2025-07-04 13:26:09 +0300#$
* \author $Author: dedal $
*
* \brief   atlcrypt.h   ATL Microsoft.
* 
*   .
*/
#ifndef _ATLCRYPT2_H_INCLUDED
#define _ATLCRYPT2_H_INCLUDED
#include <list>

#include "atldef2.h"

#ifndef UNIX
#pragma warning (push)
#pragma warning (disable:4838)
#endif
#include <atlbase.h>
#ifndef UNIX
#pragma warning (pop)

#pragma warning (push)
#pragma warning (disable:6387)
#pragma warning (disable:6309)
#endif
#include <atlcrypt.h>
#ifndef UNIX
#pragma warning (pop)

#pragma warning (push)
#endif
#include <atlmem.h>
#ifndef UNIX
#pragma warning (pop)

#pragma warning (push)
#endif
#include <atlstr.h>
#ifndef UNIX
#pragma warning (pop)

#pragma warning (push)
#pragma warning (disable:6387)
#endif
#include <atlfile.h>
#ifndef UNIX
#pragma warning (pop)
#endif

#ifdef WINCRYPTEX
#define CPCSP_C_SOURCE 30
#include "cpcsp/WinCryptEx.h"
#endif // WINCRYPTEX

#ifdef CRYPTUI
#include "cryptui.h"
#pragma comment(lib, "cryptui.lib")
#endif // CRYPTUI

#ifdef READPKIOBJECT
#include <atlenc.h>
#endif // READPKIOBJECT

#include "atlalloc2.h"
#include "cpcsp/cp_shared_ptr.h"
#ifndef _WIN32
#ifdef CRYPT_DECODE_SHARE_OID_STRING_FLAG
#undef CRYPT_DECODE_SHARE_OID_STRING_FLAG
#define CRYPT_DECODE_SHARE_OID_STRING_FLAG 0
#endif
#endif

typedef const CMSG_CMS_SIGNER_INFO * PCCMSG_CMS_SIGNER_INFO;
typedef const CRYPT_ALGORITHM_IDENTIFIER * PCCRYPT_ALGORITHM_IDENTIFIER;
typedef const CRYPT_ATTRIBUTE * PCCRYPT_ATTRIBUTE;
typedef const CRYPT_ATTRIBUTES * PCCRYPT_ATTRIBUTES;

namespace ATL2 {

extern ATL::CCryptProv EmptyProv;
class CCertStore;
class CCertChainContext;

class CCertContext
{
protected:
    PCCERT_CONTEXT m_pUserCert;
public:
    CCertContext() throw();
    CCertContext(const CCertContext& ctx) throw();
    CCertContext &operator=(const CCertContext& ctx) throw();
    explicit CCertContext(PCCERT_CONTEXT pUserCert,
	BOOL bTakeOwnership = FALSE) throw();
    ~CCertContext() throw();

    void Attach(PCCERT_CONTEXT pUserCert, BOOL bTakeOwnership = FALSE) throw();
    void Destroy() throw();
    PCCERT_CONTEXT Detach() throw();
    PCCERT_CONTEXT Duplicate() const throw();

    HRESULT Uninitialize() throw();
    HRESULT Initialize(const BYTE *pbCertEncoded, DWORD cbCertEncoded,
	DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING)
	throw();

    HRESULT Initialize(const CStringBlob& certEncoded,
	DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING)
	throw();

    HRESULT DetachFromStore() throw();

    HRESULT GetProperty(DWORD dwPropId,
	__out_bcount_part_opt(*pcbData, *pcbData) void *pvData,
	__inout DWORD *pcbData) throw();
    HRESULT GetProperty(DWORD dwPropId, CStringBlob &Result); //throw(...);
    HRESULT SetProperty (DWORD dwPropId, DWORD dwFlags,
	const void *pvData) throw();

    // CERT_KEY_IDENTIFIER_PROP_ID property
    HRESULT GetKeyIdentifier (
	__out_bcount_part(*pcbData, *pcbData) BYTE *pbData,
	__inout DWORD *pcbData) throw();
    HRESULT GetKeyIdentifier (CStringBlob &Result); //throw(...);
    HRESULT SetKeyIdentifier (const CRYPT_DATA_BLOB *keyId) throw();

    // CERT_KEY_PROV_INFO_PROP_ID property
    HRESULT GetKeyProvInfo (
	__out_bcount_part(*pcbData, *pcbData) CRYPT_KEY_PROV_INFO *provInfo,
	__inout DWORD *pcbData) throw();
    HRESULT GetKeyProvInfo (CStringBlob &Result); //throw(...);
    HRESULT SetKeyProvInfo (const CRYPT_KEY_PROV_INFO *provInfo) throw();

    //CERT_PUBLIC_KEY_INFO
    HRESULT GetPublicKeyInfo(CERT_PUBLIC_KEY_INFO * keyInfo);

    HRESULT GetNameString (DWORD dwType, DWORD dwFlags,
	void *pvTypePara, LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();

    HRESULT GetSubjectNameString (DWORD dwType,
	void *pvTypePara, LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetIssuerNameString (DWORD dwType,
	void *pvTypePara, LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();

    HRESULT GetSubjectNameStringEmail(LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetSubjectNameStringToStr(DWORD dwStrType, LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetSubjectNameStringAttr(LPCSTR szAttrOid, LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetSubjectNameStringSimple(LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetSubjectNameStringFriendlyDisplay(LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetSubjectNameStringDns(LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetSubjectNameStringUrl(LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetSubjectNameStringUpn(LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();

    HRESULT GetIssuerNameStringEmail(LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetIssuerNameStringToStr(DWORD dwStrType, LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetIssuerNameStringAttr(LPCSTR szAttrOid, LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetIssuerNameStringSimple(LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetIssuerNameStringFriendlyDisplay(LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetIssuerNameStringDns(LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetIssuerNameStringUrl(LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetIssuerNameStringUpn(LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();

    HRESULT GetNameString (DWORD dwType, DWORD dwFlags, void *pvTypePara,
	ATL::CAtlString& Result); //throw(...);
    HRESULT GetSubjectNameString (DWORD dwType, void *pvTypePara,
	ATL::CAtlString& Result); //throw(...);
    HRESULT GetIssuerNameString (DWORD dwType, void *pvTypePara,
	ATL::CAtlString& Result); //throw(...);

    HRESULT GetSubjectNameStringEmail(ATL::CAtlString& Result); //throw(...);
    HRESULT GetSubjectNameStringToStr(DWORD dwStrType,
	ATL::CAtlString& Result); //throw(...);
    HRESULT GetSubjectNameStringAttr(LPCSTR szAttrOid,
	ATL::CAtlString& Result); //throw(...);
    HRESULT GetSubjectNameStringSimple(ATL::CAtlString& Result); //throw(...);
    HRESULT GetSubjectNameStringFriendlyDisplay(ATL::CAtlString& Result); //throw(...);
    HRESULT GetSubjectNameStringDns(ATL::CAtlString& Result); //throw(...);
    HRESULT GetSubjectNameStringUrl(ATL::CAtlString& Result); //throw(...);
    HRESULT GetSubjectNameStringUpn(ATL::CAtlString& Result); //throw(...);

    HRESULT GetIssuerNameStringEmail(ATL::CAtlString& Result); //throw(...);
    HRESULT GetIssuerNameStringToStr(DWORD dwStrType,
	ATL::CAtlString& Result); //throw(...);
    HRESULT GetIssuerNameStringAttr(LPCSTR szAttrOid,
	ATL::CAtlString& Result); //throw(...);
    HRESULT GetIssuerNameStringSimple(ATL::CAtlString& Result); //throw(...);
    HRESULT GetIssuerNameStringFriendlyDisplay(ATL::CAtlString& Result); //throw(...);
    HRESULT GetIssuerNameStringDns(ATL::CAtlString& Result); //throw(...);
    HRESULT GetIssuerNameStringUrl(ATL::CAtlString& Result); //throw(...);
    HRESULT GetIssuerNameStringUpn(ATL::CAtlString& Result); //throw(...);

    HRESULT AddToStore (CCertStore& CertStore,
	DWORD dwAddDisposition, PCCERT_CONTEXT *ppStoreContext = NULL) const throw();

    HRESULT AddToStoreAlways (CCertStore& CertStore,
	PCCERT_CONTEXT *ppStoreContext = NULL) const throw();
    HRESULT AddToStoreNew (CCertStore& CertStore,
	PCCERT_CONTEXT *ppStoreContext = NULL) const throw();
    HRESULT AddToStoreReplaceExisting (CCertStore& CertStore,
	PCCERT_CONTEXT *ppStoreContext = NULL) const throw();
    HRESULT AddToStoreReplaceExistingInheritProperties (CCertStore& CertStore,
	PCCERT_CONTEXT *ppStoreContext = NULL) const throw();
    HRESULT AddToStoreUseExisting (CCertStore& CertStore,
	PCCERT_CONTEXT *ppStoreContext = NULL) const throw();

    HRESULT DeleteFromStore() throw();

    HRESULT InitPrivateKey(DWORD dwFlags, HCRYPTPROV *phCryptProv,
	DWORD *pdwKeySpec, BOOL *pfCallerFreeProv,
	void *pvReserved = NULL) throw();

    HRESULT BuildChain(
	PCCERT_CHAIN_CONTEXT* ppChainContext,
	HCERTSTORE hAdditionalStore = NULL,
	DWORD dwFlags
	    = CERT_CHAIN_REVOCATION_CHECK_CHAIN_EXCLUDE_ROOT
	    | CERT_CHAIN_DISABLE_AUTH_ROOT_AUTO_UPDATE,
	LPFILETIME pTime = NULL,
	HCERTCHAINENGINE hChainEngine = NULL,
	PCERT_CHAIN_PARA pChainPara = NULL) throw();

    HRESULT BuildChain(
	CCertChainContext& cChainContext,
	HCERTSTORE hAdditionalStore = NULL,
	DWORD dwFlags
	    = CERT_CHAIN_REVOCATION_CHECK_CHAIN_EXCLUDE_ROOT
	    | CERT_CHAIN_DISABLE_AUTH_ROOT_AUTO_UPDATE,
	LPFILETIME pTime = NULL,
	HCERTCHAINENGINE hChainEngine = NULL,
	PCERT_CHAIN_PARA pChainPara = NULL) throw();
    void GetValidFromFiletime(FILETIME *notBefore); //throw(...);
    void GetValidToFiletime(FILETIME *notAfter); //throw(...);

#ifdef _WIN32
    void GetValidFrom(ATL::CAtlString& Result, LCID locale = LOCALE_USER_DEFAULT ); //throw(...);
    void GetValidTo(ATL::CAtlString& Result, LCID locale = LOCALE_USER_DEFAULT ); //throw(...);
#  ifdef WINCRYPTEX
    BOOL GetPrivateKeyValidityPeriod(ATL::CAtlString& notBefore,
				    ATL::CAtlString& notAfter, LCID locale = LOCALE_USER_DEFAULT ); //throw(...);
    BOOL GetPrivateKeyValidityPeriodFiletime(FILETIME *notBefore,
				    FILETIME *notAfter); //throw(...);
#  endif // WINCRYPTEX
    void GetSerialNumberString(ATL::CAtlString& Result); //throw(...);
#endif //_WIN32

#if !defined(_WIN32) || _WIN32_WINNT >= 0x0501
    //    CryptBinaryToString
    //,   XP.
    HRESULT GetThumbprintString(ATL::CAtlString& Result); //throw(...);
#endif // !defined(_WIN32) || _WIN32_WINNT >= 0x0501

    inline PCCERT_CONTEXT GetHandle() const throw()
    {
	return m_pUserCert;
    }
};

class CCRLContext
{
protected:
    PCCRL_CONTEXT m_pUserCRL;
public:
    CCRLContext() throw();
    CCRLContext(const CCRLContext& ctx) throw();
    CCRLContext &operator=(const CCRLContext& ctx) throw();
    explicit CCRLContext(PCCRL_CONTEXT pUserCRL,
	BOOL bTakeOwnership = FALSE) throw();
    ~CCRLContext() throw();

    void Attach(PCCRL_CONTEXT pUserCRL, BOOL bTakeOwnership = FALSE) throw();
    void Destroy() throw();
    PCCRL_CONTEXT Detach() throw();
    PCCRL_CONTEXT Duplicate() const throw();

    HRESULT Uninitialize() throw();
    HRESULT Initialize(const BYTE *pbCRLEncoded, DWORD cbCRLEncoded,
	DWORD dwCRLEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING)
	throw();

    HRESULT DetachFromStore() throw();

    HRESULT GetProperty(DWORD dwPropId, void *pvData, DWORD *pcbData) throw();
    HRESULT SetProperty(DWORD dwPropId, DWORD dwFlags,
	const void *pvData) throw();

    HRESULT GetProperty(DWORD dwPropId, CStringBlob &Result); //throw(...);

#ifdef _WIN32
    HRESULT GetNameString(DWORD dwStrType, LPTSTR pszNameString,
	DWORD *pdwNameStringLen) throw();
    HRESULT GetNameString(DWORD dwStrType, ATL::CAtlString &NameString) throw();
#endif //_WIN32

    HRESULT AddToStore (CCertStore& CertStore,
	DWORD dwAddDisposition, PCCRL_CONTEXT *ppStoreContext = NULL) throw();

    HRESULT AddToStoreAlways (CCertStore& CertStore,
	PCCRL_CONTEXT *ppStoreContext = NULL) throw();
    HRESULT AddToStoreNew (CCertStore& CertStore,
	PCCRL_CONTEXT *ppStoreContext = NULL) throw();
    HRESULT AddToStoreReplaceExisting (CCertStore& CertStore,
	PCCRL_CONTEXT *ppStoreContext = NULL) throw();
    HRESULT AddToStoreReplaceExistingInheritProperties (CCertStore& CertStore,
	PCCRL_CONTEXT *ppStoreContext = NULL) throw();
    HRESULT AddToStoreUseExisting (CCertStore& CertStore,
	PCCRL_CONTEXT *ppStoreContext = NULL) throw();

    HRESULT DeleteFromStore() throw();

    inline PCCRL_CONTEXT GetHandle() const throw()
    {
	return m_pUserCRL;
    }
};

class CCertChainContext
{
protected:
    PCCERT_CHAIN_CONTEXT m_pCertChain;
public:
    CCertChainContext() throw();
    CCertChainContext(const CCertChainContext& ctx) throw();
    CCertChainContext &operator=(const CCertChainContext& ctx) throw();
    explicit CCertChainContext(PCCERT_CHAIN_CONTEXT pCertChain,
	BOOL bTakeOwnership = FALSE) throw();
    ~CCertChainContext() throw();

    void Attach(PCCERT_CHAIN_CONTEXT pCertChain, BOOL bTakeOwnership = FALSE) throw();
    void Destroy() throw();
    PCCERT_CHAIN_CONTEXT Detach() throw();
    PCCERT_CHAIN_CONTEXT Duplicate() const throw();

    HRESULT Uninitialize() throw();

    inline PCCERT_CHAIN_CONTEXT GetHandle() const throw()
    {
	return m_pCertChain;
    }
};

class CCertChainEngine
{
protected:
    HCERTCHAINENGINE m_hChainEngine;
public:
    CCertChainEngine() throw();
    explicit CCertChainEngine(HCERTCHAINENGINE hChainEngine) throw();
    ~CCertChainEngine() throw();

    void Attach(HCERTCHAINENGINE hChainEngine) throw();
    void Destroy() throw();
    HCERTCHAINENGINE Detach() throw();
    HRESULT Create(PCERT_CHAIN_ENGINE_CONFIG pConfig) throw();

    HRESULT Uninitialize() throw();


    inline HCERTCHAINENGINE GetHandle() const throw()
    {
	return m_hChainEngine;
    }
private:
    CCertChainEngine(const CCertChainEngine& ctx) throw();
};

#ifdef CRYPTUI
class CCertContextUI: public CCertContext
{
public:
    HRESULT View (HWND hwndParent, LPCWSTR szTitle, DWORD dwFlags = 0,
	BOOL *pPropertiesChanged = NULL, HCERTSTORE hAdditionalStore = NULL) throw();
    HRESULT View (HWND hwndParent, LPCSTR szTitle, DWORD dwFlags = 0,
	BOOL *pPropertiesChanged = NULL, HCERTSTORE hAdditionalStore = NULL) throw();
};

class CCRLContextUI: public CCRLContext
{
public:
    HRESULT View(HWND hwndParent, LPCSTR szTitle, 
	DWORD dwFlags = 0) throw();
    HRESULT View (HWND hwndParent, LPCWSTR szTitle, 
	DWORD dwFlags = 0) throw();
    HRESULT CCRLContextUI::WizExport(
	HWND hwndParent, LPCWSTR szWizardTitle,
	DWORD dwFlags = 0) throw();
};
#endif // CRYPTUI

//       
//,    ,    . 
//   MS,     , 
//    .
//
//  ,   CertCloseStore()  
//CERT_CLOSE_STORE_CHECK_FLAG.   ,  CertDuplicateStore()
//     ,     
//CertCloseStore(CERT_CLOSE_STORE_CHECK_FLAG)    .
//   CertDuplicateStore()   CCertStore
//  .     HCERTSTORE  ,
//     shared_ptr<HCERTSTORE>. 
// CCertStore     CertDuplicateStore(),  
//     shared_ptr.
//
//  HCERTSTORE  CCertStore    
// CertDuplicateStore.     AttachWeak(hStore).
//   ,       
//.       .
//,    HCERTSTORE,   .
//   ,     
//       ,   
//-,    -.
//
//  HCERTSTORE  CCertStore   
//    AttachOwnership(hStore).
//
//     ,    
//Detach, ..  HCERTSTORE  shared_ptr ,    
// .
//
// ,  CCertStore      
//      ,   ,
//, CCryptProv. CCryptProv, ,   ,  
//       ,   
// ,    .
//
//,    CCertStore   ,   
//       ( 
// new      m_collectedStores).
//     -   
//        , 
//       Destroy().   
//    .
//
//       
//.
class CCertStore
{
protected:
    NS_SHARED_PTR::shared_ptr<HCERTSTORE> m_phStore;
private:
    std::list<CCertStore> m_collectedStores;
public:
    CCertStore();
    CCertStore(const CCertStore &other);
    CCertStore& operator=(const CCertStore& store);
    ~CCertStore() throw();

    HRESULT AttachOwnership(HCERTSTORE hStore) throw();
    HRESULT AttachWeak(HCERTSTORE hStore) throw();
    void Destroy();

    HRESULT Initialize (LPCSTR lpszStoreProvider,
	DWORD dwMsgAndCertEncodingType, ATL::CCryptProv& CryptProv,
	DWORD dwFlagsLow, DWORD dwFlagsHigh, const void *pvPara) throw();

    HRESULT InitMemoryStore (
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv *CryptProv = NULL) throw();

    HRESULT InitFileStore (HANDLE hStoreFileHandle,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv) throw();

    HRESULT InitFileNameStore (LPCWSTR wszStoreFileName,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT InitFileNameStore (LPCSTR szStoreFileName,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT InitCollectionStore (
	DWORD dwFlagsLow = 0, ATL::CCryptProv& CryptProv = EmptyProv) throw();

#ifdef _WIN32
    HRESULT InitRegStore (HKEY hStoreRegKey,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv) throw();
#endif

    HRESULT InitSystemStore (LPCWSTR wszStoreName,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv) throw();

    HRESULT InitSystemStore (LPCSTR szStoreName,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv) throw();

    HRESULT InitSystemRegistryStore (LPCWSTR wszStoreName,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv) throw();

    HRESULT InitSystemRegistryStore (LPCSTR szStoreName,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv) throw();

    HRESULT InitPhysicalStore (LPCWSTR wszStoreName,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv) throw();

    HRESULT InitMsgStore (HCRYPTMSG hStoreMsg,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT InitPkcs7Store (CRYPT_DATA_BLOB *pEncodedStore,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT InitSerializedStore (CRYPT_DATA_BLOB *pSerializedStore,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv) throw();

    HRESULT InitPkcs7Store (const CStringBlob& EncodedStore,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT InitSerializedStore (const CStringBlob& SerializedStore,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv) throw();

    HRESULT InitLdapStore (LPCWSTR wszLdapQuery,
	DWORD dwFlagsLow = 0, DWORD dwFlagsHigh = 0,
	ATL::CCryptProv& CryptProv = EmptyProv) throw();

    HRESULT OpenSystemStore (
	LPCTSTR szSubsystemProtocol,
	ATL::CCryptProv& CryptProv = EmptyProv) throw();

    HRESULT OpenContainerExtensionStore(
	ATL::CCryptProv &cProv) throw();

    HRESULT AddStoreToCollection (const CCertStore& SiblingStore, 
	DWORD dwUpdateFlag = 0, DWORD dwPriority = 0) throw();

    HRESULT EnumCertificatesInStore(PCCERT_CONTEXT pPrevCertContext,
	PCCERT_CONTEXT *ppCertContext) throw();
    HRESULT EnumCertificatesInStore(CCertContext& cert) throw();

    HRESULT EnumCRLsInStore(PCCRL_CONTEXT pPrevCRLContext,
	PCCRL_CONTEXT *ppCRLContext) throw();

#if defined _WIN32
    static HRESULT EnumSystemStore (DWORD dwFlags,
	void *pvSystemStoreLocationPara,
	void *pvArg, PFN_CERT_ENUM_SYSTEM_STORE pfnEnum) throw();
#endif // _WIN32

#if defined _WIN32
    static HRESULT EnumPhysicalStore (const void *pvSystemStore,
	DWORD dwFlags, void *pvArg,
	PFN_CERT_ENUM_PHYSICAL_STORE pfnEnum) throw();
#endif // _WIN32

#if defined _WIN32
    static HRESULT EnumSystemStoreLocation(void *pvArg,
	PFN_CERT_ENUM_SYSTEM_STORE_LOCATION pfnEnum,
	DWORD dwFlags = 0) throw();
#endif // _WIN32

#if defined _WIN32
    HRESULT GetProperty(DWORD dwPropId, BYTE * pbData,
	DWORD * pdwDataLen) throw();
#endif // _WIN32

#if defined _WIN32
    HRESULT SetProperty(DWORD dwPropId, CRYPT_DATA_BLOB *pbData,
	DWORD dwFlags = 0) throw();
#endif /* _WIN32 */

#if defined _WIN32
    HRESULT GetProperty(DWORD dwPropId, CStringBlob &Result); //throw(...);
#endif /* _WIN32 */

#if defined _WIN32
    HRESULT SetProperty(DWORD dwPropId, const CStringBlob &Data,
	DWORD dwFlags = 0) throw();
#endif /* _WIN32 */

#if defined _WIN32
    HRESULT GetLocalizedName(LPWSTR wszBuf, DWORD *pdwStringLength) throw();
#endif /* _WIN32 */

#if defined _WIN32
    HRESULT SetLocalizedName(LPWSTR wszBuf) throw();
#endif /* _WIN32 */

#if defined _WIN32
    HRESULT GetLocalizedName(ATL::CAtlStringW& Result); //throw(...);
#endif /* _WIN32 */

    HRESULT Commit() throw();

    HRESULT AddCertificateContext (PCCERT_CONTEXT pCertContext,
	DWORD dwAddDisposition, PCCERT_CONTEXT *ppStoreContext = NULL) throw();

    HRESULT AddCertificateContextAlways (PCCERT_CONTEXT pCertContext,
	PCCERT_CONTEXT *ppStoreContext = NULL) throw();
    HRESULT AddCertificateContextNew (PCCERT_CONTEXT pCertContext,
	PCCERT_CONTEXT *ppStoreContext = NULL) throw();
    HRESULT AddCertificateContextReplaceExisting (
	PCCERT_CONTEXT pCertContext,
	PCCERT_CONTEXT *ppStoreContext = NULL) throw();
    HRESULT AddCertificateContextReplaceExistingInheritProperties (
	PCCERT_CONTEXT pCertContext,
	PCCERT_CONTEXT *ppStoreContext = NULL) throw();
    HRESULT AddCertificateContextUseExisting (PCCERT_CONTEXT pCertContext,
	PCCERT_CONTEXT *ppStoreContext = NULL) throw();

    HRESULT AddEncodedCertificate (
	const BYTE *pbCertEncoded, DWORD cbCertEncoded, DWORD dwAddDisposition,
	PCCERT_CONTEXT *ppCertContext = NULL,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT AddEncodedCertificateAlways (
	const BYTE *pbCertEncoded, DWORD cbCertEncoded,
	PCCERT_CONTEXT *ppCertContext = NULL,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT AddEncodedCertificateNew (
	const BYTE *pbCertEncoded, DWORD cbCertEncoded,
	PCCERT_CONTEXT *ppCertContext = NULL,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT AddEncodedCertificateReplaceExisting (
	const BYTE *pbCertEncoded, DWORD cbCertEncoded,
	PCCERT_CONTEXT *ppCertContext = NULL,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT AddEncodedCertificateReplaceExistingInheritProperties (
	const BYTE *pbCertEncoded, DWORD cbCertEncoded,
	PCCERT_CONTEXT *ppCertContext = NULL,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT AddEncodedCertificateUseExisting (
	const BYTE *pbCertEncoded, DWORD cbCertEncoded,
	PCCERT_CONTEXT *ppCertContext = NULL,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT AddEncodedCertificate (const CStringBlob& CertEncoded,
	DWORD dwAddDisposition, PCCERT_CONTEXT *ppCertContext = NULL,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT AddEncodedCertificateAlways (const CStringBlob& CertEncoded,
	PCCERT_CONTEXT *ppCertContext = NULL,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT AddEncodedCertificateNew (const CStringBlob& CertEncoded,
	PCCERT_CONTEXT *ppCertContext = NULL,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT AddEncodedCertificateReplaceExisting (const CStringBlob& CertEncoded,
	PCCERT_CONTEXT *ppCertContext = NULL,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT AddEncodedCertificateReplaceExistingInheritProperties (
	const CStringBlob& CertEncoded, PCCERT_CONTEXT *ppCertContext = NULL,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT AddEncodedCertificateUseExisting (const CStringBlob& CertEncoded,
	PCCERT_CONTEXT *ppCertContext = NULL,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT AddCRLContext (PCCRL_CONTEXT pCrlContext,
	DWORD dwAddDisposition, PCCRL_CONTEXT *ppStoreContext = NULL) throw();

    HRESULT AddCRLContextAlways (PCCRL_CONTEXT pCrlContext,
	PCCRL_CONTEXT *ppStoreContext = NULL) throw();
    HRESULT AddCRLContextNew (PCCRL_CONTEXT pCrlContext,
	PCCRL_CONTEXT *ppStoreContext = NULL) throw();
    HRESULT AddCRLContextReplaceExisting (
	PCCRL_CONTEXT pCrlContext,
	PCCRL_CONTEXT *ppStoreContext = NULL) throw();
    HRESULT AddCRLContextReplaceExistingInheritProperties (
	PCCRL_CONTEXT pCrlContext,
	PCCRL_CONTEXT *ppStoreContext = NULL) throw();
    HRESULT AddCRLContextUseExisting (PCCRL_CONTEXT pCrlContext,
	PCCRL_CONTEXT *ppStoreContext = NULL) throw();

    HRESULT CountCertsInStore (DWORD& dwCertNumber) throw();

    HRESULT Save (DWORD dwSaveAs, DWORD dwSaveTo, void* pvSaveToPara,
	DWORD dwFlags = 0, DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT SaveAsStore (DWORD dwSaveTo, void* pvSaveToPara) throw();
    HRESULT SaveAsPkcs7 (DWORD dwSaveTo, void* pvSaveToPara,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT SaveToFile (DWORD dwSaveAs, HANDLE hStoreFileHandle,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT SaveToMemory (DWORD dwSaveAs, CRYPT_DATA_BLOB *pStoreBlob,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT SaveToMemory (DWORD dwSaveAs, CStringBlob& StoreBlob,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING); //throw(...);
    HRESULT SaveToFileName (DWORD dwSaveAs, LPCWSTR wszStoreFileName,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT SaveToFileName (DWORD dwSaveAs, LPCSTR szStoreFileName,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT SaveAsStoreToFile (HANDLE hStoreFileHandle) throw();
    HRESULT SaveAsStoreToMemory (CRYPT_DATA_BLOB *pStoreBlob) throw();
    HRESULT SaveAsStoreToMemory (CStringBlob& StoreBlob); //throw(...);
    HRESULT SaveAsStoreToFileName (LPCWSTR wszStoreFileName) throw();
    HRESULT SaveAsStoreToFileName (LPCSTR szStoreFileName) throw();

    HRESULT SaveAsPkcs7ToFile (HANDLE hStoreFileHandle,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT SaveAsPkcs7ToMemory (CRYPT_DATA_BLOB *pStoreBlob,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT SaveAsPkcs7ToMemory (CStringBlob& StoreBlob,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT SaveAsPkcs7ToFileName (LPCWSTR wszStoreFileName,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT SaveAsPkcs7ToFileName (LPCSTR szStoreFileName,
	DWORD dwMsgAndCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT FindCertificate (PCCERT_CONTEXT *ppCertContext, DWORD dwFindType,
	const void* pvFindPara = NULL, DWORD dwFindFlags = 0,
	PCCERT_CONTEXT pPrevCertContext = NULL,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT FindCertificate (CCertContext &ctx, DWORD dwFindType, 
	const void* pvFindPara = NULL, DWORD dwFindFlags = 0, 
	DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT FindCertificateExisting (PCCERT_CONTEXT pCertToFind,
	PCCERT_CONTEXT *ppCertContext = NULL, DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT FindCertificateExisting (CCertContext& CertToFind,
        CCertContext *pCert = NULL, DWORD dwCertEncodingType
        = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();

    HRESULT FindCRL (PCCRL_CONTEXT *ppCrlContext, DWORD dwFindType,
	const void* pvFindPara = NULL, DWORD dwFindFlags = 0,
	PCCRL_CONTEXT pPrevCrlContext = NULL,
	DWORD dwCertEncodingType = 0) throw();
    HRESULT FindCRL (CCRLContext &ctx, DWORD dwFindType, 
	const void* pvFindPara = NULL, DWORD dwFindFlags = 0, 
	PCCRL_CONTEXT pPrevCrlContext = NULL, 
	DWORD dwCertEncodingType = 0) throw();

    inline HCERTSTORE GetHandle() const throw()
    {
	return *m_phStore;
    }
};

#ifdef CRYPTUI
class CCertStoreUI: public CCertStore
{
public:
    HRESULT SelectStore (HWND hwndParent,
	LPCWSTR szTitle = NULL, LPCWSTR szDisplayString = NULL,
	DWORD dwEnumFlags = CERT_SYSTEM_STORE_CURRENT_USER,
	DWORD dwFlags = CRYPTUI_ALLOW_PHYSICAL_STORE_VIEW
	| CRYPTUI_RETURN_READ_ONLY_STORE) throw();
    HRESULT SelectStore (HWND hwndParent,
	LPCSTR szTitle, LPCSTR szDisplayString = NULL,
	DWORD dwEnumFlags = CERT_SYSTEM_STORE_CURRENT_USER,
	DWORD dwFlags = CRYPTUI_ALLOW_PHYSICAL_STORE_VIEW
	| CRYPTUI_RETURN_READ_ONLY_STORE) throw();

    HRESULT SelectCertificate (HWND hwndParent, CCertContext &ctx,
	LPCWSTR szTitle = NULL, LPCWSTR szDisplayString = NULL,
	DWORD dwDontUseColumn = 0, HCERTSTORE hSelectedCertStore = NULL,
	PFNCFILTERPROC pFilterCallback = NULL,
	PFNCCERTDISPLAYPROC pDisplayCallback = NULL,
	void *pvCallbackData = NULL) throw();
    HRESULT SelectCertificate (HWND hwndParent, CCertContext &ctx,
	LPCSTR szTitle, LPCSTR szDisplayString = NULL,
	DWORD dwDontUseColumn = 0, HCERTSTORE hSelectedCertStore = NULL,
	PFNCFILTERPROC pFilterCallback = NULL,
	PFNCCERTDISPLAYPROC pDisplayCallback = NULL,
	void *pvCallbackData = NULL) throw();
    HRESULT SelectCertificate (HWND hwndParent, CCertContext &ctx,
	LPCWSTR szTitle, DWORD dwCertificateDlgFlags,
	LPCWSTR szCertificateDlgTitle = NULL, LPCWSTR szDisplayString = NULL,
	DWORD dwDontUseColumn = 0, HCERTSTORE hSelectedCertStore = NULL,
	PFNCFILTERPROC pFilterCallback = NULL) throw();
    HRESULT SelectCertificate (HWND hwndParent, CCertContext &ctx,
	LPCSTR szTitle, DWORD dwCertificateDlgFlags,
	LPCSTR szCertificateDlgTitle, LPCSTR szDisplayString = NULL,
	DWORD dwDontUseColumn = 0, HCERTSTORE hSelectedCertStore = NULL,
	PFNCFILTERPROC pFilterCallback = NULL) throw();

    static BOOL WINAPI SelectCertSetViewParamDisplayCallbackW (
	PCCERT_CONTEXT pCertContext, HWND hWndSelCertDlg,
	void *pvCallbackData) throw();
    static BOOL WINAPI SelectCertSetViewParamDisplayCallbackA (
	PCCERT_CONTEXT pCertContext, HWND hWndSelCertDlg,
	void *pvCallbackData) throw();
};
#endif // CRYPTUI

class CCryptProvEx: public ATL::CCryptProv
{
public:
    CCryptProvEx() throw();
    CCryptProvEx( const CCryptProvEx& prov ) throw();
    CCryptProvEx( const CCryptProv& prov ) throw();
    explicit CCryptProvEx( HCRYPTPROV hProv, BOOL bTakeOwnership = FALSE ) throw();
    //~CCryptProvEx() throw();

    CCryptProvEx& operator=( const CCryptProvEx& prov ) throw();
    CCryptProvEx& operator=( const CCryptProv& prov ) throw();

    HRESULT InitializeByCertificate(
	const CCertContext& Cert, DWORD dwFlags,
	__out_opt DWORD *pdwKeySpec = NULL,
	void *pvReserved = NULL) throw();

    static HRESULT SetClientHwnd(__in_opt HWND hWnd) throw();
    HRESULT SetKeyExchangePin(__in_z_opt LPCSTR szPin) throw();
    HRESULT SetKeyExchangePin(__in_z_opt LPCWSTR wszPin) throw();

    HRESULT SetSignaturePin(__in_z_opt LPCSTR szPin) throw();
    HRESULT SetSignaturePin(__in_z_opt LPCWSTR wszPin) throw();

    HRESULT SetUseHardwareRng() throw();
    HRESULT GetKeySetType( DWORD * pdwType ) throw( );
    HRESULT GenRandom(ULONG nLength, __out_ecount(nLength) BYTE *pbBuffer) throw();
    HRESULT GenRandom(ULONG nLength, CStringBlob& Result); //throw(...);

    HRESULT ExportPublicKeyInfo (
	__out_bcount_part(*pcbInfo, *pcbInfo) CERT_PUBLIC_KEY_INFO *pInfo,
	__inout DWORD *pcbInfo, DWORD dwKeySpec,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING) throw();
    HRESULT ExportPublicKeyInfo (CStringBlob &Result,
	DWORD dwKeySpec, DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING); //throw(...);

    HRESULT SignAndEncodeCertificate(
        __out_bcount_part(*pcbEncoded, *pcbEncoded) BYTE *pbEncoded,
        __inout DWORD *pcbEncoded, LPCSTR lpszStructType,
        const void *pvStructInfo,
        PCRYPT_ALGORITHM_IDENTIFIER pSignatureAlgorithm,
        DWORD dwKeySpec,
        DWORD dwCertEncodingType
        = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING);
    HRESULT SignAndEncodeCertificate(
        CStringBlob &Result, LPCSTR lpszStructType,
        const void *pvStructInfo,
        PCRYPT_ALGORITHM_IDENTIFIER pSignatureAlgorithm,
        DWORD dwKeySpec,
        DWORD dwCertEncodingType
        = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING); //throw(...)

    HRESULT GetName(
	__out_ecount_part_z(*pdwLength, *pdwLength) LPSTR szBuf,
	__inout DWORD *pdwLength) throw();
    HRESULT GetName(ATL::CAtlStringA& Result); //throw(...);
    HRESULT GetName(ATL::CAtlStringW& Result); //throw(...);

    HRESULT GetContainer(
	__out_ecount_part_z(*pdwLength,*pdwLength) LPSTR szBuf,
	__inout DWORD *pdwLength) throw();
    HRESULT GetContainer(ATL::CAtlStringA& Result); //throw(...);
    HRESULT GetContainer(ATL::CAtlStringW& Result); //throw(...);

    HRESULT GetUniqueContainer(
	__out_ecount_part_z(*pdwLength,*pdwLength) LPSTR szBuf,
	__inout DWORD *pdwLength) throw();
    HRESULT GetUniqueContainer(ATL::CAtlStringA &Result); //throw(...);
    HRESULT GetUniqueContainer(ATL::CAtlStringW &Result); //throw(...);

#ifdef WINCRYPTEX
    //   CSP 
    HRESULT GetFQCN(
	__out_ecount_part_z(*pdwLength, *pdwLength) LPSTR szBuf,
	__inout DWORD *pdwLength) throw();
    HRESULT GetFQCN(ATL::CAtlStringA &Result); //throw(...);
    HRESULT GetFQCN(ATL::CAtlStringW &Result); //throw(...);

    HRESULT GetSelectContainer(
	__out_ecount_part_z(*pdwLength,*pdwLength) LPSTR szBuf,
	__inout DWORD *pdwLength, BOOL bFullyQualified = FALSE) throw();
    HRESULT GetSelectContainer(ATL::CAtlStringA &Result,
	BOOL bFullyQualified = FALSE); //throw(...);
    HRESULT GetSelectContainer(ATL::CAtlStringW &Result,
	BOOL bFullyQualified = FALSE); //throw(...);

    HRESULT GetHashOid(
	__out_ecount_part_z(*pdwLength,*pdwLength) LPSTR szBuf,
	__inout DWORD *pdwLength) throw();
    HRESULT GetHashOid(ATL::CAtlStringA& Result); //throw(...);
    HRESULT SetHashOid(__in_z LPCSTR szBuf) throw();

    HRESULT GetCipherOid(
	__out_ecount_part_z(*pdwLength,*pdwLength) LPSTR szBuf,
	__inout DWORD *pdwLength) throw();
    HRESULT GetCipherOid(ATL::CAtlStringA& Result); //throw(...);
    HRESULT SetCipherOid(__in_z LPCSTR szBuf) throw();

    HRESULT GetSignatureOid(
	__out_ecount_part_z(*pdwLength,*pdwLength) LPSTR szBuf,
	__inout DWORD *pdwLength) throw();
    HRESULT GetSignatureOid(ATL::CAtlStringA& Result); //throw(...);
    HRESULT SetSignatureOid(__in_z LPCSTR szBuf) throw();

    HRESULT GetDhOid(
	__out_ecount_part_z(*pdwLength,*pdwLength) LPSTR szBuf,
	__inout DWORD *pdwLength) throw();
    HRESULT GetDhOid(ATL::CAtlStringA& Result); //throw(...);
    HRESULT SetDhOid(__in_z LPCSTR szBuf) throw();

    HRESULT SetContainerExtension(
	const CONTAINER_EXTENSION *pContExt) throw();

    //     ,   
    //   ,    ,  
    //  .

    //   ,  32- (  x64)
    //        PP_SET_PIN
    //      
    HRESULT GetInternalCryptProv(DWORD *pdwInternalProv) throw();
    HRESULT InternalLoadKey() throw();
    HRESULT SetPin(const CRYPT_PIN_INFO *pPinInfo) throw();
#endif //WINCRYPTEX
};

class CCryptHashEx : public ATL::CCryptHash
{
public:
    HRESULT Initialize(ATL::CCryptProv &Prov, ALG_ID Algid,
	__in_opt LPCTSTR szText = NULL) throw();
    HRESULT Initialize(ATL::CCryptProv &Prov, ALG_ID Algid,
        ATL::CCryptKey &key) throw();
    HRESULT GetValue(
	__out_ecount_part_opt(*pdwSize, *pdwSize) BYTE *pBuf,
	__inout DWORD *pdwSize) throw();
    HRESULT Sign(
	__out_ecount_part_opt(*pdwSigLen, *pdwSigLen) BYTE *pbSignature,
	__inout DWORD *pdwSigLen, DWORD dwFlags = 0,
	DWORD dwKeySpec = AT_SIGNATURE) throw();
    HRESULT GetValue(CStringBlob &Result); //throw(...);
    HRESULT Sign(
	CStringBlob &Signature, DWORD dwFlags = 0,
	DWORD dwKeySpec = AT_SIGNATURE); //throw(...);
    HRESULT VerifySignature(
	CStringBlob &Signature, ATL::CCryptKey &PubKey,
	DWORD dwFlags = 0); //throw(...)
    HRESULT AddSessionKey(ATL::CCryptKey &SessionKey,
	DWORD dwFlags = 0); //throw(...)
}; // class CCryptHashEx

#ifdef WINCRYPTEX
class CCryptGOST3411Hash : public ATL::CCryptHash
{
public:
    HRESULT Initialize(ATL::CCryptProv &Prov, LPCTSTR szText = NULL) throw();
}; // class CCryptGOST3411Hash
class CCryptGOST3411HashEx : public CCryptHashEx
{
public:
    HRESULT Initialize(ATL::CCryptProv &Prov, LPCTSTR szText = NULL) throw();
}; // class CCryptGOST3411Hash

#endif //WINCRYPTEX

//  ATL::CCryptKey    CAPI.
//       ,    CAPI, ..
//   ,      ..
//    ,     
// ,   CryptDuplicateKey.  
// , , ,     
//   .  ,    
// ATL::CCryptProv,  ATL::CCryptKey   
//       HCRYPTKEY.
//
//      .
// -,   ,   
//  ,   ,  
// ,     .
//
//    ATL2::CCryptKeyEx .  
//    ,    
//   ATL::CCryptKey   ,  
//  . ..  ATL2::CCryptKeyEx 
//   ,     
// ATL::CCryptKey.
//
// ,     HCRYPTKEY, 
//      ATL::CCryptKey  ATL2::CCryptKeyEx,
//    ,     
//    ATL::CCryptKey.    
//    , 
//      ATL2::CCryptKeyEx  
//      ::CCryptKey.
class CCryptKeyEx
{
public:
    CCryptKeyEx(const ATL::CCryptKey& key) throw();

    HRESULT GetCertificate(
	__out_ecount_part_opt(*pdwCertDataLen,*pdwCertDataLen)
	BYTE *pbCertData,
	__inout DWORD *pdwCertDataLen) throw();
    HRESULT SetCertificate(const BYTE *pbCertData) throw();

    HRESULT GetCertificate(CStringBlob& Result); //throw(...);
    HRESULT SetCertificate(const CStringBlob& Result); //throw(...);

    HRESULT GetX(
	__out_ecount_part_opt(*pdwXLen,*pdwXLen) BYTE *pbX,
	__inout DWORD *pdwXLen) throw();
    HRESULT SetX(const _CRYPTOAPI_BLOB *pBlobX) throw();

    HRESULT GetX(CStringBlob& Result); //throw(...);
    HRESULT SetX(const CStringBlob& Result); //throw(...);

    HRESULT GetParam(DWORD dwParam, CStringBlob& Result,
	DWORD dwFlags = 0); //throw(...);
    HRESULT SetParam(DWORD dwParam, const CStringBlob& Result,
	DWORD dwFlags = 0); //throw(...);

    HRESULT Decrypt(BOOL final,
	__inout_ecount_part(*pdwDataLen,*pdwDataLen) BYTE *pbData,
	__inout DWORD *pdwDataLen,
	ATL::CCryptHash &Hash = ATL::CCryptHash::EmptyHash, DWORD dwFlags = 0)
	throw();
    HRESULT Decrypt(__in_ecount(dwCipherTextLen) const BYTE *pbCipherText,
	DWORD dwCipherTextLen,
	__out_ecount_part(*pdwPlainTextLen,*pdwPlainTextLen) BYTE *pbPlainText,
	__inout DWORD *pdwPlainTextLen,
	ATL::CCryptHash &Hash = ATL::CCryptHash::EmptyHash, DWORD dwFlags = 0)
	throw();

#ifdef WINCRYPTEX
    HRESULT GetHashOid(CStringBlob& Result); //throw(...);
    HRESULT SetHashOid(const CStringBlob& Value); //throw(...);
    HRESULT GetDhOid(CStringBlob& Result); //throw(...);
    HRESULT SetDhOid(const CStringBlob& Value); //throw(...);
    HRESULT GetCipherOid(CStringBlob& Result); //throw(...);
    HRESULT SetCipherOid(const CStringBlob& Value); //throw(...);
#endif //WINCRYPTEX

    HRESULT ExportSimpleBlob(CStringBlob& Result,
	ATL::CCryptKey &ExpKey, DWORD dwFlags = 0); //throw(...);
    HRESULT ExportPublicKeyBlob(CStringBlob& Result,
	ATL::CCryptKey &ExpKey = ATL::CCryptKey::EmptyKey,
	DWORD dwFlags = 0); //throw(...);
    HRESULT ExportPrivateKeyBlob(CStringBlob& Result,
	ATL::CCryptKey &ExpKey, DWORD dwFlags = 0); //throw(...);

    HRESULT GetKeySpec(DWORD *pdwKeySpec) throw();

    HRESULT GetKeyLength(DWORD * pdwKeyLen) throw();

    HRESULT GetNotAfter(FILETIME * pNotAfter) throw();

protected:
    ATL::CCryptKey& m_key;
private:
    //    
    CCryptKeyEx(const CCryptKeyEx&);
    CCryptKeyEx& operator= (const CCryptKeyEx&);
};

// class CCryptImportKeyEx
// Forms a key from an imported key blob
class CCryptImportKeyEx : public ATL::CCryptImportKey
{
public:
    HRESULT Initialize(
	ATL::CCryptProv &Prov, const CStringBlob& Value,
	ATL::CCryptKey &PubKey, DWORD dwFlags = 0); //throw(...);
}; // class CCryptImportKeyEx

class CCryptImportPublicKeyInfo : public ATL::CCryptKey
{
public:
    HRESULT Initialize(ATL::CCryptProv &Prov,
	const PCERT_PUBLIC_KEY_INFO pInfo,
	DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING
	) throw();
}; // class CCryptImportPublicKeyInfo

// class CCryptRandomDefferedKey
//     
class CCryptRandomDefferedKey : public ATL::CCryptRandomKey
{
public:
    HRESULT Initialize(ATL::CCryptProv &Prov,
	ALG_ID algid = CALG_RC4,
	DWORD dwFlags = CRYPT_EXPORTABLE) throw();
    HRESULT Generate() throw();
}; // class CCryptRandomKey

// class CCryptUserKey
// Obtains the user's key exchange or signature key pair.
class CCryptUserKey : public ATL::CCryptKey
{
public:
    HRESULT Initialize(ATL::CCryptProv &Prov, DWORD dwKeySpec) throw();
    HRESULT Create(ATL::CCryptProv &Prov, DWORD dwKeySpec,
	DWORD dwKeyLen = 0, DWORD dwFlags = 0) throw();
}; // class CCryptUserKey


HRESULT CopyKeyParam(ATL::CCryptKey& keyDst, DWORD pp, ATL::CCryptKey& keySrc,
    DWORD dwSetFlags = 0); //throw(...);

//  CCryptKeyNotDuplicatable    HCRYPTKEY
//  ,   ATL::CCryptKey,   HCRYPTKEY,  
//   CryptDuplicateKey() (,  
//   CSP).      ,  
//    ATL::CCryptKey.   .
//          ATL::CCryptKey,
//        .
class CCryptKeyNotDuplicatable : public ATL::CCryptKey
{
public:
    explicit CCryptKeyNotDuplicatable(HCRYPTKEY hKey) throw();
    ~CCryptKeyNotDuplicatable() throw();
};

// COidInfoEnum -     OID-
//
//   COidInfoEnum  :
// 1.  ,  - MyEnum,
//           OnOidInfo.
// 2.       MyEnum.
// 3.    Enum.
// :
//
//class MyEnum: public COidInfoEnum {
// public:
//    virtual bool OnOidInfo(PCCRYPT_OID_INFO pInfo)
//    {
//      // , ,  ,   OID-,
//      // ,  ,     
//      //  (CB_ADDSTRING).
//	return true; // true    
//    }
//};
//MyEnum myenum;
//HRESULT hr = myenum.Enum();
class COidInfoEnum
{
public:
    HRESULT Enum(DWORD dwGroupId);
    virtual bool OnOidInfo(PCCRYPT_OID_INFO pInfo) = 0;
    virtual ~COidInfoEnum() {}
private:
    static BOOL WINAPI EnumOIDInfoCallback(PCCRYPT_OID_INFO pInfo, void *pvArg);
};

// The CRYPT_EXT_OR_ATTR_OID_GROUP_ID,
// CRYPT_ENHKEY_USAGE_OID_GROUP_ID, CRYPT_POLICY_OID_GROUP_ID or
// CRYPT_TEMPLATE_OID_GROUP_ID don't have a dwValue.

// The CRYPT_*_ALG_OID_GROUP_ID's have an Algid.

// CHashAlgorithmOidEnum -     OID-
//   
//
//   CHashAlgorithmOidEnum  :
// 1.  ,  - MyEnum,
//           OnHashAlg.
// 2.       MyEnum.
// 3.    Enum.
// :
//
//class MyEnum: public CHashAlgorithmOidEnum {
// public:
//    virtual bool OnHashAlg(LPCSTR pszOID, LPCWSTR pwszName, ALG_ID Algid)
//    {
//      // , ,  ,   OID-,
//      // ,  ,     
//      //  (CB_ADDSTRING).
//	return true; // true    
//    }
//};
//MyEnum myenum;
//HRESULT hr = myenum.Enum();
class CHashAlgorithmOidEnum: public COidInfoEnum
{
public:
    HRESULT Enum();
    virtual bool OnHashAlg(LPCSTR pszOID, LPCWSTR pwszName, ALG_ID Algid) = 0;
protected:
    virtual bool OnOidInfo(PCCRYPT_OID_INFO pInfo);
};

// The CRYPT_*_ALG_OID_GROUP_ID's have an Algid.

// CEncryptionAlgorithmOidEnum -     OID-
//  
//
//   CEncryptionAlgorithmOidEnum  :
// 1.  ,  - MyEnum,
//           OnEncryptAlg.
// 2.       MyEnum.
// 3.    Enum.
// :
//
//class MyEnum: public CEncryptionAlgorithmOidEnum {
// public:
//    virtual bool OnEncryptAlg(LPCSTR pszOID, LPCWSTR pwszName, ALG_ID Algid)
//    {
//      // , ,  ,   OID-,
//      // ,  ,     
//      //  (CB_ADDSTRING).
//	return true; // true    
//    }
//};
//MyEnum myenum;
//HRESULT hr = myenum.Enum();
class CEncryptionAlgorithmOidEnum: public COidInfoEnum
{
public:
    HRESULT Enum();
    virtual bool OnEncryptAlg(LPCSTR pszOID, LPCWSTR pwszName, ALG_ID Algid) = 0;
protected:
    virtual bool OnOidInfo(PCCRYPT_OID_INFO pInfo);
};

// The CRYPT_*_ALG_OID_GROUP_ID's have an Algid.
//
// CRYPT_PUBKEY_ALG_OID_GROUP_ID has the following optional ExtraInfo:
//  DWORD[0] - Flags. CRYPT_OID_INHIBIT_SIGNATURE_FORMAT_FLAG can be set to
//             inhibit the reformatting of the signature before
//             CryptVerifySignature is called or after CryptSignHash
//             is called. CRYPT_OID_USE_PUBKEY_PARA_FOR_PKCS7_FLAG can
//             be set to include the public key algorithm's parameters
//             in the PKCS7's digestEncryptionAlgorithm's parameters.
//             CRYPT_OID_NO_NULL_ALGORITHM_PARA_FLAG can be set to omit
//             NULL parameters when encoding.

// CPublicKeyAlgorithmOidEnum -     OID-
//   
//
//   CPublicKeyAlgorithmOidEnum  :
// 1.  ,  - MyEnum,
//           OnPubKeyAlg.
// 2.       MyEnum.
// 3.    Enum.
// :
//
//class MyEnum: public CPublicKeyAlgorithmOidEnum {
// public:
//    virtual bool OnPubKeyAlg(LPCSTR pszOID, LPCWSTR pwszName, ALG_ID Algid,
//        DWORD dwFlags)
//    {
//      // , ,  ,   OID-,
//      // ,  ,     
//      //  (CB_ADDSTRING).
//	return true; // true    
//    }
//};
//MyEnum myenum;
//HRESULT hr = myenum.Enum();
class CPublicKeyAlgorithmOidEnum: public COidInfoEnum
{
public:
    HRESULT Enum();
    // dwFlags    :
    // CRYPT_OID_INHIBIT_SIGNATURE_FORMAT_FLAG
    // CRYPT_OID_USE_PUBKEY_PARA_FOR_PKCS7_FLAG
    // CRYPT_OID_NO_NULL_ALGORITHM_PARA_FLAG
    virtual bool OnPubKeyAlg(LPCSTR pszOID, LPCWSTR pwszName, ALG_ID Algid,
	DWORD dwFlags) = 0;
protected:
    virtual bool OnOidInfo(PCCRYPT_OID_INFO pInfo);
};

// The CRYPT_*_ALG_OID_GROUP_ID's have an Algid.

// CRYPT_SIGN_ALG_OID_GROUP_ID has the following optional ExtraInfo:
//  DWORD[0] - Public Key Algid.
//  DWORD[1] - Flags. Same as above for CRYPT_PUBKEY_ALG_OID_GROUP_ID.
//  DWORD[2] - Optional CryptAcquireContext(CRYPT_VERIFYCONTEXT)'s dwProvType.
//             If omitted or 0, uses Public Key Algid to select
//             appropriate dwProvType for signature verification.

// CSignatureAlgorithmOidEnum -     OID-
//  
//
//   CSignatureAlgorithmOidEnum  :
// 1.  ,  - MyEnum,
//           OnSignAlg.
// 2.       MyEnum.
// 3.    Enum.
// :
//
//class MyEnum: public CSignatureAlgorithmOidEnum {
// public:
//    virtual bool OnSignAlg(LPCSTR pszOID, LPCWSTR pwszName, ALG_ID Algid,
//         ALG_ID PublicKeyAlgid, DWORD dwFlags, DWORD dwProvType)
//    {
//      // , ,  ,   OID-,
//      // ,  ,     
//      //  (CB_ADDSTRING).
//	return true; // true    
//    }
//};
//MyEnum myenum;
//HRESULT hr = myenum.Enum();
class CSignatureAlgorithmOidEnum: public COidInfoEnum
{
public:
    HRESULT Enum();
    // dwFlags    :
    // CRYPT_OID_INHIBIT_SIGNATURE_FORMAT_FLAG
    // CRYPT_OID_USE_PUBKEY_PARA_FOR_PKCS7_FLAG
    // CRYPT_OID_NO_NULL_ALGORITHM_PARA_FLAG
    virtual bool OnSignAlg(LPCSTR pszOID, LPCWSTR pwszName, ALG_ID Algid,
	ALG_ID PublicKeyAlgid, DWORD dwFlags, DWORD dwProvType) = 0;
protected:
    virtual bool OnOidInfo(PCCRYPT_OID_INFO pInfo);
};

// The CRYPT_RDN_ATTR_OID_GROUP_ID has a dwLength.

// CRYPT_RDN_ATTR_OID_GROUP_ID has the following optional ExtraInfo:
//  Array of DWORDs:
//   [0 ..] - Null terminated list of acceptable RDN attribute
//            value types. An empty list implies CERT_RDN_PRINTABLE_STRING,
//            CERT_RDN_UNICODE_STRING, 0.

// CRdnAttributeOidEnum -     OID-
//  RDN
//
//   CRdnAttributeOidEnum  :
// 1.  ,  - MyEnum,
//           OnRdnAttr.
// 2.       MyEnum.
// 3.    Enum.
// :
//
//class MyEnum: public CRdnAttributeOidEnum {
// public:
//    virtual bool OnRdnAttr(LPCSTR pszOID, LPCWSTR pwszName, DWORD dwLength,
//        DWORD *pdwAcceptableValueTypes, DWORD cAcceptableValueTypes)
//    {
//      // , ,  ,   OID-,
//      // ,  ,     
//      //  (CB_ADDSTRING).
//	return true; // true    
//    }
//};
//MyEnum myenum;
//HRESULT hr = myenum.Enum();
class CRdnAttributeOidEnum: public COidInfoEnum
{
public:
    HRESULT Enum();
    // dwLength - ,   
    // pdwAcceptableValueTypes -    DWORD-
    // cAcceptableValueTypes -   (DWORD-)
    //   pdwAcceptableValueTypes,
    //      
    virtual bool OnRdnAttr(LPCSTR pszOID, LPCWSTR pwszName, DWORD dwLength,
	DWORD *pdwAcceptableValueTypes, DWORD cAcceptableValueTypes) = 0;
protected:
    virtual bool OnOidInfo(PCCRYPT_OID_INFO pInfo);
};

// The CRYPT_EXT_OR_ATTR_OID_GROUP_ID,
// CRYPT_ENHKEY_USAGE_OID_GROUP_ID, CRYPT_POLICY_OID_GROUP_ID or
// CRYPT_TEMPLATE_OID_GROUP_ID don't have a dwValue.

// CExtensionOrAttributeOidEnum -     OID-
//   
//
//   CExtensionOrAttributeOidEnum  :
// 1.  ,  - MyEnum,
//           OnExtOrAttr.
// 2.       MyEnum.
// 3.    Enum.
// :
//
//class MyEnum: public CExtensionOrAttributeOidEnum {
// public:
//    virtual bool OnExtOrAttr(LPCSTR pszOID, LPCWSTR pwszName)
//    {
//      // , ,  ,   OID-,
//      // ,  ,     
//      //  (CB_ADDSTRING).
//	return true; // true    
//    }
//};
//MyEnum myenum;
//HRESULT hr = myenum.Enum();
class CExtensionOrAttributeOidEnum: public COidInfoEnum
{
public:
    HRESULT Enum();
    virtual bool OnExtOrAttr(LPCSTR pszOID, LPCWSTR pwszName) = 0;
protected:
    virtual bool OnOidInfo(PCCRYPT_OID_INFO pInfo);
};

// The CRYPT_EXT_OR_ATTR_OID_GROUP_ID,
// CRYPT_ENHKEY_USAGE_OID_GROUP_ID, CRYPT_POLICY_OID_GROUP_ID or
// CRYPT_TEMPLATE_OID_GROUP_ID don't have a dwValue.

// CEnhancedKeyUsageOidEnum -     OID- EKU
//
//   CEnhancedKeyUsageOidEnum  :
// 1.  ,  - MyEnum,
//           OnEnhKeyUsage.
// 2.       MyEnum.
// 3.    Enum.
// :
//
//class MyEnum: public CEnhancedKeyUsageOidEnum {
// public:
//    virtual bool OnEnhKeyUsage(LPCSTR pszOID, LPCWSTR pwszName)
//    {
//      // , ,  ,   OID-,
//      // ,  ,     
//      //  (CB_ADDSTRING).
//	return true; // true    
//    }
//};
//MyEnum myenum;
//HRESULT hr = myenum.Enum();
class CEnhancedKeyUsageOidEnum: public COidInfoEnum
{
public:
    HRESULT Enum();
    virtual bool OnEnhKeyUsage(LPCSTR pszOID, LPCWSTR pwszName) = 0;
protected:
    virtual bool OnOidInfo(PCCRYPT_OID_INFO pInfo);
};

// The CRYPT_EXT_OR_ATTR_OID_GROUP_ID,
// CRYPT_ENHKEY_USAGE_OID_GROUP_ID, CRYPT_POLICY_OID_GROUP_ID or
// CRYPT_TEMPLATE_OID_GROUP_ID don't have a dwValue.

// CPolicyOidEnum -     OID- 
//
//   CPolicyOidEnum  :
// 1.  ,  - MyEnum,
//           OnPolicy.
// 2.       MyEnum.
// 3.    Enum.
// :
//
//class MyEnum: public CPolicyOidEnum {
// public:
//    virtual bool OnPolicy(LPCSTR pszOID, LPCWSTR pwszName)
//    {
//      // , ,  ,   OID-,
//      // ,  ,     
//      //  (CB_ADDSTRING).
//	return true; // true    
//    }
//};
//MyEnum myenum;
//HRESULT hr = myenum.Enum();
class CPolicyOidEnum: public COidInfoEnum
{
public:
    HRESULT Enum();
    virtual bool OnPolicy(LPCSTR pszOID, LPCWSTR pwszName) = 0;
protected:
    virtual bool OnOidInfo(PCCRYPT_OID_INFO pInfo);
};

// The CRYPT_EXT_OR_ATTR_OID_GROUP_ID,
// CRYPT_ENHKEY_USAGE_OID_GROUP_ID, CRYPT_POLICY_OID_GROUP_ID or
// CRYPT_TEMPLATE_OID_GROUP_ID don't have a dwValue.

// CTemplateOidEnum -     OID- 
//
//   CTemplateOidEnum  :
// 1.  ,  - MyEnum,
//           OnTemplate.
// 2.       MyEnum.
// 3.    Enum.
// :
//
//class MyEnum: public CTemplateOidEnum {
// public:
//    virtual bool OnTemplate(LPCSTR pszOID, LPCWSTR pwszName)
//    {
//      // , ,  ,   OID-,
//      // ,  ,     
//      //  (CB_ADDSTRING).
//	return true; // true    
//    }
//};
//MyEnum myenum;
//HRESULT hr = myenum.Enum();
class CTemplateOidEnum: public COidInfoEnum
{
public:
    HRESULT Enum();
    virtual bool OnTemplate(LPCSTR pszOID, LPCWSTR pwszName) = 0;
protected:
    virtual bool OnOidInfo(PCCRYPT_OID_INFO pInfo);
};

//  CFindSignatureAlgPubKeyEnum    
//      (  ALG_ID)   
// (  OID).
//     :
//
// PCCRYPT_OID_INFO pOidInfo = 0;
// CFindSignatureAlgPubKeyEnum findEnum( hashAlgid, szPubKeyAlgOID );
// HRESULT hr = findEnum.FindSignatureAlgorithmOIDInfo(&pOidInfo);
// if(FAILED(hr))
//    return hr;
//
class CFindSignatureAlgPubKeyEnum: private CPublicKeyAlgorithmOidEnum
{
public:
    CFindSignatureAlgPubKeyEnum( ALG_ID hashAlg, const char* szPubKeyAlgOID)
	: m_hashAlg(hashAlg), m_sPubKeyAlgOID(szPubKeyAlgOID),
	m_pOidInfo(0) { }
    HRESULT FindSignatureAlgorithmOIDInfo( PCCRYPT_OID_INFO *ppOidInfo);
private:
    bool OnPubKeyAlg(LPCSTR pszOID, LPCWSTR pwszName, ALG_ID Algid, DWORD dwFlags);

    ALG_ID m_hashAlg;
    ATL::CAtlStringA m_sPubKeyAlgOID;
    PCCRYPT_OID_INFO m_pOidInfo;
};

//  CFindSignatureAlgorithmEnum    
//      (  OID)   
// (  OID).
//     :
//
// PCCRYPT_OID_INFO pOidInfo = 0;
// CFindSignatureAlgorithmEnum findEnum( szHashAlgOID, szPubKeyAlgOID );
// HRESULT hr = findEnum.FindSignatureAlgorithmOIDInfo(&pOidInfo);
// if(FAILED(hr))
//    return hr;
//
class CFindSignatureAlgorithmEnum: private CHashAlgorithmOidEnum
{
public:
    CFindSignatureAlgorithmEnum(const char* szHashAlgOID, const char* szPubKeyAlgOID)
	: m_sHashAlgOID(szHashAlgOID), m_sPubKeyAlgOID(szPubKeyAlgOID),
	m_pOidInfo(0), m_hr(CRYPT_E_NOT_FOUND) {}
    HRESULT FindSignatureAlgorithmOIDInfo( PCCRYPT_OID_INFO *ppOidInfo);
private:
    bool OnHashAlg(LPCSTR pszOID, LPCWSTR pwszName, ALG_ID Algid);

    ATL::CAtlStringA m_sHashAlgOID;
    ATL::CAtlStringA m_sPubKeyAlgOID;
    PCCRYPT_OID_INFO m_pOidInfo;
    HRESULT m_hr;
};


template <typename T> BOOL WINAPI CryptEnumProviderTypesT( DWORD dwIndex,
    DWORD *pdwReserved, DWORD dwFlags, DWORD *pdwProvType, T *szTypeName,
    DWORD *pcbTypeName);
template <> BOOL WINAPI CryptEnumProviderTypesT<char>( DWORD dwIndex,
    DWORD *pdwReserved, DWORD dwFlags, DWORD *pdwProvType, char *szTypeName,
    DWORD *pcbTypeName);
template <> BOOL WINAPI CryptEnumProviderTypesT<wchar_t>( DWORD dwIndex,
    DWORD *pdwReserved, DWORD dwFlags, DWORD *pdwProvType, wchar_t *szTypeName,
    DWORD *pcbTypeName);

template <typename T> BOOL WINAPI CryptEnumProvidersT( DWORD dwIndex,
    DWORD *pdwReserved, DWORD dwFlags, DWORD *pdwProvType, T *szProvName,
    DWORD *pcbProvName);
template <> BOOL WINAPI CryptEnumProvidersT<char>( DWORD dwIndex,
    DWORD *pdwReserved, DWORD dwFlags, DWORD *pdwProvType, char *szProvName,
    DWORD *pcbProvName);
template <> BOOL WINAPI CryptEnumProvidersT<wchar_t>( DWORD dwIndex,
    DWORD *pdwReserved, DWORD dwFlags, DWORD *pdwProvType, wchar_t *szProvName,
    DWORD *pcbProvName);

// CCryptProvidersEnum -     
//
//   CCryptProvidersEnum  :
// 1.  ,  - MyEnum,
//           OnProv.
// 2.       MyEnum.
// 3.    Enum.
// :
//
//class MyEnum: public CCryptProvidersEnum {
// public:
//    virtual bool OnProv(LPCTSTR szProvName, DWORD dwProvType)
//    {
//      // , ,  ,   ,
//      // ,  ,     
//      //  (CB_ADDSTRING).
//	return true; // true    
//    }
//};
//MyEnum myenum;
//HRESULT hr = myenum.Enum();
template <typename T>
class CCryptProvidersEnumT
{
    enum { TempBufferLen = 256, TempBufferByteLen = TempBufferLen*sizeof(T) };
    typedef CTempBufferEx<T, TempBufferByteLen> CTempBuf;
public:
    explicit CCryptProvidersEnumT(ATL::IAtlMemMgr *pMemMgr = &CTempBuf::m_crtHeap);
    HRESULT Enum();
    virtual bool OnProv(const T *szProvName, DWORD dwProvType) = 0;
    virtual ~CCryptProvidersEnumT() { }
private:
    CTempBuf m_TempBuf;
};
typedef CCryptProvidersEnumT<wchar_t> CCryptProvidersEnumW;
typedef CCryptProvidersEnumT<char> CCryptProvidersEnumA;
#ifdef UNICODE
typedef CCryptProvidersEnumW CCryptProvidersEnum;
#else // !UNICODE
typedef CCryptProvidersEnumA CCryptProvidersEnum;
#endif // !UNICODE

// CCryptProviderTypesEnum -     
//
//   CCryptProviderTypesEnum  :
// 1.  ,  - MyEnum,
//           OnType.
// 2.       MyEnum.
// 3.    Enum.
// :
//
//class MyEnum: public CCryptProvidersEnum {
// public:
//    virtual bool OnType(DWORD dwProvType, LPCTSTR szProvName)
//    {
//      // , ,  ,    ,
//      // ,  ,     
//      //  (CB_ADDSTRING).
//	return true; // true    
//    }
//};
//MyEnum myenum;
//HRESULT hr = myenum.Enum();
template <typename T>
class CCryptProviderTypesEnumT
{
    enum { TempBufferLen = 128, TempBufferByteLen = TempBufferLen*sizeof(T) };
    typedef CTempBufferEx<T, TempBufferByteLen> CTempBuf;
public:
    explicit CCryptProviderTypesEnumT(ATL::IAtlMemMgr *pMemMgr = &CTempBuf::m_crtHeap);
    HRESULT Enum();
    virtual bool OnType(DWORD dwProvType, const T *szTypeName) = 0;
    virtual ~CCryptProviderTypesEnumT() { }
private:
    CTempBuf m_TempBuf;
};
typedef CCryptProviderTypesEnumT<wchar_t> CCryptProviderTypesEnumW;
typedef CCryptProviderTypesEnumT<char> CCryptProviderTypesEnumA;
#ifdef UNICODE
typedef CCryptProviderTypesEnumW CCryptProviderTypesEnum;
#else // !UNICODE
typedef CCryptProviderTypesEnumA CCryptProviderTypesEnum;
#endif // !UNICODE


template <typename T> HRESULT CryptGetProvParamAnsiStringT(
    const ATL::CCryptProv &prov, DWORD dwParam, T *szData,
    DWORD *pcbDataLen, DWORD dwFlags);
template <> HRESULT CryptGetProvParamAnsiStringT<char>(
    const ATL::CCryptProv &prov, DWORD dwParam, char *szData,
    DWORD *pcbDataLen, DWORD dwFlags);
template <> HRESULT CryptGetProvParamAnsiStringT<wchar_t>(
    const ATL::CCryptProv &prov, DWORD dwParam, wchar_t *wszData,
    DWORD *pcbDataLen, DWORD dwFlags);
template <typename T> HRESULT CryptGetProvParamUnicodeStringT(
    const ATL::CCryptProv &prov, DWORD dwParam, T *szData,
    DWORD *pcbDataLen, DWORD dwFlags);
template <> HRESULT CryptGetProvParamUnicodeStringT<char>(
    const ATL::CCryptProv &prov, DWORD dwParam, char *szData,
    DWORD *pcbDataLen, DWORD dwFlags);
template <> HRESULT CryptGetProvParamUnicodeStringT<wchar_t>(
    const ATL::CCryptProv &prov, DWORD dwParam, wchar_t *wszData,
    DWORD *pcbDataLen, DWORD dwFlags);
template <typename T> HRESULT CryptGetProvParamStringT(
    const ATL::CCryptProv &prov, DWORD dwParam, T *szData,
    DWORD *pcbDataLen, DWORD dwFlags);

template <typename T>
class CCryptProvContainersEnumT
{
    enum { TempBufferLen = 1024, TempBufferByteLen = TempBufferLen*sizeof(T) };
    typedef CTempBufferEx<T, TempBufferByteLen> CTempBuf;
public:
    explicit CCryptProvContainersEnumT(ATL::IAtlMemMgr *pMemMgr = &CTempBuf::m_crtHeap);
    HRESULT Enum(const ATL::CCryptProv &prov);
    virtual bool OnContainer(const T *szContName) = 0;
#ifdef WINCRYPTEX
    HRESULT EnumFqcn(const ATL::CCryptProv &prov);
    HRESULT EnumUnique(const ATL::CCryptProv &prov);
    virtual bool OnUniqueContainer(const T *szUniqueContName, const T *szContName);
#endif //WINCRYPTEX
private:
    HRESULT Enum(const ATL::CCryptProv &prov, DWORD dwFlags);
    CTempBuf m_TempBuf;
};
typedef CCryptProvContainersEnumT<wchar_t> CCryptProvContainersEnumW;
typedef CCryptProvContainersEnumT<char> CCryptProvContainersEnumA;
#ifdef UNICODE
typedef CCryptProvContainersEnumW CCryptProvContainersEnum;
#else // !UNICODE
typedef CCryptProvContainersEnumA CCryptProvContainersEnum;
#endif // !UNICODE

#ifdef WINCRYPTEX
// CContainerExtensionEnum -     
//
//   CContainerExtensionEnum  :
// 1.  ,  - MyEnum,
//           OnContainerExtension.
// 2.       MyEnum.
// 3.    Enum.
// :
//
//class MyEnum: public CContainerExtensionEnum {
// public:
//    virtual bool OnContainerExtension(LPCSTR szOid, const BYTE* pbValue,
//	DWORD cbValue, BOOL bCritical)
//    {
//      // , ,  ,   ,
//      // ,  ,     
//      //  (CB_ADDSTRING).
//	return true; // true    
//    }
//};
//MyEnum myenum;
//HRESULT hr = myenum.Enum();
class CContainerExtensionEnum {
public:
    HRESULT Enum(const ATL::CCryptProv& prov );
    virtual bool OnContainerExtension(const CONTAINER_EXTENSION *pValue,
	DWORD cbValue) = 0;
    virtual bool OnContainerExtension(LPCSTR szOid, const BYTE* pbValue,
	DWORD cbValue, BOOL bCritical) = 0;
    virtual ~CContainerExtensionEnum() {}
};
#endif // WINCRYPTEX

#ifdef READPKIOBJECT
//     CertReadPKIObject() -    
// PKI (, CRL, PKCS10, PKCS7,  ,  ..)
//     .    - 
// ,     PKI (DER, base64, base64  ),
//  (ASCII, UTF8, UTF16LE, UTF16BE)      
// (DER) .
//         ,  
//     base64,   .
//   c base64     ,  
//      base64      
//      , 
//   base64   .

HRESULT CertReadPKIObject( const BYTE *pbSourceData, DWORD cbSourceData,
    BYTE *pbResultData, DWORD *pcbResultData);
HRESULT CertReadPKIObject( const BYTE *pbSourceData, DWORD cbSourceData,
    ATL::CAtlStringA& buffer);

HRESULT CertReadPKIObjectFileA( LPCSTR szFilePath, ATL::CAtlStringA& buffer );
HRESULT CertReadPKIObjectFileW( LPCWSTR wszFilePath, ATL::CAtlStringA& buffer );

#ifdef _UNICODE
#define CertReadPKIObjectFile CertReadPKIObjectFileW
#else
#define CertReadPKIObjectFile CertReadPKIObjectFileA
#endif // _UNICODE

HRESULT CertReadCertificate( const BYTE *pbSourceData, DWORD cbSourceData,
    PCCERT_CONTEXT *ppCertContext);

HRESULT CertReadCertificateFileA( LPCSTR szFilePath,
        PCCERT_CONTEXT *ppCertContext);
HRESULT CertReadCertificateFileW( LPCWSTR wszFilePath,
	PCCERT_CONTEXT *ppCertContext);
HRESULT CertReadCertificateFileA( LPCSTR szFilePath,
        CCertContext& cert);
HRESULT CertReadCertificateFileW( LPCWSTR szFilePath,
        CCertContext& cert);

#ifdef _UNICODE
#define CertReadCertificateFile CertReadCertificateFileW
#else
#define CertReadCertificateFile CertReadCertificateFileA
#endif // _UNICODE

HRESULT CertReadCRL( const BYTE *pbSourceData, DWORD cbSourceData,
    PCCRL_CONTEXT *ppCrlContext);

HRESULT CertReadCRLFileA( LPCSTR szFilePath,
    PCCRL_CONTEXT *ppCrlContext);
HRESULT CertReadCRLFileW( LPCWSTR wszFilePath,
    PCCRL_CONTEXT *ppCrlContext);

#ifdef _UNICODE
#define CertReadCRLFile CertReadCRLFileW
#else
#define CertReadCRLFile CertReadCRLFileA
#endif // _UNICODE
#endif // READPKIOBJECT

//   -    hWnd 
class CAutoCryptProvWnd
{
    // HWND m_hWnd;
public:
    CAutoCryptProvWnd(HWND hWnd);
    ~CAutoCryptProvWnd();
};

class CCryptKeyProvInfo
{
    CRYPT_KEY_PROV_INFO m_KeyProvInfo;
    ATL::CAtlStringW m_ContainerName;
    ATL::CAtlStringW m_ProvName;
    ATL::CSimpleArray<CRYPT_KEY_PROV_PARAM> m_CryptKeyProvParams;
    ATL::CSimpleArray<CStringBlob> m_Params;
public:
    CCryptKeyProvInfo();
    ~CCryptKeyProvInfo();
    const CRYPT_KEY_PROV_INFO* GetHandle() const throw();
    operator const CRYPT_KEY_PROV_INFO*() throw();
    void Uninitialize ();
    bool IsEmpty() throw();

    HRESULT Initialize (DWORD dwProvType,
	LPWSTR pwszProvName, LPCWSTR pwszContainerName,
	DWORD dwKeySpec, __in_opt DWORD dwFlags = 0);
    HRESULT Initialize (const CRYPT_KEY_PROV_INFO *pInfo);

    //     key   prov 
    //  CRYPT_KEY_PROV_INFO (   
    //   CCryptStore::SetKeyProvInfo
    HRESULT Initialize (
	const ATL::CCryptProv& prov, const ATL::CCryptKey& key,
	DWORD dwFlags = 0, __in_opt DWORD dwKeySpec = 0);

    HRESULT AddKeyProvParam(
	DWORD dwParam, __in_bcount(cbData) BYTE *pbData,
	DWORD cbData, DWORD dwFlags = 0); //throw(...);
};

class CCryptMsg
{
protected:
    HCRYPTMSG m_hMsg;
public:
    CCryptMsg() throw();
    CCryptMsg(const CCryptMsg& msg) throw();
    CCryptMsg &operator=(const CCryptMsg& msg) throw();
    explicit CCryptMsg(HCRYPTMSG hMsg,
	BOOL bTakeOwnership = FALSE) throw();
    ~CCryptMsg() throw();

    void Attach(HCRYPTMSG hMsg, BOOL bTakeOwnership = FALSE) throw();
    void Destroy() throw();
    HCRYPTMSG Detach() throw();
    HCRYPTMSG Duplicate() const throw();

    HRESULT Uninitialize() throw();

    HRESULT OpenToEncode(DWORD dwMsgType, const void* pvMsgEncodeInfo,
	DWORD dwFlags = 0, PCMSG_STREAM_INFO pStreamInfo = NULL,
	DWORD dwMsgEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING,
	LPSTR pszInnerContentObjID = NULL) throw();
    HRESULT OpenToDecode(DWORD dwMsgType = 0, DWORD dwFlags = 0,
	PCMSG_STREAM_INFO pStreamInfo = NULL,
	DWORD dwMsgEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING,
	HCRYPTPROV hCryptProv = 0, /* XXX dim:    gcc-3.4.6   NULL */
	PCERT_INFO pRecipientInfo = NULL) throw();

    HRESULT Update(const BYTE *pbData, DWORD cbData,
	BOOL fFinal = TRUE) throw();
    HRESULT Update(const CStringBlob& Data, BOOL fFinal = TRUE); // throw(...);

    HRESULT Countersign(DWORD dwIndex, DWORD cCountersigners,
	__in_ecount(cCountersigners) PCMSG_SIGNER_ENCODE_INFO rgCountersigners)
	throw();

    HRESULT Control(DWORD dwCtrlType, const void* pvCtrlPara,
	DWORD dwFlags = 0) throw();

    // CMSG_CTRL_ADD_SIGNER
    HRESULT AddSigner(
	PCMSG_SIGNER_ENCODE_INFO para, DWORD dwFlags = 0) throw();

    // CMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR
    HRESULT AddSignerUnauthAttr(
	PCMSG_CTRL_ADD_SIGNER_UNAUTH_ATTR_PARA para) throw();

    HRESULT GetParam(DWORD dwParamType, DWORD dwIndex,
	__out_bcount_part_opt(*pcbData, *pcbData) void *pvData,
	__inout DWORD *pcbData) throw();
    HRESULT GetParam(DWORD dwParamType, DWORD dwIndex,
	CStringBlob &Result); //throw(...);

    HRESULT GetDwordParam(DWORD dwParamType, DWORD dwIndex,
	DWORD &dwResult) throw();
    HRESULT GetAttrParam(DWORD dwParamType, DWORD dwIndex,
	__out_bcount_part(*pcbData, *pcbData) BYTE *pbData,
	__inout DWORD *pcbData, PCCRYPT_ATTRIBUTES& pcAttrs) throw();
    HRESULT GetAttrParam(DWORD dwParamType, DWORD dwIndex,
	CStringBlob& Result,
	PCCRYPT_ATTRIBUTES& pcAttrs); //throw(...);

    // CMSG_CONTENT_PARAM
    HRESULT GetContent(
	__out_bcount_part(*pcbData, *pcbData) BYTE *pbData,
	__inout DWORD *pcbData) throw();
    HRESULT GetContent(CStringBlob& Result); //throw(...);

    // CMSG_ENCODED_MESSAGE
    HRESULT GetEncodedMessage(
	__out_bcount_part(*pcbData, *pcbData) BYTE *pbData,
	__inout DWORD *pcbData) throw();
    HRESULT GetEncodedMessage(CStringBlob& Result); //throw(...);

    // CMSG_ENCODED_SIGNER
    HRESULT GetEncodedSigner(DWORD dwIndex,
	__out_bcount_part(*pcbData, *pcbData) BYTE *pbData,
	__inout DWORD *pcbData) throw();
    HRESULT GetEncodedSigner(DWORD dwIndex,
	CStringBlob& Result); //throw(...);

    // CMSG_ENCRYPTED_DIGEST
    HRESULT GetEncryptedDigest(DWORD dwIndex,
	__out_bcount_part(*pcbData, *pcbData) BYTE *pbData,
	__inout DWORD *pcbData) throw();
    HRESULT GetEncryptedDigest(DWORD dwIndex,
	CStringBlob& Result); //throw(...);

    // CMSG_CMS_SIGNER_INFO_PARAM
    HRESULT GetCmsSignerInfo(DWORD dwIndex,
	__out_bcount_part(*pcbData, *pcbData) BYTE *pbData,
	__inout DWORD *pcbData,
	PCCMSG_CMS_SIGNER_INFO& pcSignerInfo) throw();
    HRESULT GetCmsSignerInfo(DWORD dwIndex, CStringBlob& Result,
	PCCMSG_CMS_SIGNER_INFO& pcSignerInfo); //throw(...);

#ifndef _WIN32_WCE
//  wincrypt.h  CE CryptDe(En)codeObject -  ,  
//  CryptDe(En)codeObjectEx,   CE    
// CryptDe(En)codeObject.       CE,   
//  .

    // CMSG_ENCODED_SIGNER + Decode = CMSG_CMS_SIGNER_INFO_PARAM
    HRESULT GetAndDecodeCmsSignerInfo(DWORD dwIndex,
	__out_bcount_part(*pcbData, *pcbData) BYTE *pbData,
	__inout DWORD *pcbData,
	PCCMSG_CMS_SIGNER_INFO& pcSignerInfo,
	DWORD dwFlags = CRYPT_DECODE_SHARE_OID_STRING_FLAG,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING); //throw(...);
    HRESULT GetAndDecodeCmsSignerInfo(DWORD dwIndex,
	CStringBlob& Result,
	PCCMSG_CMS_SIGNER_INFO& pcSignerInfo,
	DWORD dwFlags = CRYPT_DECODE_SHARE_OID_STRING_FLAG,
	DWORD dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING); //throw(...);

#endif // !_WIN32_WCE

    // CMSG_SIGNER_AUTH_ATTR_PARAM
    HRESULT GetAuthAttr(DWORD dwIndex,
	__out_bcount_part(*pcbData, *pcbData) BYTE *pbData,
	__inout DWORD *pcbData, PCCRYPT_ATTRIBUTES& pcAttrs) throw();
    HRESULT GetAuthAttr( DWORD dwIndex, CStringBlob& Result,
	PCCRYPT_ATTRIBUTES& pcAttrs); //throw(...);

    // CMSG_SIGNER_UNAUTH_ATTR_PARAM
    HRESULT GetUnauthAttr(DWORD dwIndex,
	__out_bcount_part(*pcbData, *pcbData) BYTE *pbData,
	__inout DWORD *pcbData, PCCRYPT_ATTRIBUTES& pcAttrs) throw();
    HRESULT GetUnauthAttr( DWORD dwIndex, CStringBlob& Result,
	PCCRYPT_ATTRIBUTES& pcAttrs); //throw(...);

    // CMSG_SIGNER_COUNT_PARAM
    HRESULT GetSignerCount(DWORD &dwCount) throw();

    // CMSG_TYPE_PARAM
    HRESULT GetType(DWORD &dwMsgType) throw();

    HCRYPTMSG GetHandle() const throw();
};

#ifndef _WIN32_WCE
//  wincrypt.h  CE CryptDe(En)codeObject -  ,  
//  CryptDe(En)codeObjectEx,   CE    
// CryptDe(En)codeObject.       CE,   
//  .

HRESULT CryptDecodeObject(LPCSTR lpszStructType,
    __in_bcount(cbEncoded) const BYTE *pbEncoded, DWORD cbEncoded,
    CStringBlob& Result,
    DWORD dwFlags = CRYPT_DECODE_SHARE_OID_STRING_FLAG,
    DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING);
    //throw(...);

HRESULT CryptDecodeObject(LPCSTR lpszStructType,
    const CStringBlob& Data,
    __out_bcount_part_opt(*pcbStructInfo, *pcbStructInfo) void *pvStructInfo,
    __inout DWORD *pcbStructInfo,
    DWORD dwFlags = CRYPT_DECODE_SHARE_OID_STRING_FLAG,
    DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING);
    //throw(...);

HRESULT CryptDecodeObject(LPCSTR lpszStructType,
    const CStringBlob& Data, CStringBlob& Result,
    DWORD dwFlags = CRYPT_DECODE_SHARE_OID_STRING_FLAG,
    DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING);
    //throw(...);

HRESULT CryptDecodeCmsSignerInfo(
    __in_bcount(cbEncoded) const BYTE *pbEncoded, DWORD cbEncoded,
    CStringBlob& Result, PCCMSG_CMS_SIGNER_INFO& pSignerInfo,
    DWORD dwFlags = CRYPT_DECODE_SHARE_OID_STRING_FLAG,
    DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING);

HRESULT CryptDecodeCmsSignerInfo(const CStringBlob& Data,
    __out_bcount_part_opt(*pcbStructInfo, *pcbStructInfo) void *pvStructInfo,
    __inout DWORD *pcbStructInfo,
    PCCMSG_CMS_SIGNER_INFO& pSignerInfo,
    DWORD dwFlags = CRYPT_DECODE_SHARE_OID_STRING_FLAG,
    DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING);
    //throw(...);

HRESULT CryptDecodeCmsSignerInfo(const CStringBlob& Data,
    CStringBlob& Result, PCCMSG_CMS_SIGNER_INFO& pSignerInfo,
    DWORD dwFlags = CRYPT_DECODE_SHARE_OID_STRING_FLAG,
    DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING);
    //throw(...);

HRESULT CryptEncodeObject(LPCSTR lpszStructType,
    const void* pvStructInfo, CStringBlob& Result,
    DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING);
    //throw(...);

HRESULT CryptEncodeAttribute(PCCRYPT_ATTRIBUTE pcAttr,
    CStringBlob& Result,
    DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING);
    //throw(...);

HRESULT CryptBinaryToStringW(const BYTE *pbBinary,
    DWORD cbBinary, DWORD dwFlags, ATL::CAtlStringW& result);
    //throw(...) 

HRESULT CryptBinaryToStringW(CStringBlob& binary,
    DWORD dwFlags, ATL::CAtlStringW& result);
    //throw(...) 

HRESULT CryptStringToBinaryW(
    LPCWSTR pszString,
    DWORD cchString,
    DWORD dwFlags, CStringBlob& result);
    //throw(...) 

HRESULT CryptStringToBinaryW(const ATL::CAtlStringW& str,
    DWORD dwFlags, CStringBlob& result);
    //throw(...) 

HRESULT CryptBinaryToStringA(const BYTE *pbBinary,
    DWORD cbBinary, DWORD dwFlags, CStringBlob& result);
    //throw(...) 

HRESULT CryptBinaryToStringA(CStringBlob& binary,
    DWORD dwFlags, CStringBlob& result);
    //throw(...) 

HRESULT CryptStringToBinaryA(
    LPCSTR pszString,
    DWORD cchString,
    DWORD dwFlags,
    CStringBlob& result);
    //throw(...) 

HRESULT CryptStringToBinaryA(const CStringBlob& str,
    DWORD dwFlags, CStringBlob& result);
    //throw(...) 

HRESULT CertStrToNameW(const ATL::CAtlStringW& str,
    DWORD dwStrType, CStringBlob& result,
    DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING);

HRESULT CertStrToNameA(const CStringBlob& str,
    DWORD dwStrType, CStringBlob& result,
    DWORD dwCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING);

#endif // !_WIN32_WCE

#ifdef _WIN32

class CCryptOIDFuncAddr
{
protected:
    HCRYPTOIDFUNCADDR m_hCryptOIDFuncAddr;
    void *m_pfn;

public:
    CCryptOIDFuncAddr() throw();
    ~CCryptOIDFuncAddr() throw();

    HRESULT Initialize(__in_z LPCSTR pszFuncName, DWORD dwEncodingType,
	__in_z LPCSTR pszOID, DWORD dwFlags = 0) throw();
    void Destroy() throw();

private:
    //  
    CCryptOIDFuncAddr(const CCryptOIDFuncAddr& addr);
    CCryptOIDFuncAddr &operator=(const CCryptOIDFuncAddr& addr);
};

class COIDFuncEncodePublicKeyAndParameters: public CCryptOIDFuncAddr
{
    //  CryptEncodePublicKeyAndParameters    
    //   crypt32.dll.   ,  OID-
    //        CSP,  
    //     CSP    
    // .      CSP.
    //         
    // LocalAlloc() (  ,    LocalAlloc(),  
    //     CSP  ,     
    // LocalFree(),      CryptoAPI).

    typedef BOOL WINAPI CryptEncodePublicKeyAndParameters_t(
	DWORD dwCertEncodingType,
	__in_z LPCSTR lpszStructType,
	__in_bcount(cbStructInfo) const void *pvStructInfo,
	DWORD cbStructInfo,
	DWORD dwFlags,
	__in_opt void *pvAuxInfo,
	__deref_out_bcount_full_opt(*pcbEncodedPublicKey)
	    LPBYTE *ppbEncodedPublicKey,
	__deref_out DWORD *pcbEncodedPublicKey,
	__deref_out_bcount_full_opt(*pcbParameters)
	    LPBYTE *ppbParameters,
	__deref_out DWORD *pcbParameters);

    static const DWORD m_dwCertEncodingType
	= X509_ASN_ENCODING | PKCS_7_ASN_ENCODING;

protected:
    LPCSTR m_pszOID;

public:
    COIDFuncEncodePublicKeyAndParameters() throw();

    HRESULT Initialize(__in_z LPCSTR pszOID, DWORD dwFlags = 0) throw();

    CryptEncodePublicKeyAndParameters_t Invoke;
    BOOL Invoke(
	__in_bcount(cbStructInfo) const void *pvStructInfo,
	DWORD cbStructInfo,
	CStringBlob& EncodedPublicKey,
	CStringBlob& EncodedParameters,
	DWORD dwFlags = 0,
	__in_opt void *pvAuxInfo = NULL); //throw(...);

private:
    //  
    COIDFuncEncodePublicKeyAndParameters(
	const COIDFuncEncodePublicKeyAndParameters& addr);
    COIDFuncEncodePublicKeyAndParameters &operator=(
	const COIDFuncEncodePublicKeyAndParameters& addr);
};

#endif //_WIN32

} // namespace ATL2

#include "atlcrypt2.inl"

#ifndef _ATL2_NO_AUTOMATIC_NAMESPACE
using namespace ATL2;
#endif //!_ATL2_NO_AUTOMATIC_NAMESPACE

#endif // _ATLCRYPT2_H_INCLUDED
