/*
 * Copyright (c) 2000,  -
 *
 *         
 * ,     ,    ,  
 *  :
 *
 * 1)       
 *         ,   
 *        .
 *
 * 2)       
 *         ,   
 *           /   ,
 *      .
 *
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 *
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SUPPORT_BASE_DEFS_H_INCLUDED
#define SUPPORT_BASE_DEFS_H_INCLUDED
#include "cpcsp/csp_common.h"
#include "reader/tchar.h"

/* --------------- INCLUDE --------------- */
#if defined(CSP_LITE)       	
#   include "CSP_WinDef.h"
#   include "CSP_WinError.h"
#elif defined _WIN32
#   include <stdlib.h>
#   include <malloc.h>
#   pragma warning( push )
#   pragma warning( disable: 4100 4115 4201 4214 )
#   include <windows.h>
#   include <time.h>
#   pragma warning( pop )
#elif defined UNIX
#   include <wchar.h>
#   include "CSP_WinDef.h"
#   include "CSP_WinError.h"
#   include <stdlib.h>
#   include <stdarg.h>
#   include <stdint.h>
#   include <time.h>
#   include <sys/time.h>
#   include <pthread.h>
#   include <nl_types.h>
#   include "reader/ubi_mutex.h"
#else
#   error !UNIX && !_WIN32
#endif //CSP_LITE

#include "reader/std_decl.h"

#ifdef UNIX
# define SUP_INLINE inline
#else
# define SUP_INLINE __inline
#endif

//      reader/source/support/sup_def.h
//     !
#if defined UNIX
#define NO_SUP_NOTIFICATOR
#define NO_SUP_WIZARD
#define NO_SUP_PROPERTIES
#endif // UNIX

// -    UNUSED  common.h
#if defined UNUSED
#undef  UNUSED
#endif
#define UNUSED(x)   (void)(x)

/*    compiler_attributes.h  CSP_WinDef.h */
#if defined __GNUC__
#define CPRO_CHECK_RESULT __attribute__ ((__warn_unused_result__))
#else // __GNUC__
#define CPRO_CHECK_RESULT
#endif // __GNUC__

#endif //SUPPORT_BASE_DEFS_H_INCLUDED
