/*
 * Copyright (c) 2000,  -
 *
 *         
 * ,     ,    ,  
 *  :
 *
 * 1)       
 *         ,   
 *        .
 *
 * 2)       
 *         ,   
 *           /   ,
 *      .
 *
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 *
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SUPPORT_CHECKSUM_H_INCLUDED
#define SUPPORT_CHECKSUM_H_INCLUDED

#include "reader/support_callback.h"

#ifdef __cplusplus
extern "C" {
#endif //__cplusplus

#define SUPPORT_CSUM_BNAME_LEN 40
#define SUPPORT_CSUM_MNAME_LEN SUPPORT_CSUM_BNAME_LEN
#define SUPPORT_CSUM_HASH_LEN 32

DWORD support_register_checksum_block(
    const char *module_name,
    const char *block_name,
    const void *block_ptr,
    size_t block_length,
    const void *checksum
    ) CPRO_CHECK_RESULT;

DWORD support_unregister_checksum_block(
    const char *module_name,
    const void *block_ptr,
    size_t block_length
    ) CPRO_CHECK_RESULT;

DWORD support_is_checksum_block_registered(
    const char *module_name,
    const void *block_ptr,
    size_t block_length
    ) CPRO_CHECK_RESULT;

DWORD support_free_all_checksum_blocks(void);

DWORD support_register_csm_module(const char *module_name) CPRO_CHECK_RESULT;

DWORD support_is_csm_module_registered(const char *module_name) CPRO_CHECK_RESULT;

DWORD support_unregister_csm_module(const char *module_name) CPRO_CHECK_RESULT;

typedef DWORD _SUPPORT_CALLBACK_CONV support_checksum_callback_t(
    const char *module_name,
    const char *block_name,
    const void *block_ptr,
    size_t block_length,
    const void *checksum,
    void *arg
    ) CPRO_CHECK_RESULT;

DWORD support_verify_blocks(support_checksum_callback_t *callback, void *arg) CPRO_CHECK_RESULT;

#ifdef __cplusplus
}
#endif //__cplusplus

#endif //SUPPORT_CHECKSUM_H_INCLUDED
