/*
 * Copyright (c) 2000,  -
 * 
 *         
 * ,     ,    ,  
 *  :
 * 
 * 1)        
 *         ,    
 *        .
 * 
 * 2)       
 *         ,   
 *           /   ,
 *      .
 * 
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 * 
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SUPPORT_LOCKS_H
#define SUPPORT_LOCKS_H

#include "cpcsp/csp_common.h"
#include "reader/support_time.h"

#if defined( __cplusplus )
extern "C" {
#endif /* defined( __cplusplus ) */

#if !defined CSP_LITE
#if !defined UNIX
/* Mutex -     .
           
    */
#   define support_mutex_init( mutex ) *mutex = INVALID_HANDLE_VALUE
#   define support_mutex_open( mutex, name, f) support_mutex_open_fun(mutex, name)
#   define support_mutex_lock( mutex ) WaitForSingleObject( (mutex), INFINITE )
#   define support_mutex_unlock( mutex ) ReleaseMutex( mutex )
#   define support_mutex_close( mutex ) { if( *mutex != INVALID_HANDLE_VALUE ) { CloseHandle( *mutex ); *mutex = INVALID_HANDLE_VALUE; } }
# ifndef _M_ARM
#   define support_try __try {
#   define support_finally } __finally {
# else
#   define support_try {
#   define support_finally } {
# endif
#   define support_finally_end }

/* Critical Section   .   
   .       . */
#   define support_section_init( section, arg ) (InitializeCriticalSection(section),0)
#   define support_section_init_recursive(section) (InitializeCriticalSection(section),0)
#   define support_section_done( section ) (DeleteCriticalSection(section),0)
#   define support_section_enter( section ) (EnterCriticalSection(&section),0)
#   define support_section_leave( section ) (LeaveCriticalSection(&section),0)

#else /* UNIX */
#define support_mutex_init(m)           *m = NULL
#define support_mutex_open(pm, name, f) ubi_mutex_open(pm, name, f)
#define support_mutex_lock(m)           ubi_mutex_lock(m)
#define support_mutex_unlock(m)         ubi_mutex_unlock(m)
#define support_mutex_close(pm)         ubi_mutex_close(*pm)

# define support_section_init( section, arg ) pthread_mutex_init( section,NULL )
# define support_section_init_recursive(section) support_mutex_init_recursive(section)
# define support_section_done( section ) pthread_mutex_destroy( section )
# define support_section_enter( section ) pthread_mutex_lock( &section )
# define support_section_leave( section ) pthread_mutex_unlock( &section )

# define support_try {
# define support_finally }
# define support_finally_end

#endif /* UNIX */

#elif defined CSP_LITE

# if !defined UNIX
#   define support_try __try {
#   define support_finally } __finally {
#   define support_finally_end }
# else
#   define support_try {
#   define support_finally }
#   define support_finally_end
#endif

# define support_section_init( section, arg )
# define support_section_init_recursive(section)
# define support_section_done( section )
# define support_section_enter( section ) (void) 1
# define support_section_leave( section )

#endif /* CSP_LITE */

#define support_mutex_try_lock( mutex ) \
    support_mutex_lock( mutex ); support_try
#define support_section_try_enter( section ) \
    support_section_enter( section ); support_try
#define support_section_finally_leave( section ) \
    support_finally support_section_leave( section ); support_finally_end
#define RWLOCK_CLAIM(lock,mode) \
    CRWLock_Claim (lock, mode); support_try
#define RWLOCK_RELEASE(lock,mode) \
    support_finally CRWLock_Release (lock, mode); support_finally_end

#define SRC_CPC_pCP_CALL_CTX		pCP_CALL_CTX

#define SRC_CPC_RWLOCK_INIT(pCC,pS,a)	CPC_RWLOCK_INIT(pCC,pS,a)
#define SRC_CPC_RWLOCK_RDLOCK(pCC,pS)	CPC_RWLOCK_RDLOCK(pCC,pS)
#define SRC_CPC_RWLOCK_WRLOCK(pCC,pS) 	CPC_RWLOCK_WRLOCK(pCC,pS) 
#define SRC_CPC_RWLOCK_UNLOCK(pCC,pS)	CPC_RWLOCK_UNLOCK(pCC,pS)
#define SRC_CPC_INTERLOCKED_CASL(pCC,plvD,S,C) \
					CPC_INTERLOCKED_CASL(pCC,plvD,S,C)
#define SRC_CPC_INTERLOCKED_INCREMENT(pCC,plvD) \
					CPC_INTERLOCKED_INCREMENT(pCC,plvD)
#define SRC_CPC_timeval			CPC_timeval
#define SRC_CPC_GET_TIME(pCC,pTV)	CPC_GET_TIME(pCC,pTV)
#define SRC_CPC_CACHE_LOCK_DECL		CPC_LOCK_OBJ* src_lock_ = &pCC_->hCSP->ParamsLock;
#define SRC_CPC_CACHE_INIT

#define SRC_CP_pCP_CALL_CTX	struct { struct { BOOL fSerialize; } *hCSP; } *

#define SRC_CP_RWLOCK_INIT(pCC,pS,a)	rwlock_init((&pS), sizeof(pS), NULL)
#define SRC_CP_RWLOCK_RDLOCK(pCC,pS)	rwlock_rdlock(&pS)
#define SRC_CP_RWLOCK_WRLOCK(pCC,pS)	rwlock_wrlock(&pS)
#define SRC_CP_RWLOCK_UNLOCK(pCC,pS)	rwlock_unlock(&pS)
#define SRC_CP_INTERLOCKED_CASL(pCC,plvD,S,C) \
				support_interlocked_CASL((plvD), (S), (C))
#define SRC_CP_INTERLOCKED_INCREMENT(pCC,plvD) \
				support_interlocked_increment(plvD)
#define SRC_CP_timeval			support_timeval

#define SRC_CP_CACHE_LOCK_DECL  static volatile LONG src_CP_inited_ = 0; \
				static CPC_RWLOCK src_lock_;

#define SRC_CP_CACHE_INIT  	while (2 != src_CP_inited_) { \
				    if(SRC_CP_INTERLOCKED_CASL(pCC_, &src_CP_inited_, 1, 0)) { \
					SRC_CP_RWLOCK_INIT(pCC_, src_lock_, TRUE); \
					SRC_CP_INTERLOCKED_INCREMENT(pCC_, &src_CP_inited_); \
				    } \
				}

#define SRC_CP_GET_TIME(pCC,pTV)	(ERROR_SUCCESS == support_gettimeofday(pTV))

typedef enum CRWLockMode_
{
    CRWLOCK_NONE = 1,
    CRWLOCK_HIGHLOAD_NOSERIALIZED_READ = 2,
    CRWLOCK_READ = 3,
    CRWLOCK_ANY = 4,
    CRWLOCK_WRITE = 5,
    CRWLOCK_ERROR = -1
} CRWLockMode;

#if defined UNIX && defined CSP_LITE
typedef void *TSupportCriticalSection;
typedef void *TSupportMutex;
#elif defined UNIX && !defined CSP_LITE
typedef ubi_named_mutex_t *TSupportMutex;
typedef pthread_mutex_t TSupportCriticalSection;
#elif defined _WIN32 && defined CSP_LITE
typedef struct _FAST_MUTEX *PFAST_MUTEX;
typedef PFAST_MUTEX TSupportCriticalSection;
#elif defined _WIN32
typedef HANDLE TSupportMutex;
typedef CRITICAL_SECTION TSupportCriticalSection;
struct CRWLock_t
{
    LONGLONG dummy[2 * 16];
};
#endif

typedef struct CRWLock_t CRWLock;

#if defined _WIN32 && !defined CSP_LITE
DWORD support_mutex_open_fun(TSupportMutex *mutex, const TCHAR *name) CPRO_CHECK_RESULT;
#endif

BOOL CRWLock_Initialize(CRWLock *lock, void *arg) CPRO_CHECK_RESULT;
DWORD CRWLock_Cleanup(CRWLock *lock) CPRO_CHECK_RESULT;
DWORD CRWLock_Claim(CRWLock *lock, CRWLockMode mode) CPRO_CHECK_RESULT;
DWORD CRWLock_Release(CRWLock *lock, CRWLockMode mode) CPRO_CHECK_RESULT;

#if defined( __cplusplus )
}
#endif

#endif // SUPPORT_LOCKS_H
