/*
 * Copyright (c) 2000,  -
 * 
 *         
 * ,     ,    ,  
 *  :
 * 
 * 1)        
 *         ,    
 *        .
 * 
 * 2)       
 *         ,   
 *           /   ,
 *      .
 * 
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 * 
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SUPPORT_ONCE_H
#define SUPPORT_ONCE_H

#include "cpcsp/csp_common.h"
#include "reader/support_base_defs.h"
#include "reader/support_debug.h"

#if defined( __cplusplus )
extern "C" {
#endif //__cplusplus

#if !defined CSP_LITE
/*     */
/* TODO:X   -  :
 * typedef boost::once_flag TSupportOnce;
 * #define SUPPORT_ONCE_INIT BOOST_ONCE_INIT
 * #define support_once(once_control, init_routine) boost::call_once(init_routine, once_control)
 */
#ifdef UNIX

typedef pthread_once_t TSupportOnce;
#define SUPPORT_ONCE_INIT PTHREAD_ONCE_INIT
#define support_once(once_control, init_routine) \
			    (pthread_once((once_control), (init_routine)))
#else
typedef struct TSupportOnce_
{
    LONG lLock;
    LONG lDone;
    LONG lInited;
} TSupportOnce;
#define SUPPORT_ONCE_INIT { 0, 0, 0 }

static __inline CPRO_CHECK_RESULT int support_once(TSupportOnce *once_control, void (*init_routine)(void))
{
    LONG lThreadID = GetCurrentThreadId();
    int ret = 0;

    if (once_control == NULL || init_routine == NULL) {
	return /*EINVAL*/22;
    }
    if (once_control->lDone) {	// "" 
	return 0;
    }
    if (!InterlockedExchangeAdd(&once_control->lDone, 0)) { /* MBR fence */
	while (0 != InterlockedCompareExchange(
	    &once_control->lLock, lThreadID, 0)) {
	    Sleep(100);
	}
	if (!once_control->lDone) {
	    (*init_routine)();
	    if (0 != InterlockedExchangeAdd(&once_control->lDone, 1)) {
		// TODO:XX     volatile  
		// lDone, ,  InterlockedExchangeAdd()
		//  CE .
		// TODO:X    .  
		// Interlocked*() ,    
		//  .
		SUP_STOP;
		ret = -1; /* Internal error */
	    }
	    once_control->lInited = lThreadID;
	}
	if (lThreadID != once_control->lLock) {
	    // TODO:X    .  
	    // Interlocked*() ,    
	    //  .
	    SUP_STOP;
	    ret = -1; /* Internal error */
	}
	once_control->lLock = 0;
    }
    return ret;
}
#endif
#endif

#if defined( __cplusplus )
}
#endif //__cplusplus

#endif // SUPPORT_ONCE_H
