/*
 * Copyright (c) 2000,  -
 * 
 *         
 * ,     ,    ,  
 *  :
 * 
 * 1)        
 *         ,    
 *        .
 * 
 * 2)       
 *         ,   
 *           /   ,
 *      .
 * 
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 * 
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SUPPORT_POINTER_H_INCLUDED
#define SUPPORT_POINTER_H_INCLUDED

#include "reader/support_base_defs.h"

#ifdef __cplusplus
# if defined(__xlC__) || defined(_AIX)
// TODO: fast AIX fix: RuNetCPC.cpp, line 388.9: 1540-0064 (S) Syntax error:  "(" was expected but "," was found.
#  define CPRO_ALIGNOF(type) 2
# else
template<typename T> struct alignment_trick { char c; T member; };
#  define CPRO_ALIGNOF(type) CPRO_OFFSETOF(alignment_trick<type>, member)
# endif
#else // __cplusplus
# define CPRO_ALIGNOF(type) CPRO_OFFSETOF(struct { char x; type test; }, test)
#endif // __cplusplus

#if defined( __cplusplus )
extern "C" {
#endif

#define IS_ALIGNED_PTR(x,type) ( (x) && !( ((size_t)(x)) % (CPRO_ALIGNOF(type)) ) )

typedef void(*SUP_PROC_PTR)(void);

#if 0 //defined _WIN32 && !defined CSP_LITE
#   define IS_READ_PTRS(x,size) ( !IsBadReadPtr(x,size) )
#   define IS_WRITE_PTRS(x,size) ( !IsBadWritePtr(x,size) )
#   define IS_READ_PTR(x) ( !IsBadReadPtr(x,1) )
#   define IS_WRITE_PTR(x) ( !IsBadWritePtr(x,1) )
#   define IS_STRING_PTRS(x,size) ( !IsBadStringPtr(x,size) )
#   define IS_STRING_PTR(x) ( !IsBadStringPtr(x,(size_t)-1) )
#   define IS_FUN_PTR(x) (!IsBadCodePtr((FARPROC)x) )
#   define IS_ALIGNED_RPTR(x,type) (IS_ALIGNED_PTR(x,type) && IS_READ_PTRS(x,sizeof(type)))
#   define IS_ALIGNED_WPTR(x,type) (IS_ALIGNED_PTR(x,type) && IS_WRITE_PTRS(x,sizeof(type)))
#else
/*   :
   TODO:     wchar-  ,
      : SUPSYS_PRE_CONTEXT(), SUPSYS_PRE_INFO */
SUP_INLINE CPRO_CHECK_RESULT static int IsGoodPtr(const void *p) { return (p != NULL); }
SUP_INLINE CPRO_CHECK_RESULT static int IsGoodCodePtr(SUP_PROC_PTR p) { return (p != NULL); }
#   define IS_READ_PTRS(x,size) IsGoodPtr(x)
#   define IS_WRITE_PTRS(x,size) IsGoodPtr(x)
#   define IS_READ_PTR(x) IS_READ_PTRS(x,1)
#   define IS_WRITE_PTR(x) IS_WRITE_PTRS(x,1)
#   define IS_STRING_PTRS(x,size) IsGoodPtr(x)
#   define IS_STRING_PTR(x) IsGoodPtr(x)
#   define IS_FUN_PTR(x) IsGoodCodePtr((SUP_PROC_PTR)x)
#   define IS_ALIGNED_RPTR(x,type) IS_ALIGNED_PTR(x,type)
#   define IS_ALIGNED_WPTR(x,type) IS_ALIGNED_PTR(x,type)
#endif

#if defined( __cplusplus )
}
#endif

#endif //SUPPORT_POINTER_H_INCLUDED
