/*
 * Copyright (c) 2000,  -
 * 
 *         
 * ,     ,    ,  
 *  :
 * 
 * 1)        
 *         ,    
 *        .
 * 
 * 2)       
 *         ,   
 *           /   ,
 *      .
 * 
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 * 
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SUPPORT_REGISTRY_H_INCLUDED
#define SUPPORT_REGISTRY_H_INCLUDED

#include "cpcsp/csp_common.h"
#include "reader/support_base_defs.h"
#include "reader/support_locks.h"

#if defined( __cplusplus )
extern "C" {
#endif /* defined( __cplusplus ) */

#define SUP_TYPE_UNKNOWN 0

/*   . */
#define SUP_TYPE_STRING 0x1

/*   long. */
#define SUP_TYPE_LONG 0x2

/*   Boolean. */
#define SUP_TYPE_BOOL 0x4

/*   Hex. */
#define SUP_TYPE_HEX 0x8

/*   Section. */
#define SUP_TYPE_SECTION 0x10

/*   Section. */
#define SUP_TYPE_MULTI_SZ 0x20

/*   long long */
#define SUP_TYPE_LONG_LONG 0x40

/*       . */

/*     ,   . */
#define SUP_ACCESS_READ 0x1
/*     ,     */
#define SUP_ACCESS_MODIFY 0x2
/*    . */
#define SUP_ACCESS_CREATE_SUBKEY 0x4
/*    . */
#define SUP_ACCESS_DELETE_SUBKEY 0x8
/*    . */
#define SUP_ACCESS_GET_ACCESS 0x10
/*    . */
#define SUP_ACCESS_SET_ACCESS 0x20
/*    . */
#define SUP_ACCESS_ENUM_SUBKEY 0x40
/*     . */
#define SUP_ACCESS_NOTIFY 0x80
/*  64- */
#define SUP_64KEY_DIRECT_ACCESS 0x100
/*   SACL. */
#define SUP_ACCESS_SYSTEM_SECURITY           (0x01000000L)

/* If we have bit from this mask, we need to open file for read/write */
#define SUP_ACCESS_WRITE_MASK (SUP_ACCESS_MODIFY|SUP_ACCESS_CREATE_SUBKEY|SUP_ACCESS_DELETE_SUBKEY|SUP_ACCESS_SET_ACCESS)

#define SUPPORT_NOTIFY_SUBTREE 0x1
#define SUPPORT_NOTIFY_CHANGE 0x2
#define SUPPORT_NOTIFY_RENAME 0x4
#define SUPPORT_NOTIFY_SECURITY 0x8
#define SUPPORT_NOTIFY_PASSTHROUGH 0x10000000

/*+    registry. +*/
#define SUPPORT_REG_LOCAL _TEXT( "\\LOCAL" )
/*+    registry. +*/
#define SUPPORT_REG_GLOBAL _TEXT( "\\GLOBAL" )
/*+     registry. +*/
#define SUPPORT_FKC_PROTECTED_LOCAL _TEXT( "\\PROTECTED_FKC_LOCAL" )
/*+     registry. +*/
#define SUPPORT_FKC_PROTECTED_GLOBAL _TEXT( "\\PROTECTED_FKC_GLOBAL" )
/*+     registry. +*/
#define SUPPORT_REG_PROTECTED_LOCAL _TEXT( "\\PROTECTED_LOCAL" )
/*+     registry. +*/
#define SUPPORT_REG_PROTECTED_GLOBAL _TEXT( "\\PROTECTED_GLOBAL" )
/*+    registry. +*/
#define SUPPORT_REG_CONFIG _TEXT( "\\CONFIG" )
/*+    registry. +*/
#define SUPPORT_REG_LICENSE _TEXT( "\\LICENSE\\InprocServer32" )
#define SUPPORT_REG_APPPATH _TEXT( "\\APPPATH" )
#define SUPPORT_REG_CRYPTOGRAPHY _TEXT( "\\CRYPTOGRAPHY" )

#define SUPPORT_REG_POLICIES _TEXT( "\\POLICIES" )
#define SUPPORT_REG_SYSCONTROL _TEXT( "\\SYSCONTROL" )
#ifdef _WIN64
#define SUPPORT_REG_APPPATH32 _TEXT( "\\APPPATH32" )
#define SUPPORT_REG_CONFIG64 _TEXT( "\\CONFIG64" )
#endif
#define SUPPORT_REG_CRYPTOGRAPHY64 _TEXT( "\\CRYPTOGRAPHY64" )

/*  . */
typedef unsigned int TSupType;

/*  . */
typedef unsigned int TSupAccess;

/*   registry. */
struct TSupportRegistrySearchContext_;

typedef struct TSupportRegistrySearchContext_ TSupportRegistrySearchContext;

struct TSupportRegistrySearchValue_;

typedef struct TSupportRegistrySearchValue_ TSupportRegistrySearchValue;

#ifdef NO_SUP_NOTIFICATOR
typedef int TSupRegNotificator;
#else /* !NO_SUP_NOTIFICATOR */
struct TSupRegNotificator_;
typedef struct TSupRegNotificator_ TSupRegNotificator;
#endif /* !NO_SUP_NOTIFICATOR */

/*     */
#define DEF_DIALOG_TIMEOUT_VALUE 600

DWORD usenewreg(void) CPRO_CHECK_RESULT; /*    . 0 -- , -0 --  */
DWORD rlsnewreg(void); /*    ,   .   */
DWORD isnewreg(void) CPRO_CHECK_RESULT;  /* 0 -- , -0 --  */

/*         .
    start_timeout == NULL,  .
       * start_timeout.*/
DWORD support_set_to_config_dialog_timeout(BOOL is_global, int *start_timeout) CPRO_CHECK_RESULT;

/*       .
    ERROR_FILE_NOT_FOUND        .
     ERROR_SUCCESS, ,   start_timeout,     . */
DWORD support_get_from_config_dialog_timeout(BOOL is_global, int *start_timeout) CPRO_CHECK_RESULT;

/*        */
void support_get_dialog_timeouts(int *start_timeout, int *show_timeout, int *resume_timeout);

/*    .
 *  
 *  length [in,out]
 *  in -  ,      -
 *  out -           -
 */
DWORD support_registry_get_string(const TCHAR *path, size_t *length, TCHAR *dest) CPRO_CHECK_RESULT;

/*
 *  dest   -
 *  
 *  length [in,out]
 *  in -  ,       -
 *  out -            -
 */
DWORD support_registry_get_multi_string(const TCHAR *path, size_t *length, TCHAR *dest) CPRO_CHECK_RESULT;

/*   long . */
DWORD support_registry_get_long(const TCHAR *path, long *dest) CPRO_CHECK_RESULT;

/*   long long . */
DWORD support_registry_get_long_long(const TCHAR *path, long long *dest) CPRO_CHECK_RESULT;

/*   Boolean . */
DWORD support_registry_get_bool(const TCHAR *path, int *dest) CPRO_CHECK_RESULT;

/*    . */
DWORD support_registry_get_hex(const TCHAR *path, size_t *size, void *dest) CPRO_CHECK_RESULT;

/*    . */
DWORD support_registry_put_string(const TCHAR *path, const TCHAR *src) CPRO_CHECK_RESULT;

/*    . */
DWORD support_registry_put_multi_string(const TCHAR *path, const TCHAR *src) CPRO_CHECK_RESULT;

/*   long . */
DWORD support_registry_put_long(const TCHAR *path, long src) CPRO_CHECK_RESULT;

/*   long long . */
DWORD support_registry_put_long_long(const TCHAR *path, long long src) CPRO_CHECK_RESULT;

/*   Boolean . */
DWORD support_registry_put_bool(const TCHAR *path, int src) CPRO_CHECK_RESULT;

/*    . */
DWORD support_registry_put_hex(const TCHAR *path, size_t size, const void *src) CPRO_CHECK_RESULT;

#if defined _WIN32
/*   access control list    . */
DWORD support_registry_put_acl(const TCHAR *path, const void *src) CPRO_CHECK_RESULT;

/*   system access control list    . */
DWORD support_registry_put_sacl(const TCHAR *path, const void *src) CPRO_CHECK_RESULT;

#if !defined EXCLUDE_READER

DWORD support_registry_get_sdecr(
    const TCHAR *path,
    const DWORD secInfo,
    void *pSec, DWORD *pSecLen,
    long *pError
    ) CPRO_CHECK_RESULT;

DWORD support_registry_put_sdecr(const TCHAR *path,
    const DWORD secInfo,
    void *pSec,
    long *pError
    ) CPRO_CHECK_RESULT;

DWORD support_folder_get_sdecr(
    const TCHAR *path,
    const DWORD secInfo,
    void *pSec,
    DWORD *pSecLen
    ) CPRO_CHECK_RESULT;


DWORD support_folder_put_sdecr(
    const TCHAR *path,
    const DWORD secInfo,
    const void *pSec
    ) CPRO_CHECK_RESULT;

#   endif  /* !EXCLUDE_READER */

#endif /* _WIN32 */

#if defined (_WIN32) && !defined (CSP_LITE)
/*    PP_KEYSET_SEC_DESCR     . */
DWORD support_get_PP_KEYSET_SEC_DESCR(BYTE *pbData, DWORD *pdwDataLen) CPRO_CHECK_RESULT;
#endif

/*   . */
DWORD support_registry_put_section(const TCHAR *path) CPRO_CHECK_RESULT;

/*    . */
DWORD support_registry_test_section(const TCHAR *path) CPRO_CHECK_RESULT;

/*     . */
DWORD support_registry_delete_param(const TCHAR *path, const TCHAR *src) CPRO_CHECK_RESULT;

/*     . */
DWORD support_registry_delete_section(const TCHAR *path, const TCHAR *src) CPRO_CHECK_RESULT;

/*   . */
DWORD support_registry_search_open(const TCHAR *path, TSupportRegistrySearchContext **context, size_t *max_name, int subkey) CPRO_CHECK_RESULT;

/*    . */
int support_registry_search_cmp(TSupportRegistrySearchContext *left, TSupportRegistrySearchContext *right) CPRO_CHECK_RESULT;

/*   . */
DWORD support_registry_search_close(
    TSupportRegistrySearchContext *context);

/*     . */
DWORD support_registry_search_next(TSupportRegistrySearchContext *context, TSupportRegistrySearchValue **right) CPRO_CHECK_RESULT;

/*   . */
DWORD support_registry_find(const TCHAR *path, TSupportRegistrySearchValue **value) CPRO_CHECK_RESULT;

DWORD support_registry_value_cpy(TSupportRegistrySearchValue **left, const TSupportRegistrySearchValue *right) CPRO_CHECK_RESULT;

/*   . 
 *   ERROR_SUCCESS. */
DWORD support_registry_value_free(
    TSupportRegistrySearchValue *src);

/*
 *  length [in,out]
 *  in -  ,      -
 *  out -           -
 */
DWORD support_registry_value_string(const TSupportRegistrySearchValue *src, size_t *length, TCHAR *dest) CPRO_CHECK_RESULT;

/*
 *  dest   -
 *  
 *  length [in,out]
 *  in -  ,       -
 *  out -            -
 */
DWORD support_registry_value_multi_string(const TSupportRegistrySearchValue *src, size_t *length, TCHAR *dest) CPRO_CHECK_RESULT;

/*   long . */
DWORD support_registry_value_long(const TSupportRegistrySearchValue *src, long *dest) CPRO_CHECK_RESULT;

DWORD support_registry_value_long_long(const TSupportRegistrySearchValue *src, long long *dest) CPRO_CHECK_RESULT;

DWORD support_registry_value_bool(const TSupportRegistrySearchValue *src, int *dest) CPRO_CHECK_RESULT;

DWORD support_registry_value_hex(const TSupportRegistrySearchValue *src, size_t *size, void *dest) CPRO_CHECK_RESULT;

DWORD support_registry_value_type(const TSupportRegistrySearchValue *src, TSupType *type, size_t *size) CPRO_CHECK_RESULT;

/*
 *  length [in,out]
 *  in -  ,      -
 *  out -           -
 */
DWORD support_registry_value_name(const TSupportRegistrySearchValue *src, size_t *length, TCHAR *dest) CPRO_CHECK_RESULT;

/*     .
 *  
 *  length [in,out]
 *  in -  ,      -
 *  out -           -
 */
DWORD support_registry_get_param(TSupportRegistrySearchContext *context, size_t length, TCHAR *dest) CPRO_CHECK_RESULT;

/*    . */
DWORD support_registry_type(const TCHAR *path, TSupType *type, size_t *size) CPRO_CHECK_RESULT;

/*    . */
DWORD support_registry_check_access(const TCHAR *path, TSupAccess *acc) CPRO_CHECK_RESULT;

#ifdef NO_SUP_NOTIFICATOR
#ifdef _MSC_VER
#pragma warning (disable:4127)
#endif
#define support_registry_notify_set(a,b,n) 0
#define support_registry_notify_is(n) (DWORD)SCARD_W_CANCELLED_BY_USER
#define support_registry_notify_done(n)
#else /* !NO_SUP_NOTIFICATOR */
DWORD support_registry_notify_set(const TCHAR *path, unsigned flags, TSupRegNotificator **notificator) CPRO_CHECK_RESULT;

DWORD support_registry_notify_is(TSupRegNotificator *notificator) CPRO_CHECK_RESULT;

DWORD support_registry_notify_done(TSupRegNotificator *notificator) CPRO_CHECK_RESULT;
#endif /* !NO_SUP_NOTIFICATOR */

//
//   / / .
//
#ifdef UNIX //    .
#   define SRC_TIMEOUT (10)
#else // UNIX
#   define SRC_TIMEOUT (1)
#endif // UNIX

#if !defined(CSP_LITE)	// CPCSP-4228 -   
	    //    .
	    //   static    .
	    // t == CP -   pCP_CALL_CTX,    pCC 
	    //              0 (  CP);
	    // t == CPC -  pCP_CALL_CTX (  CP).
    #define SUPPORT_REGISTRY_CACHE_DECL(t, pCC) { \
	    SRC_##t##_pCP_CALL_CTX pCC_ = (pCC); \
	    static BOOL src_cached_ok_ = FALSE; \
	    SRC_##t##_CACHE_LOCK_DECL \
	    static SRC_##t##_timeval src_prev_ = { 0 };
		//   

	    //    ,     
	    //      
    #define SUPPORT_REGISTRY_CACHE_INVALIDATE_1(t)  \
	    SRC_##t##_timeval src_cur_ = { SRC_TIMEOUT, SRC_TIMEOUT }; \
	    BOOL src_##t##_use_ = FALSE; \
	    BOOL src_cache_ = FALSE; \
	    BOOL src_try_check_ = FALSE; \
	    int src_try_cnt_ = 3; \
	    \
	    do { \
		src_try_check_ = FALSE; \
		src_cache_ = FALSE; \
		src_##t##_use_ = (0 == pCC_ || pCC_->hCSP->fSerialize) \
				 && 0 < src_try_cnt_--; \
			/*  !fSerialize,  CPC_RWLOCK_*LOCK */ \
			/*   ,   */ \
			/*  */ \
			/*  0 == pCC_, rwlock_*lock   */ \
			/* void      */ \
		if(src_##t##_use_) { \
		    SRC_##t##_CACHE_INIT \
		    if(SRC_##t##_GET_TIME(pCC_, &src_cur_)) { \
			SRC_##t##_RWLOCK_RDLOCK(pCC_, src_lock_);

	    //     (cond).
	    // cond == FALSE -     .
    #define SUPPORT_REGISTRY_CACHE_INVALIDATE_2(t, cond)  \
			    src_cache_ = src_cached_ok_ && \
			       src_cur_.tv_sec < src_prev_.tv_sec + SRC_TIMEOUT && \
			       src_cur_.tv_sec > src_prev_.tv_sec - SRC_TIMEOUT; \
			SRC_##t##_RWLOCK_UNLOCK(pCC_, src_lock_); \
		    }; \
		    if(!src_cache_ || (cond)) { \
			src_cache_ = FALSE; \
			SRC_##t##_RWLOCK_WRLOCK(pCC_, src_lock_); \
			support_try \
			    if (src_cached_ok_) { \
				    /*     */ \
				    /*    */ \
				src_cached_ok_ = FALSE; \
				src_prev_.tv_sec = 0; 
				//  . : return,
				//   .
				/*...*/

	    //    ,      (cond).
	    // cond == FALSE -     .
    #define SUPPORT_REGISTRY_CACHE_INVALIDATE(t, cond)  \
	    SUPPORT_REGISTRY_CACHE_INVALIDATE_1(t) \
	    SUPPORT_REGISTRY_CACHE_INVALIDATE_2(t, cond) \

	    //     (   )
	    //  ,     .
    #define SUPPORT_REGISTRY_CACHE_NOCACHE(t)  \
				/*...*/ \
			    } \
			support_finally \
			SRC_##t##_RWLOCK_UNLOCK(pCC_, src_lock_); \
			support_finally_end; \
		    } \
		    /*  !src_cache_,     */ \
		    /*   */ \
		}; \
		if(!src_##t##_use_ || !src_cache_) {
		    //        
		    //  . : return, 
		    //   ..
		    /*...*/

	    //       
	    //   (   ).
	    // ok == TRUE -    .
    #define SUPPORT_REGISTRY_CACHE_FILL(t, ok) \
		    /*...*/ \
		    if(src_##t##_use_ & (ok)) { \
			SRC_##t##_RWLOCK_WRLOCK(pCC_, src_lock_); \
			support_try \
			    if (!src_cached_ok_) { \
				    /*     */ \
				    /*    */ \
				src_cached_ok_ = FALSE; \
				src_prev_.tv_sec = 0; 
				//  . : return,
				//   .
				/*...*/

	    //        
	    //    (   )  .
    #define SUPPORT_REGISTRY_CACHE_CACHE(t) \
				/*...*/ \
				if(SRC_##t##_GET_TIME(pCC_, &src_prev_)) { \
				    src_cached_ok_ = TRUE; \
				} \
			    } \
			support_finally \
			SRC_##t##_RWLOCK_UNLOCK(pCC_, src_lock_); \
			support_finally_end; \
		    } \
		} else if(src_##t##_use_) { \
			/* TODO: if(src_##t##_use_)   */ \
			/* assert(src_##t##_use_); */ \
		    SRC_##t##_RWLOCK_RDLOCK(pCC_, src_lock_); \
		    support_try \
			if (!src_cached_ok_) { \
			        /*  -  */ \
				/*  ,   */ \
			    src_try_check_ = TRUE; \
			} else {
			    //  . : return,
			    //   .
			    /*...*/

	    //    .
    #define SUPPORT_REGISTRY_CACHE_END(t) \
			    /*...*/ \
			} \
		    support_finally \
		    SRC_##t##_RWLOCK_UNLOCK(pCC_, src_lock_); \
		    support_finally_end; \
		} \
	    } while(src_##t##_use_ && src_try_check_); \
	}
#else
    #define SUPPORT_REGISTRY_CACHE_DECL(t, pCC)         { int src_##t##_false_ = 0;
    #define SUPPORT_REGISTRY_CACHE_INVALIDATE(t, cond)  if(src_##t##_false_) {
    #define SUPPORT_REGISTRY_CACHE_NOCACHE(t)           } \
                                                        {
    #define SUPPORT_REGISTRY_CACHE_FILL(t, ok)          } \
                                                        if(src_##t##_false_) {
    #define SUPPORT_REGISTRY_CACHE_CACHE(t)
    #define SUPPORT_REGISTRY_CACHE_END(t)               }}
#endif

#if defined( __cplusplus )
}
#endif

#endif //SUPPORT_REGISTRY_H_INCLUDED
