/*
 * Copyright (c) 2000,  -
 * 
 *         
 * ,     ,    ,  
 *  :
 * 
 * 1)        
 *         ,    
 *        .
 * 
 * 2)       
 *         ,   
 *           /   ,
 *      .
 * 
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 * 
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SUPPORT_TLS_H
#define SUPPORT_TLS_H

#include "cpcsp/csp_common.h"

#if defined( __cplusplus )
extern "C" {
#endif //__cplusplus

/*    CAdES  Linux */
#if defined UNIX
# ifndef TLS_OUT_OF_INDEXES
#   define TLS_OUT_OF_INDEXES ((DWORD)0xFFFFFFFF)
# endif
#endif /* UNIX */

// Thread Local Storage
#if !defined CSP_LITE
#   ifdef _WIN32
    typedef DWORD			TSupportTLSKeyValue;
#	define support_tls_free		TlsFree
#	define support_tls_get_value    TlsGetValue
#	define support_tls_set_value    TlsSetValue
#   else
    typedef pthread_key_t		TSupportTLSKeyValue;
#	define support_tls_free		pthread_key_delete
#	define support_tls_get_value    pthread_getspecific
#	define support_tls_set_value    pthread_setspecific
#   endif // _WIN32
#endif // CSP_LITE

/* Thread Local Storage.   ,    . */
DWORD support_set_thread_specific (unsigned int key, const void *ptr, void **old_ptr);
void *support_get_thread_specific (unsigned int key);
DWORD support_tskey_create (unsigned int *key);
DWORD support_tskey_delete (unsigned int key);

#if defined( __cplusplus )
}
#endif //__cplusplus

#endif // SUPPORT_TLS_H
