/*
 * Copyright (c) 2000,  -
 * 
 *         
 * ,     ,    ,  
 *  :
 * 
 * 1)        
 *         ,    
 *        .
 * 
 * 2)       
 *         ,   
 *           /   ,
 *      .
 * 
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 * 
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SUPPORT_UTF16_H_INCLUDED
#define SUPPORT_UTF16_H_INCLUDED

#include "reader/support_base_defs.h"

#if defined( __cplusplus )
extern "C" {
#endif

#if !defined(CSP_LITE) && !defined(BUG_IN_KERNEL_SPACE_C)
# if defined(UNIX)
typedef uint16_t WIN_WCHAR_T;

static SUP_INLINE CPRO_CHECK_RESULT
size_t support_utf16le_len(const WIN_WCHAR_T *src)
{
    size_t n;
    for (n = 0; src[n]; n++)
	;
    return n;
}

static SUP_INLINE CPRO_CHECK_RESULT
size_t support_utf16le_nlen(const WIN_WCHAR_T *src,
    size_t maxlen /* size in win_wchars */)
{
    size_t n;
    for (n = 0; n < maxlen && src[n]; n++)
	;
    return n;
}

/*  !
   )       ,  
   .         
       ,     
    "   N ",    N+1
   ,        N.
   )      ,   
       ,     ).
   )       UTF-16LE   , 
       --  .
   )   ,   N /,   ,
      N / +   ( N+1
   /).
   )    (slen)   . */
DWORD
support_to_utf16le(
    const char *encoding, /* encoding or NULL (current locale) */
    WIN_WCHAR_T *dst, /* buffer to hold utf16 string or NULL to calculate*/
    size_t *pdlen, /* max size of message in win_wchars w/o terminating zero */
    const TCHAR *src, /* source string (encoded using encoding) */
    size_t slen /* max size of message in chars w/o terminating zero */
) CPRO_CHECK_RESULT;

DWORD
support_from_utf16le(
    const char *encoding, /* enconding or NULL (current locale) */
    TCHAR *dst, /* Buffer to hold the string or NULL to calculate */
    size_t *pdlen, /* max size of message in chars w/o terminating zero */
    const WIN_WCHAR_T *src, /* utf16 string */
    size_t slen /* max size of message in win_wchars w/o terminating zero */
) CPRO_CHECK_RESULT;
# else /* defined(UNIX) */
typedef wchar_t WIN_WCHAR_T;

#   define support_utf16le_len(src) wcslen(src)
#   define support_utf16le_nlen(src,maxlen) wcsnlen((src),(maxlen))

#   ifdef UNICODE
DWORD SUP_INLINE CPRO_CHECK_RESULT
support_to_utf16le(const char *encoding,
    WIN_WCHAR_T *dst,
    size_t *pdlen,
    const TCHAR *src,
    size_t slen)
{
    size_t len;
    (void)(encoding); // TODO:XXX UNUSED(encoding);
    if (pdlen == NULL || src == NULL)
	return (DWORD)ERROR_INVALID_PARAMETER;
    // TODO: wcsncpy_s(dst, 1+*pdlen, src, slen+1);
    len = wcsnlen(src, slen);
    if (dst == NULL) {
	*pdlen = len;
	return (DWORD)NTE_NO_MEMORY;
    }
    if (*pdlen >= len) {
	wcsncpy_s(dst, 1 + *pdlen, src, len + 1);
	return ERROR_SUCCESS;
    } else {
	wcscpy_s(dst, 1 + *pdlen, src);
	return (DWORD)NTE_NO_MEMORY;
    }
}

DWORD SUP_INLINE CPRO_CHECK_RESULT
support_from_utf16le(const char *encoding,
    TCHAR *dst,
    size_t *pdlen,
    const WIN_WCHAR_T *src,
    size_t slen)
{
    size_t len;
    (void)(encoding); // TODO:XXX UNUSED(encoding);
    if (pdlen == NULL || src == NULL)
	return (DWORD)ERROR_INVALID_PARAMETER;
    // TODO: wcsncpy_s(dst, 1+*pdlen, src, slen+1);
    len = wcsnlen(src, slen);
    if (dst == NULL) {
	*pdlen = len;
	return (DWORD)NTE_NO_MEMORY;
    }
    if (*pdlen >= len) {
	wcsncpy_s(dst, 1 + *pdlen, src, len + 1);
	return ERROR_SUCCESS;
    } else {
	wcscpy_s(dst, 1 + *pdlen, src);
	return (DWORD)NTE_NO_MEMORY;
    }
}
#   else
DWORD SUP_INLINE CPRO_CHECK_RESULT
untested_support_to_utf16le(const char *encoding,
    WIN_WCHAR_T *dst,
    size_t *pdlen,
    const TCHAR *src,
    size_t slen)
{
    size_t alloclen = 0;
    (void)(encoding); // TODO:XXX UNUSED(encoding);
    (void)(slen); // TODO:XXX UNUSED(encoding);

    if (pdlen == NULL || src == NULL)
	return (DWORD)ERROR_INVALID_PARAMETER;
    if (dst) {
	alloclen = 1 + *pdlen;
    }
    if (mbstowcs_s(pdlen, dst, alloclen, src, alloclen - 1) ||
	NULL == dst) {
	return (DWORD)NTE_NO_MEMORY;
    }
    return ERROR_SUCCESS;
}

DWORD SUP_INLINE CPRO_CHECK_RESULT
untested_support_from_utf16le(const char *encoding,
    TCHAR *dst,
    size_t *pdlen,
    const WIN_WCHAR_T *src,
    size_t slen)
{
    size_t alloclen = 0;
    (void)(encoding); // TODO:XXX UNUSED(encoding);
    (void)(slen); // TODO:XXX UNUSED(encoding);

    if (pdlen == NULL || src == NULL)
	return (DWORD)ERROR_INVALID_PARAMETER;
    if (dst) {
	alloclen = 1 + *pdlen;
    }
    if (wcstombs_s(pdlen, dst, alloclen, src, alloclen - 1) ||
	NULL == dst) {
	return (DWORD)NTE_NO_MEMORY;
    }
    return ERROR_SUCCESS;
}
#   endif
# endif /* defined(UNIX) */
#endif /* defined(CSP_LITE) */

#if defined( __cplusplus )
}
#endif

#endif //SUPPORT_UTF16_H_INCLUDED
