/*
 * Copyright (c) 2000,  -
 *
 *         
 * ,     ,    ,  
 *  :
 *
 * 1)       
 *         ,   
 *        .
 *
 * 2)       
 *         ,   
 *           /   ,
 *      .
 *
 *        /
 *   "  "  -  , 
 *   , ,    , 
 *        .   
 * ,     ,    
 *  ,          , 
 *   /   ,   
 * ,  Ѩ ,   , , 
 *   ,     
 *   (,     ,
 *  ,  ,    -  
 *  ,        ),
 *           
 *  .
 *
 * Copyright (c) 2000, Crypto-Pro Company All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1) Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2) Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *   .   support_encoding.h.
 */

#ifndef SUPPORT_UTF8_H
#define SUPPORT_UTF8_H

#ifdef UNIX
#include "reader/strnlen_def.h"
#endif //UNIX

#include "reader/support_base_defs.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef UNICODE
//#   define safe_2unilen( src ) (wcslen (src) + 1)
//#   define safe_uni2len( src ) ((wcslen (src) + 1) * sizeof(wchar_t))

#   define safe_2unincpy( dest, src, destlen, srclen ) wcsncpy( dest, src, destlen )
#   define safe_2unicpy( dest, src ) wcscpy( dest, src )
//#   define safe_uni2ncpy( dest, src, destlen, srclen ) wcsncpy( dest, src, srclen )
//#   define safe_uni2cpy( dest, src ) wcscpy( dest, src )
#else /* UNICODE */
//#   define safe_2unilen( src ) MultiByteToWideChar( CP_ACP, 0, (src), (int)(-1), NULL, (int)(0))
//#   define safe_uni2len( src ) WideCharToMultiByte( CP_ACP, 0, (src), (int)(-1), NULL, (int)(0), NULL, NULL )

#   define safe_2unincpy( dest, src, destlen, srclen ) MultiByteToWideChar( CP_ACP, 0, (src), (int)(srclen), (dest), (int)(destlen) )
#   define safe_2unicpy( dest, src ) safe_2unincpy(dest, src, ((strlen(src)+1)*sizeof(wchar_t)), (strlen(src)+1))
//#   define safe_uni2ncpy( dest, src, destlen, srclen ) WideCharToMultiByte( CP_ACP, 0, (src), (int)(srclen), (dest), (int)(destlen), NULL, NULL )
//#   define safe_uni2cpy( dest, src ) safe_uni2ncpy( dest, src, (wcslen(src)+1), ((wcslen(src)+1)*sizeof(wchar_t)))
#endif /* UNICODE */
  
/* src -   NULL .     wchar_t *,     */
#define safe_utf8len_inwc( src ) (MultiByteToWideChar( CP_UTF8, 0, (src), (int)(-1), NULL, (int)(0) ))

/* src -   NULL . srclen -     .
    wchar_t *,     */
#define safe_utf8len_inwc_n( src, srclen ) (MultiByteToWideChar( CP_UTF8, 0, (src), (int)(srclen), NULL, (int)(0) ))

/*   UTF8   wchar_t *
dest -     wchar_t * ,
src -   BYTE *,
destlen -   dest  wchar_t,
srclen -   src   
*/
//#define safe_utf8stowcs( dest, src, destlen, srclen) MultiByteToWideChar( CP_UTF8, 0, (src), (int)(srclen), (dest), (int)(destlen) )

/* src -   wchar_t .      UTF8 . */
#define safe_wcslen_inutf8( src ) (WideCharToMultiByte( CP_UTF8, 0, (src), (int)(-1), NULL, (int)(0), NULL, NULL ))

/* src -   wchar_t . srclen -  src  wchar_t.
     UTF8 . */
//#define safe_wcslen_inutf8_n( src, srclen ) (WideCharToMultiByte( CP_UTF8, 0, (src), (int)(srclen), NULL, (int)(0), NULL, NULL ))

/*   wchar_t   UTF8
dest -     BYTE *,
src -   wchar_t * ,
destlen -   dest   ,
srclen -   src  wchar_t
*/
#define safe_wcstoutf8s( dest, src, destlen, srclen ) WideCharToMultiByte( CP_UTF8, 0, (src), (int)(srclen), (dest), (int)(destlen), NULL, NULL )


typedef void* (*Alloc_func)(void * alloc_param, size_t size);
typedef void(*Free_func)(void * alloc_param, void * ptr);


static void* cpro_std_malloc(void * alloc_param, size_t size)
{
    UNUSED(alloc_param);
    return malloc(size);
}

static void cpro_std_free(void * alloc_param, void * ptr)
{
    UNUSED(alloc_param);
    free(ptr);
}


#ifdef _MSC_VER
#pragma warning (push)
#pragma warning (disable: 4996)
#endif


#ifdef UNIX
#include "locale.h"
const char* get_current_encoding(void);
#else //UNIX 
static SUP_INLINE const char* get_current_encoding()
{
    return "ru_RU.cp1251";
}
#endif //UNIX
static SUP_INLINE BOOL is_utf8_encoding()
{
    const char* csCurLang = get_current_encoding();
    if (!csCurLang) //-V547
	return FALSE;
    if (strstr(csCurLang, "utf8") != NULL)
        return TRUE;
    if (strstr(csCurLang, "UTF-8") != NULL)
        return TRUE;
    return FALSE;
}

/*
   UTF8   TCHAR   .
dest -   .   , ,    TCHAR ,   .
src -   UTF8 ,   .

  ,  .   ,     dest.    NULL.
*/
static SUP_INLINE TCHAR * _utf82cpy(Alloc_func alloc_func, Free_func free_func, void * alloc_param, TCHAR * dest, const char * src, BOOL use_current_locale)
{
    wchar_t * tmpdest = NULL;
    int size = 0;

    if (src == NULL || dest == NULL)
	return NULL;

    if (use_current_locale && is_utf8_encoding()) {
        strcpy ((char*)dest, src);
        return dest;
    }

    size = MultiByteToWideChar(CP_UTF8, 0, src, -1, NULL, 0);
    if (size == 0) {
	return NULL;
    }
    tmpdest = (wchar_t *)alloc_func(alloc_param, size * sizeof(wchar_t));
    if (!tmpdest)
	return NULL;

    size = MultiByteToWideChar(CP_UTF8, 0, src, -1, tmpdest, size);
    if (size == 0) {
	free_func(alloc_param, tmpdest);
	return NULL;
    }

    _uni2cpy(dest, tmpdest);
    free_func(alloc_param, tmpdest);
    return dest;
}

/*
   UTF8   TCHAR   .
dest -   .   , ,    TCHAR ,   .
src -   UTF8 .
destlen -    (TCHAR-),    .   \0.
srclen -       src.

     src   dest,  ,   ,  srclen.  dest   ,      src   . 
*/
static SUP_INLINE TCHAR * _utf82lcpy(Alloc_func alloc_func, Free_func free_func, void * alloc_param, TCHAR * dest, const char * src, size_t destlen, size_t srclen, BOOL use_current_locale)
{
    wchar_t *tmpdest = NULL;
    int len = 0;
    size_t size = 0;

    if (src == NULL || dest == NULL)
	return NULL;

    if (use_current_locale && is_utf8_encoding()) {
	if (srclen > destlen)
	    return NULL;
	memcpy(dest, src, srclen);
	dest[srclen] = _TEXT('\0');
        return dest;
    }

    //   srclen = 0  destlen = 0      MultiByteToWideChar
    if (srclen == 0 && destlen > 0) {
	dest[0] = _TEXT('\0');
	return dest;
    }

    len = MultiByteToWideChar(CP_UTF8, 0, src, (int)srclen, NULL, 0);
    if (len == 0) {
	return NULL;
    }

    tmpdest = (wchar_t *)alloc_func(alloc_param, (len + 1) * sizeof(wchar_t));
    if (!tmpdest)
	return NULL;

    len = MultiByteToWideChar(CP_UTF8, 0, src, (int)srclen, tmpdest, len);
    if (len == 0) {
	free_func(alloc_param, tmpdest);
	return NULL;
    }

    if (wcsnlen(tmpdest, len) == (size_t)len) {
	tmpdest[len] = L'\0';
	size = len + 1;
    } else {
	size = wcsnlen(tmpdest, len) + 1;
    }

    if (size > destlen) {
	free_func(alloc_param, tmpdest);
	return NULL;
    }
    _uni2cpy(dest, tmpdest);
    free_func(alloc_param, tmpdest);
    return dest;
}

/*    TCHAR,    UTF8-,   src.    .*/
static SUP_INLINE size_t _utf82len(const char * src, BOOL use_current_locale)
{
    size_t len;
    if (!src) return 0;
    if (src[0] == '\0')	return 0;

    if (use_current_locale && is_utf8_encoding()) {
        return strlen(src);
    }
    len = (size_t)safe_utf8len_inwc(src);
    return len ? (len - 1) : 0;
}

/*    TCHAR,    UTF8-,   src.    .*/
static SUP_INLINE size_t _utf82llen(const char * src, size_t len, BOOL use_current_locale)
{
    if (!src || !len) 
	return 0;
    if (src[0] == '\0')	
	return 0;

    if (use_current_locale && is_utf8_encoding()) {
	return len;
    }
    return (size_t)safe_utf8len_inwc_n(src, len);
}

/*   TCHAR  UTF8. 
     src   TCHAR,  UTF8 ,   ,  dest.
   NULL    dest  .*/
static SUP_INLINE char * _2utf8cpy(Alloc_func alloc_func, Free_func free_func, void * alloc_param, char* dest, const TCHAR* src, BOOL use_current_locale)
{
    size_t tmplen;
    wchar_t * tmpbuf;

    if (!src || !dest) return NULL;
    tmplen = _tcslen(src);

    if (use_current_locale && is_utf8_encoding()) {
	strcpy(dest, (char*)src);
	return dest;
    }

    tmpbuf = (wchar_t *)alloc_func(alloc_param, (tmplen + 1) * sizeof(wchar_t));
    if (!tmpbuf) return NULL;

    safe_2unicpy(tmpbuf, src);
    safe_wcstoutf8s(dest, tmpbuf, safe_wcslen_inutf8(tmpbuf), tmplen + 1);
    free_func(alloc_param, tmpbuf);
    return dest;
}

/*   TCHAR,   ,  TCHAR  .
   src   TCHAR,  UTF8 ,   ,  dest.
 NULL    dest  .*/
static SUP_INLINE TCHAR * console_2utf8cpy(Alloc_func alloc_func, Free_func free_func, void * alloc_param, TCHAR* dest, const TCHAR* src)
{
    if (is_utf8_encoding()) {
	size_t tmplen;
	wchar_t * tmpbuf;

	if (!src || !dest) return NULL;
	tmplen = _tcslen(src);

	tmpbuf = (wchar_t *)alloc_func(alloc_param, (tmplen + 1) * sizeof(wchar_t));
	if (!tmpbuf) return NULL;

	safe_2unicpy(tmpbuf, src);
	safe_wcstoutf8s((char*)dest, tmpbuf, safe_wcslen_inutf8(tmpbuf), tmplen + 1);
	free_func(alloc_param, tmpbuf);
    }
    else {
	_tcscpy(dest, src);
    }
    return dest;
}

/*     TCHAR  UTF8     
   dest -       UTF8.
   src - ,   TCHAR.
   destlen -   dest  .
   srclen -     src   TCHAR.
        srclen ,  ,  src  dest,    UTF8.    , 
        src   .
    NULL    dest  .
   */
static SUP_INLINE char * _2utf8lcpy(Alloc_func alloc_func, Free_func free_func, void * alloc_param, char* dest, const TCHAR* src, size_t destlen, size_t srclen, BOOL use_current_locale)
{
    size_t tmplen;
    wchar_t * tmpbuf;

    if (!src || !dest) return NULL;

    tmplen = _tcsnlen(src, srclen);

    if (use_current_locale && is_utf8_encoding()) {
	if (tmplen > destlen)
	    return NULL;
        strcpy (dest, (char*)src);
        return dest;
    }

    tmpbuf = (wchar_t *)alloc_func(alloc_param, (tmplen + 1)*sizeof(wchar_t));
    if (!tmpbuf) return NULL;
    safe_2unincpy(tmpbuf, src, tmplen + 1, tmplen);
    tmpbuf[tmplen] = L'\0';

    if ((size_t)safe_wcslen_inutf8(tmpbuf) > destlen)
    {
	free_func(alloc_param, tmpbuf);
	return NULL;
    }

    safe_wcstoutf8s(dest, tmpbuf, safe_wcslen_inutf8(tmpbuf), tmplen + 1);
    free_func(alloc_param, tmpbuf);
    return dest;
}

/*
    src   UTF8,   .
*/
static SUP_INLINE size_t _2utf8len(Alloc_func alloc_func, Free_func free_func, void * alloc_param, const TCHAR * src, BOOL use_current_locale)
{
    size_t tmplen;
    wchar_t * tmpbuf;

    if (!src) return 0;
    if (src[0] == _TEXT('\0'))
	return 0;
    tmplen = _tcslen(src);

    if (use_current_locale && is_utf8_encoding()) {
        return tmplen;
    }

    tmpbuf = (wchar_t *)alloc_func(alloc_param, (tmplen + 1)*sizeof(wchar_t));
    if (!tmpbuf) return 0;

    safe_2unicpy(tmpbuf, src);
    tmplen = safe_wcslen_inutf8(tmpbuf) - 1;
    free_func(alloc_param, tmpbuf);
    return tmplen;
}

/*    UTF8   TCHAR   .
dest -   .   , ,    TCHAR ,   .
src -   UTF8 ,   .

  ,  .   ,     dest.    NULL.

  malloc  free.
*/
static SUP_INLINE TCHAR * std_utf82cpy(TCHAR * dest, const char * src)
{
    return _utf82cpy(cpro_std_malloc, cpro_std_free, NULL, dest, src, TRUE);
}

/*
   UTF8   TCHAR   .
dest -   .   , ,    TCHAR ,   .
src -   UTF8 .
destlen -    (TCHAR-),    .   \0.
srclen -       src.

     src   dest,  ,   ,  srclen.  dest   ,      src   .

  malloc  free.
*/
static SUP_INLINE TCHAR * std_utf82lcpy(TCHAR * dest, const char * src, size_t destlen, size_t srclen)
{
    return _utf82lcpy(cpro_std_malloc, cpro_std_free, NULL, dest, src, destlen, srclen, TRUE);
}

/*    TCHAR,    UTF8-,   src.    .

  malloc  free.
*/
static SUP_INLINE size_t std_utf82len(const char * src)
{
    return _utf82len(src, TRUE);
}

/*    TCHAR,    UTF8-,   src. 

  malloc  free.
*/
static SUP_INLINE size_t std_utf82llen(const char * src, size_t src_len)
{
    return _utf82llen(src, src_len, TRUE);
}

/*     TCHAR  UTF8    
dest -       UTF8.
src - ,   TCHAR.
destlen -   dest  .
srclen -     src   TCHAR.
     srclen ,  ,  src  dest,    UTF8.    ,
     src   .
 NULL    dest  .

  malloc  free.
*/
static SUP_INLINE char * std_2utf8lcpy(char* dest, const TCHAR* src, size_t destlen, size_t srclen)
{
    return _2utf8lcpy(cpro_std_malloc, cpro_std_free, NULL, dest, src, destlen, srclen, TRUE);
}

/*
    src   UTF8,   .
  malloc  free.
*/
static SUP_INLINE size_t std_2utf8len(const TCHAR * src)
{
    return _2utf8len(cpro_std_malloc, cpro_std_free, NULL, src, TRUE);
}

//   CP_ACP <-> UTF-8,      
//      _cpacp

static SUP_INLINE TCHAR* std_utf82lcpy_cpacp(TCHAR* dest, const char* src, size_t destlen, size_t srclen)
{
    return _utf82lcpy(cpro_std_malloc, cpro_std_free, NULL, dest, src, destlen, srclen, FALSE);
}
static SUP_INLINE size_t std_utf82llen_cpacp(const char* src, size_t src_len)
{
    return _utf82llen(src, src_len, FALSE);
}
static SUP_INLINE char* std_2utf8lcpy_cpacp(char* dest, const TCHAR* src, size_t destlen, size_t srclen)
{
    return _2utf8lcpy(cpro_std_malloc, cpro_std_free, NULL, dest, src, destlen, srclen, FALSE);
}
static SUP_INLINE size_t std_2utf8len_cpacp(const TCHAR* src)
{
    return _2utf8len(cpro_std_malloc, cpro_std_free, NULL, src, FALSE);
}

#ifdef _MSC_VER
#pragma warning (pop)
#endif

#ifdef __cplusplus
}
#endif

#endif //SUPPORT_UTF8_H
