/*
 * Copyright(C) 2000-2010  
 *
 *    , 
 *   .
 *
 *  ,    , 
 *         
 *   .
 *
 *     
 *     .
 */

#include <vector>
#include <stdio.h>
#ifdef _WIN32
  #include <tchar.h>
#else
  #include <string.h>
  #include <stdlib.h>
  #include "reader/tchar.h"
#endif	// _WIN32
#include "cpcsp/WinCryptEx.h"

#define TYPE_DER (X509_ASN_ENCODING | PKCS_7_ASN_ENCODING)

//--------------------------------------------------------------------
//         
//     Crypt.

//         
// AT_KEYEXCHANGE   Test(Unix)    (WIN),
//      CryptAcquireContext.

//--------------------------------------------------------------------
//    ,   noreturn
static void HandleError(const char *s);

//--------------------------------------------------------------------
//      GetRecipientCert,  
//     main.
static PCCERT_CONTEXT GetRecipientCert(HCERTSTORE hCertStore);

//--------------------------------------------------------------------
static void do_low_sign(void);
static void do_low_verify(void);

//      do_low_verify()  do_low_sign()
static DWORD cbEncodedBlob;
static BYTE  *pbEncodedBlob = NULL;

int main(void)
{
    do_low_sign();
    ::printf("Do_low_sign DONE \n\n");
    do_low_verify();
    ::printf("Do_low_verify DONE \n\n");
    return 0;
} // end of main

//  oid -,     ,
//  NULL   .
static LPCSTR GetHashOidForSign(HCRYPTPROV hProv, DWORD dwKeySpec) 
{   
    LPCSTR hash_oid = NULL; //    ,  hash_oid  
    ALG_ID key_algid;
    DWORD dwAlgidLen = sizeof(ALG_ID);
    HCRYPTKEY hKey;

    if (!::CryptGetUserKey(hProv, dwKeySpec, &hKey)) 
	HandleError("GetUserKey()");
    if (!::CryptGetKeyParam(hKey, KP_ALGID, (BYTE*)&key_algid, &dwAlgidLen, 0)) 
	HandleError("GetKeyParam()");

    switch(key_algid) 
    {
	case CALG_DH_EL_SF:
	case CALG_GR3410EL:
	    hash_oid = szOID_CP_GOST_R3411;
	    break;
	case CALG_DH_GR3410_12_256_SF:
	case CALG_GR3410_12_256:
	    hash_oid = szOID_CP_GOST_R3411_12_256;
	    break;
	case CALG_DH_GR3410_12_512_SF:
	case CALG_GR3410_12_512:
	    hash_oid = szOID_CP_GOST_R3411_12_512;
	    break;
	default:
	    HandleError("Bad key algid"); // noreturn
    }

    if (!::CryptDestroyKey(hKey)) 
	HandleError("DestroyKey()");

    return hash_oid;
}

void do_low_sign(void)
{
//--------------------------------------------------------------------
//    .
    static const BYTE pbContent[] = "Security is our business."; // 
    static const DWORD cbContent = (DWORD) sizeof(pbContent); //  

    ::printf("About to begin with the message %s.\n",pbContent);
    ::printf("The message length is %d bytes. \n", cbContent);

//--------------------------------------------------------------------
//    .

    HCERTSTORE hStoreHandle = ::CertOpenSystemStore(0, _TEXT("My"));
    if(!hStoreHandle)
        HandleError("Error getting store handle.");
    ::printf("The MY store is open. \n");

//--------------------------------------------------------------------
//       
//  GetRecipientCert. 

    PCCERT_CONTEXT pRecipientCert = GetRecipientCert(hStoreHandle);
    if(!pRecipientCert)
    {
        ::printf("No certificate with a CERT_KEY_CONTEXT_PROP_ID \n");
        ::printf("property and an AT_KEYEXCHANGE private key available. \n");
        ::printf("While the message could be sign, in this case, \n");
        ::printf("it could not be veryfy in this program. \n");
        ::printf("For more information, see the documentation  \n");
        HandleError( "No Certificate with AT_KEYEXCHANGE key in store.");
    }
    ::printf("A recipient's certificate has been acquired. \n");

//--------------------------------------------------------------------
//   
    HCRYPTPROV hCryptProv;
    DWORD keytype = AT_KEYEXCHANGE; //   ()
    BOOL bReleaseContext;
    if (!::CryptAcquireCertificatePrivateKey(
	    pRecipientCert,
            CRYPT_ACQUIRE_SILENT_FLAG,
            NULL,
            &hCryptProv,
            &keytype,
            &bReleaseContext)) 
    {
        HandleError( "Cannot acquire the certificate private key");
    }

//--------------------------------------------------------------------
//    .
    CRYPT_ALGORITHM_IDENTIFIER  HashAlgorithm;
    ::memset(&HashAlgorithm, 0, sizeof(HashAlgorithm));

//--------------------------------------------------------------------
//   .
    HashAlgorithm.pszObjId = (LPSTR) GetHashOidForSign(hCryptProv, keytype);

//--------------------------------------------------------------------
//   CMSG_SIGNER_ENCODE_INFO
    CMSG_SIGNER_ENCODE_INFO SignerEncodeInfo; // ,  
    ::memset(&SignerEncodeInfo, 0, sizeof(CMSG_SIGNER_ENCODE_INFO));
    SignerEncodeInfo.cbSize = sizeof(CMSG_SIGNER_ENCODE_INFO);
    SignerEncodeInfo.pCertInfo = pRecipientCert->pCertInfo;
    SignerEncodeInfo.hCryptProv = hCryptProv;
    SignerEncodeInfo.dwKeySpec = keytype;
    SignerEncodeInfo.HashAlgorithm = HashAlgorithm;
    SignerEncodeInfo.pvHashAuxInfo = NULL;

//--------------------------------------------------------------------
//     
    CMSG_SIGNER_ENCODE_INFO SignerEncodeInfoArray[1];
    SignerEncodeInfoArray[0] = SignerEncodeInfo;

    CMSG_SIGNED_ENCODE_INFO SignedMsgEncodeInfo; // ,   
    ::memset(&SignedMsgEncodeInfo, 0, sizeof(CMSG_SIGNED_ENCODE_INFO));
    SignedMsgEncodeInfo.cbSize = sizeof(CMSG_SIGNED_ENCODE_INFO);
    SignedMsgEncodeInfo.cSigners = 1;
    SignedMsgEncodeInfo.rgSigners = SignerEncodeInfoArray;
    SignedMsgEncodeInfo.cCertEncoded = 0;
    SignedMsgEncodeInfo.rgCertEncoded = NULL;
    SignedMsgEncodeInfo.rgCrlEncoded = NULL;

//--------------------------------------------------------------------
//   
    HCRYPTMSG hMsg =
	::CryptMsgOpenToEncode(
	    TYPE_DER,               // Encoding type
	    0,			    // Flags
	    CMSG_SIGNED,            // Message type*
	    &SignedMsgEncodeInfo,   // Pointer to structure
	    NULL,                   // Inner content object ID
	    NULL);                  // Stream information (not used)
    if(!hMsg)
	HandleError("OpenToEncode failed");
    ::printf("The message to be encoded has been opened. \n");

//--------------------------------------------------------------------
//     
    if(!::CryptMsgUpdate(
	   hMsg,		// Handle to the message
	   pbContent,		// Pointer to the content
	   cbContent,		// Size of the content
	   TRUE)) 		// Last call
	HandleError("MsgUpdate failed");

    ::printf("Content has been added to the encoded message. \n");

//--------------------------------------------------------------------
//    
    if(!::CryptMsgGetParam(
	   hMsg,		// Handle to the message
	   CMSG_CONTENT_PARAM,	// Parameter type
	   0,			// Index
	   NULL,		// Pointer to the blob
	   &cbEncodedBlob))	// Size of the blob
	HandleError("MsgGetParam failed");

    ::printf("The length of the data has been calculated.\n");

//--------------------------------------------------------------------
//  ,  
    pbEncodedBlob = (BYTE *)::malloc(cbEncodedBlob);
    if(!pbEncodedBlob)
	HandleError("Memory allocation failed");

//--------------------------------------------------------------------
//   
    if(!::CryptMsgGetParam(
	   hMsg,		    // Handle to the message
	   CMSG_CONTENT_PARAM,	    // Parameter type
	   0,			    // Index
	   pbEncodedBlob,	    // Pointer to the blob
	   &cbEncodedBlob))	    // Size of the blob
	HandleError("MsgGetParam failed");
    ::printf("Message encoded successfully. \n");

//  
    if (!::CryptMsgClose(hMsg)) {
	HandleError("CryptMsgClose failed");
    }
    if(bReleaseContext)
	::CryptReleaseContext(hCryptProv, 0);
    ::CertFreeCertificateContext(pRecipientCert);

    if (::CertCloseStore(hStoreHandle, CERT_CLOSE_STORE_CHECK_FLAG))
        ::printf("The MY store was closed without incident. \n");
    else
        ::printf("Store closed after encryption -- \n"
            "but not all certificates or CRLs were freed\n");

} // end of do_low_sign

void do_low_verify(void)
{
    HCRYPTPROV hCryptProv;
    if(!::CryptAcquireContext(
	   &hCryptProv,
	   NULL,
	   NULL,	         //    
	   PROV_GOST_2012_256,   //     
	   CRYPT_VERIFYCONTEXT))  //    
	HandleError("Cryptographic context could not be acquired.");
    ::printf("A CSP has been acquired. \n");

//--------------------------------------------------------------------
//    .
    HCERTSTORE hStoreHandle = ::CertOpenSystemStore(0, _TEXT("MY"));
    if(!hStoreHandle)
        HandleError( "Error getting store handle.");
    ::printf("The MY store is open. \n");
       
//--------------------------------------------------------------------
//       
//  GetRecipientCert.
    PCCERT_CONTEXT pRecipientCert = GetRecipientCert(hStoreHandle);
    if(!pRecipientCert)
    {
        ::printf("No certificate with a CERT_KEY_CONTEXT_PROP_ID \n");
        ::printf("property and an AT_KEYEXCHANGE private key available. \n");
        ::printf("While the message could be sign, in this case, \n");
        ::printf("it could not be veryfy in this program. \n");
        ::printf("For more information, see the documentation \n");
        HandleError( "No Certificate with AT_KEYEXCHANGE key in store.");
    }
    ::printf("A recipient's certificate has been acquired. \n");

//--------------------------------------------------------------------
//    
    HCRYPTMSG hMsg = ::CryptMsgOpenToDecode(
	TYPE_DER,		// Encoding type
	CMSG_CRYPT_RELEASE_CONTEXT_FLAG, // Flags
	0,			// Use the default message type
	hCryptProv,		// Cryptographic provider
	NULL,			// Recipient information
	NULL);			// Stream information
    if(!hMsg)
        HandleError("OpenToDecode failed");
    ::printf("The message to decode is open. \n");

//--------------------------------------------------------------------
//     
    BOOL bResult = ::CryptMsgUpdate(
        hMsg,			// Handle to the message
        pbEncodedBlob,		// Pointer to the encoded blob
        cbEncodedBlob,		// Size of the encoded blob
        TRUE);			// Last call
    if(!bResult)
	HandleError("Decode MsgUpdate failed");
    ::printf("The encoded blob has been added to the message. \n");
    ::free(pbEncodedBlob);

//--------------------------------------------------------------------
//    
    DWORD cbDecoded;
    bResult = ::CryptMsgGetParam(
	hMsg,			// Handle to the message
	CMSG_CONTENT_PARAM,	// Parameter type
	0,			// Signed Index
	NULL,			// Address for returned info
	&cbDecoded);		// Size of the returned info
    if(!bResult)
	HandleError("Decode CMSG_CONTENT_PARAM failed");
    ::printf("The message parameter (CMSG_CONTENT_PARAM) has been acquired. Message size: %u\n", cbDecoded);

//--------------------------------------------------------------------
//   
    std::vector<BYTE> pbDecoded(cbDecoded);
    bResult = ::CryptMsgGetParam(
	hMsg,			// Handle to the message
	CMSG_CONTENT_PARAM,	// Parameter type
	0,			// Signer Index
	&pbDecoded[0],		// Address for returned info
	&cbDecoded);		// Size of the returned info
    if(!bResult)
	HandleError("Decode CMSG_CONTENT_PARAM #2 failed");
    ::printf("The message param (CMSG_CONTENT_PARAM) returned. Length is %lu.\n", (unsigned long)cbDecoded);

//--------------------------------------------------------------------
//  
//    CERT_INFO  

//--------------------------------------------------------------------
//   
//       
//     ,     
// CertGetSubjectCertificateFromStore,   , 
//      
    HCERTSTORE hStoreHandleM =
	::CertOpenStore(CERT_STORE_PROV_MEMORY, TYPE_DER, 0, 0, NULL);
    if (!hStoreHandleM)
	HandleError("Cannot create temporary store in memory.");

    /*    */
    bResult = CertAddCertificateContextToStore(hStoreHandleM, pRecipientCert, CERT_STORE_ADD_ALWAYS, NULL);
    if (!bResult)
	HandleError("Cannot add user certificate to store.");

    PCERT_INFO pSignerCertInfo = pRecipientCert->pCertInfo;

//--------------------------------------------------------------------
//     
    PCCERT_CONTEXT pSignerCertContext =
	::CertGetSubjectCertificateFromStore(
	    hStoreHandleM,	// Handle to store
	    TYPE_DER,           // Encoding type
	    pSignerCertInfo);
    if(!pSignerCertContext)
	HandleError("Verify GetSubjectCert failed");
    ::printf("A signer certificate has been retrieved.");
 
//--------------------------------------------------------------------
//   CERT_INFO   
    PCERT_INFO pSignerCertificateInfo = pSignerCertContext->pCertInfo;
    bResult = ::CryptMsgControl(
	hMsg,			    // Handle to the message
	0,			    // Flags
	CMSG_CTRL_VERIFY_SIGNATURE, // Control type
	pSignerCertificateInfo);    // Pointer to the CERT_INFO
    if(bResult)
	::printf("\nSignature was VERIFIED.\n");
    else
	::printf("\nThe signature was NOT VERIFIED.\n");

//  
    ::CertFreeCertificateContext(pSignerCertContext);
    ::CertFreeCertificateContext(pRecipientCert);

    if(::CertCloseStore(hStoreHandleM, CERT_CLOSE_STORE_CHECK_FLAG))
	::printf("Memory store was closed without incident.\n");
    else
	::printf("Memory store closed -- but not all certificates or CRLs were freed.\n");

    //   , ..  pRecipientCert
    //   CERT_CLOSE_STORE_CHECK_FLAG      
    if(::CertCloseStore(hStoreHandle, CERT_CLOSE_STORE_CHECK_FLAG))
	::printf("The MY store was closed without incident.\n");
    else
	::printf("The MY store closed  -- but not all certificates or CRLs were freed.\n");

    if (!::CryptMsgClose(hMsg)) {
	HandleError("CryptMsgClose failed");
    }
} //end of do_low_verify

//       HandleError,  
//   ,         
//   (stderr)    . 
//         , 
//        .

static void HandleError(const char *s)
{
    const DWORD err = ::GetLastError();
    ::printf("Error number     : 0x%x\n", err);
    ::printf("Error description: %s\n", s);
    if(!err)
	::exit(1);
    ::exit(err);
} //   HandleError

//    
static BOOL isGostType(DWORD dwProvType)
{
    return IS_GOST_PROV(dwProvType);
}

//--------------------------------------------------------------------
// GetRecipientCert      
//  ,   AT_EXCHANGE.  
//  ,     .  
static PCCERT_CONTEXT GetRecipientCert(HCERTSTORE hCertStore) 
//-------------------------------------------------------------------- 
//  : 
// hCertStore,  ,     . 
{ 
//-------------------------------------------------------------------- 
//     . 
    PCCERT_CONTEXT pCertContext = NULL; 
    bool fMore = true;

//-------------------------------------------------------------------- 
//       ,     
//  ,     AT_KEYEXCHANGE   . 

    do { 
//------------------------------------------------------------- 
//          
//   AT_KEYEXCHANGE.   ,  
//   ,     
//  . 
	DWORD PropId = CERT_KEY_PROV_INFO_PROP_ID; 
	pCertContext = ::CertFindCertificateInStore( 
	    hCertStore, //  ,     . 
	    TYPE_DER,   //  .     . 
	    0,          // dwFindFlags.   . 
	                //     . 
	    CERT_FIND_PROPERTY, 
                        //  .   ,   
                        // .   ,  ,  
                        //    . 
	    &PropId,    // pvFindPara.   
                        // ,      
                        //  . 
	    pCertContext); 
                        // pCertContext  NULL     
                        // .     ,
                        //     pCertContext 
                        // ,   .

	if (!pCertContext) 
	    break;

//------------------------------------------------------------- 
//    CertGetCertificateContextProperty  
//     . 
	DWORD dwSize;
        if(!::CertGetCertificateContextProperty( 
             pCertContext, 
             CERT_KEY_PROV_INFO_PROP_ID, 
             NULL, &dwSize))
	    HandleError("Error getting key property."); 

//-------------------------------------------------------------- 
//     . 
	std::vector<unsigned char> vKI(dwSize);
	CRYPT_KEY_PROV_INFO* pKeyInfo = reinterpret_cast<CRYPT_KEY_PROV_INFO*> (&vKI[0]);

//-------------------------------------------------------------- 
//     . 

        if(!::CertGetCertificateContextProperty(
	       pCertContext,
	       CERT_KEY_PROV_INFO_PROP_ID,
	       pKeyInfo,
	       &dwSize))
            HandleError("The second call to the function failed.");

//------------------------------------------- 
//   dwKeySpec      .
        if(pKeyInfo->dwKeySpec == AT_KEYEXCHANGE && isGostType(pKeyInfo->dwProvType)) 
            fMore = false;
    } while(fMore && pCertContext);

    if (pCertContext)
    {
        TCHAR sName[256];
        CertGetNameString(pCertContext, CERT_NAME_FRIENDLY_DISPLAY_TYPE, 0, NULL, sName, 256);
        _tprintf(_TEXT("GetRecipientCert: %s\n"), sName);
    }
    return pCertContext;
} //   GetRecipientCert 

// 2016-sep-01  UNIX   hPRov CPCSP-6767
// END-OF-FILE
