/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

#include "fat12prj.h" /*+ Project (READER/FAT12) include.
     include    (READER/FAT12). +*/

/*++++ 
 *   . 
 ++++*/
DWORD fat12_close( 
    TSupSysContext *context, 
    TSupSysInfo *info )
{
  TFat12Context *ctx = (TFat12Context*)context;
  DWORD code=ERROR_SUCCESS;
  UNUSED(info);
  
  if( context == NULL )
    return ERROR_SUCCESS;
  if( ctx->handle == NULL)
    return ERROR_SUCCESS;
#ifdef UNIX
  if( fclose( ctx->handle ) ) {
    code = fat12_os_error();
    if( !code )
      code=(DWORD)SCARD_W_UNSUPPORTED_CARD;
  }
  ctx->handle = NULL;
#else /* UNIX */
  if( ctx->handle != INVALID_HANDLE_VALUE )
    {
      FILETIME time1;
      FILETIME time2;
      SYSTEMTIME cur_time;
      unsigned int last_error_mode;
      last_error_mode = 0;
      
      GetSystemTime( &cur_time );
      // TODO   
      SystemTimeToFileTime( &cur_time, &time2 );
      GetFileTime( ctx->handle, &time1, NULL, NULL );
      if( ( ctx->access & GENERIC_WRITE )
	  && !SetFileTime( ctx->handle, &time1, &time2, &time2 ) ) {
	  code = fat12_os_error();
	  if( code != (DWORD)SCARD_E_NOT_READY ) goto done;
      }
      last_error_mode = SetErrorMode( 0 );
      CloseHandle( ctx->handle ); 
      SetErrorMode( last_error_mode );
    }
done:
  ctx->handle = INVALID_HANDLE_VALUE;
#endif /* UNIX */
  free(ctx->file_name);
  ctx->file_name = NULL;
  
  return code;
}
