/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 149220 $
 * \date $Date:: 2016-11-21 14:16:46 +0300#$
 * \author $Author: sagafyin $
 * \brief       .
 */

#include "fat12prj.h"

#define LOCAL_PATH _TEXT( "\\protected_local" )
#define GLOBAL_PATH _TEXT("\\protected_global")
#define HSM_FOLDER _TEXT("\\hsm_keys")

DWORD hdimage_path_default( 
    TCHAR **str, int machine, BOOL is_hsm )
{
    size_t length = 0;
    TCHAR *path;
    const TCHAR *p;
    DWORD code;

    if( machine & 1 )
	p = is_hsm ? (GLOBAL_PATH HSM_FOLDER) : GLOBAL_PATH;
    else
	p = is_hsm ? (LOCAL_PATH HSM_FOLDER) : LOCAL_PATH;
    
    code = support_path2dir( p, &length, NULL );
    if( code )
	return code;
    path = malloc( ( length + 2 ) * sizeof( TCHAR ) );
    if( path == NULL )
	return (DWORD)NTE_NO_MEMORY;
    code = support_path2dir( p, &length, path );
    if( code )
    {
	free( path );
	return code;
    }
#ifdef UNIX
    if (!(machine & 1))
    {
	code = support_thread_actualize_uids();
	if (code)
	{
	    free(path);
	    return code;
	}
        if (chmod(path,S_IRWXU)) {
	    code = fat12_os_error();
	    support_thread_deactualize_uids();
	    free( path );
	    return code;
	}
	support_thread_deactualize_uids();
    }
#endif /* UNIX */
    _tcscat(path,_TEXT("/"));
    *str = path;

    return ERROR_SUCCESS;
}
/* end of file: $Id: hdidef.c 149220 2016-11-21 11:16:46Z sagafyin $ */
