/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 282568 $
 * \date $Date:: 2024-12-02 17:20:49 +0300#$
 * \author $Author: sdd $
 * \brief    .
 */

#include "fat12prj.h"
#include "cpcsp/visibility.h"
#include "reader.kit/rdr_ver.h"

/*!
 * \ingroup hdimage_internal
 * \brief      .
 * \sa #TSupSysFunctionTable, #TSupSysFunctionTableItem, #hdimage_funs
 */
static const TSupSysFunctionTableItem hdimage_funs[] =
{
    { SUPSYS_FUN_INSTANCE, fat12_info_instance },
    { SUPSYS_FUN_CONTEXT_DUP, hdimage_context_dup },
    { SUPSYS_FUN_CONTEXT_FREE, fat12_context_free },
    { SUPSYS_FUN_IDS_BLOCK, hdimage_info_ids },
    { SUPSYS_FUN_FLAGS, hdimage_info_system_flag },
    { SUPSYS_FUN_VERSIONSUPPORT, info_versionsupport},

    { SUPSYS_FUN_REGISTER, hdimage_register },
    { SUPSYS_FUN_UNREGISTER, hdimage_unregister },

    { READER_FUN_LOCAL_MACHINE, hdimage_local_machine },

    { READER_FUN_GET_PARAM, fat12_get_param },
    { READER_FUN_PASSWORD_TYPE, fat12_get_password_type },
    { READER_FUN_GET_APPLET_TEXT_INFO, hdimage_get_text_info },

    { READER_FUN_FOLDER_ENUM_OPEN, fat12_info_folder_enum_open },
    { READER_FUN_FOLDER_ENUM_NEXT, fat12_info_folder_enum_next },
    { READER_FUN_FOLDER_ENUM_CLOSE, fat12_info_folder_enum_close },

    { READER_FUN_FOLDER_OPEN, fat12_folder_open },
    { READER_FUN_FOLDER_CLOSE, fat12_folder_close },

#ifdef _WIN32
    { READER_FUN_SEC_DESCR_READ, fat12_folder_get_sdecr},
#endif //_WIN32

    { READER_FUN_FOLDER_CLEAR, fat12_folder_clear },
    { READER_FUN_OPEN, fat12_open },
    { READER_FUN_CLOSE, fat12_close },
    { READER_FUN_UNLINK, fat12_unlink },

#ifdef _WIN32
    { READER_FUN_SEC_DESCR_WRITE, fat12_folder_put_sdecr },
#endif //_WIN32

    { READER_FUN_READ, fat12_read },
    { READER_FUN_WRITE, fat12_write },
    { READER_FUN_CHSIZE, fat12_chsize },
    { READER_FUN_LENGTH, fat12_length },
    { READER_FUN_GET_FREE_SPACE, fat12_free_space},
};

/*!
 * \ingroup hdimage_internal
 * \brief    .
 * \sa #TSupSysFunctionTable, #TSupSysFunctionTableItem, #hdimage_funs
 */
static const TSupSysFunctionTable hdimage_table =
{
    sizeof( hdimage_funs ) / sizeof( TSupSysFunctionTableItem ),
    hdimage_funs
};

/*!
 * \ingroup hdimage_external
 * \brief      .
 * \sa #rdr_register_all, #TSupSysExportFunction
 * \return      .
 * \internal    #hdimage_table
 */
CPRO_PUBLIC_API const TSupSysEHandle *hdimage_reader_get_table(void)
{
    return (const TSupSysEHandle*)&hdimage_table;
}
