/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 279022 $
 * \date $Date:: 2024-10-10 12:21:45 +0300#$
 * \author $Author: das $
 * \brief     (RDR).
 */

#if !defined( _READER_H )
#define _READER_H

#include <stdlib.h>

#include "reader/tchar.h"
#include "reader/support.h" 
#include "reader/rdr_indie.h" 
#include "reader.kit/sup_sys.h"
#include "reader.kit/sup_lst.h"

#define READER_FUN_PASSWD_TERM 0x304
#define READER_FUN_CARRIER_TYPE 0x305
#define READER_FUN_CANCEL_CONSEQUENCES 0x1300
// 0x2300 
#define READER_FUN_LOCK 0x2301
#define READER_FUN_UNLOCK 0x2302
#define READER_FUN_CONNECT_CARRIER 0x2303
#define READER_FUN_DISCONNECT_CARRIER 0x2304
// 0x2305 
#define READER_FUN_LOCAL_MACHINE 0x2306
#define READER_FUN_GET_PARAM 0x2307
#define READER_FUN_FOLDER_PARAM_SET 0x2308
#define READER_FUN_AUTH_INFO 0x2309
#define READER_FUN_SET_APP 0x230A
#define READER_FUN_PASSWORD_TYPE 0x230B
#define READER_FUN_PROVIDER_INFO 0x230C
#define READER_FUN_ALGID_INFO 0x230D
#define READER_FUN_SET_AUTH_INFO 0x230E
#define READER_FUN_SET_SM_STATE 0x230F
#define READER_FUN_GET_APPLET_TEXT_INFO 0x2310
#define READER_FUN_GET_LIC_PERMISSIONS 0x2311
#define READER_FUN_UNIQUE_GET 0x3300
#define READER_FUN_USER_DEFINED_NAME_GET 0x3301
#define READER_FUN_FOLDER_ENUM_OPEN 0x3302
#define READER_FUN_FOLDER_ENUM_NEXT 0x3303
#define READER_FUN_FOLDER_ENUM_CLOSE 0x3304
#define READER_FUN_FOLDER_OPEN 0x3305
#define READER_FUN_FOLDER_CLOSE 0x3306
#define READER_FUN_PASSWD_PHRASE 0x3309
#define READER_FUN_RANDOM_GET 0x3310
#define READER_FUN_GET_DEFAULT_FOLDER 0x3311
#define READER_FUN_SET_DEFAULT_FOLDER 0x3312
#define READER_FUN_GET_HARDWARE_FLAGS 0x3313
#define READER_FUN_SET_HARDWARE_FLAGS 0x3314
#define READER_FUN_OID_INFO 0x3315

#define READER_FUN_SIMPLE_LOGIN_TEXT 0x5301
#if defined _MSC_VER
/*  READER_FUN_SIMPLE_LOGIN  .
 *         char  BYTE,     TCHAR*->char*   ,
 *    READER_FUN_SIMPLE_LOGIN_ASCII,       char*.    -
 *       TCHAR,   READER_FUN_SIMPLE_LOGIN_TEXT.
 *  -Win     ,       .
 *      READER_FUN_SIMPLE_LOGIN  READER_FUN_SIMPLE_LOGIN_ASCII        
 *   , ,      .
 */
#define READER_FUN_SIMPLE_LOGIN __pragma(deprecated("READER_FUN_SIMPLE_LOGIN")) READER_FUN_SIMPLE_LOGIN_TEXT
#else
#define READER_FUN_SIMPLE_LOGIN READER_FUN_SIMPLE_LOGIN_TEXT
#endif 

#define READER_FUN_LOGOUT 0x5302
#define READER_FUN_SELF_LOGIN 0x5303
#define READER_FUN_AUTH_CHALLENGE 0x5304
#define READER_FUN_RESTORE_DEFAULT_ROOT 0x5305
#define READER_FUN_SEC_DESCR_READ 0x5307 
#define READER_FUN_HASH_INIT 0x5308
#define READER_FUN_HASH_DATA 0x5309
#define READER_FUN_HASH_GETVAL 0x530A
#define READER_FUN_HASH_DESTROY 0x530B
#define READER_FUN_SIMPLE_LOGIN_ASCII 0x530C
#define READER_FUN_FOLDER_CLEAR 0x6300

#define READER_FUN_PASSWD_CHANGE_TEXT 0x6301
/*  READER_FUN_PASSWD_CHANGE  .
 *         char  BYTE,     TCHAR*->char*   ,
 *    READER_FUN_PASSWD_CHANGE_ASCII,       char*.    -
 *       TCHAR,   READER_FUN_PASSWD_CHANGE_TEXT.
 *  -Win     ,       .
 *      READER_FUN_PASSWD_CHANGE  READER_FUN_PASSWD_CHANGE_ASCII       
 *   , ,      .
 */
#if defined _MSC_VER
#define READER_FUN_PASSWD_CHANGE __pragma(deprecated("READER_FUN_PASSWD_CHANGE")) READER_FUN_PASSWD_CHANGE_TEXT
#else
#define READER_FUN_PASSWD_CHANGE READER_FUN_PASSWD_CHANGE_TEXT
#endif 

#define READER_FUN_OPEN 0x6302
#define READER_FUN_CLOSE 0x6303
#define READER_FUN_UNLINK 0x6304
#define READER_FUN_SEC_DESCR_WRITE 0x6307
#define READER_FUN_CLEAR_TRIES 0x6308
#define READER_FUN_SELF_CHANGE 0x630A
#define READER_FUN_PASSWD_CHANGE_ASCII 0x630B
#define READER_FUN_READ 0x7300
#define READER_FUN_WRITE 0x7301
#define READER_FUN_CHSIZE 0x7302
#define READER_FUN_LENGTH 0x7303
#define READER_FUN_KEY_GEN 0x7304
#define READER_FUN_KEY_SET 0x7305
#define READER_FUN_SIGNATURE 0x7307
#define READER_FUN_AGREEMENT 0x7308
#define READER_FUN_GET_FREE_SPACE 0x7309
#define READER_FUN_AGREEMENT_FULL 0x730C
#define READER_FUN_PUBLIC_KEY 0x730D
#define READER_FUN_SET_2001 0x730E
#define READER_FUN_WEAK_SIGNATURE1 0x730F
#define READER_FUN_WEAK_SIGNATURE2 0x7310
#define READER_FUN_KEY_GEN_RSA 0x7311
#define READER_FUN_EXPTMOD_RSA 0x7312
#define READER_FUN_PUBLIC_KEY_RSA 0x7313
#define READER_FUN_AVAILABLE_LENGTH_RSA 0x7314
#define READER_IDS_BLOCK 0x400
#define READER_IDS_BASE 0x1300
#define READER_IDS_CARRIER_TYPE 2
#define READER_IDS_QUANT_V1 ( READER_IDS_CARRIER_TYPE + 1 )

#define READER_PASSWD_DEF_SIZE 0x20

#define READER_CONNECT_CARRIER_FLAG_FORMAT 0x1

#define READER_MODEFLAG_BITS 8

/*!
* \ingroup reader_types
* \defgroup reader_errors  ,     .
* <table>
* <tr><th></th><th></th></tr>
* <tr><td>ERROR_SUCCESS</td><td>  .</td></tr>
* <tr><td>ERROR_MORE_DATA</td><td>    ,  .</td></tr>
* <tr><td>ERROR_FILE_NOT_FOUND</td><td>  (, , )    .</td></tr>
* <tr><td>ERROR_NOT_SUPPORTED</td><td>   .      .</td></tr>
* <tr><td>ERROR_NO_MORE_ITEMS</td><td>     .</td></tr>
* <tr><td>NTE_NOT_SUPPORTED</td><td>   .     .</td></tr>
* <tr><td>NTE_EXISTS</td><td>   .</td></tr>
* <tr><td>NTE_BAD_KEYSET</td><td>     .</td></tr>
* <tr><td>NTE_BAD_KEY_STATE</td><td>      .</td></tr>
* <tr><td>NTE_NO_MEMORY</td><td>    .</td></tr>
* <tr><td>NTE_TOKEN_KEYSET_STORAGE_FULL</td><td>       .</td></tr>
* <tr><td>NTE_SILENT_CONTEXT</td><td>    ,     CRYPT_SILENT.</td></tr>
* <tr><td>NTE_PERM</td><td>   .</td></tr>
* <tr><td>ERROR_INVALID_PARAMETER, NTE_BAD_DATA</td><td>    .</td></tr>
* <tr><td>SCARD_W_CANCELLED_BY_USER</td><td>   .</td></tr>
* <tr><td>SCARD_W_WRONG_CHV</td><td>  .</td></tr>
* <tr><td>SCARD_E_INVALID_CHV</td><td>   .</td></tr>
* <tr><td>SCARD_W_CHV_BLOCKED</td><td>  -      .</td></tr>
* <tr><td>SCARD_E_NOT_READY</td><td>   -     .</td></tr>
* <tr><td>SCARD_W_SECURITY_VIOLATION</td><td>    .</td></tr>
* <tr><td>SCARD_E_READ_ONLY_CARD</td><td>         .</td></tr>
* </table>
*      :    (\ref rdr_auth_errs)    -   (\ref rdr_return_errs).
*/

/*! 
* \addtogroup rdr_ext_fkc_type
* \{
*/

typedef BYTE * TReaderFkcOrderPtr; //!<    .
typedef BYTE * TReaderFkcUKMPtr; //!< ,  UKM.
typedef BYTE * TReaderFkcRndmPtr; //!<   .

//! ,   / / 
typedef struct 
{
    unsigned o_read : 1;      /*!<     */
    unsigned o_write : 1;     /*!<     */
    unsigned o_create : 1;    /*!<     */
    unsigned o_private : 1;   /*!< / ,     (   ) */
} TReaderInfoOpenFlags;

//! ,   
typedef struct
{
    TRdrLoginInfoType type;  /*!<  ,    */
    TSupSysInfoText text;    /*!<   */
} TReaderInfoPasswdText;

//!  
typedef struct 
{
    TSupSysNickname type; /*!<   */
    const TCHAR * path_to_item; /*!<    */
} TReaderInfoCarrierType;

//!     Algid'
typedef struct
{
    BOOL    forUserKey;		    /*!< TRUE -      , FALSE -     (SESPAKE) */
    TRdrLoginInfoType auth_type;    /*!<     , ,     */
    size_t size;		    /*!<    */
    TRdrFkcEllipticPointParam * algs;   /*!<   */
} TReaderInfoAlgIds; 

//!      RSA 
typedef struct
{
    DWORD min_key_bits; //  RSA-  
    DWORD max_key_bits; //  RSA-  

    /* .   0,       min_key_bits, max_key_bits.
      0,      
    [min_key_bits, min_key_bits+1*increment_bits, min_key_bits+2*increment_bits,... max_key_bits]
    */
    DWORD increment_bits; 
} TReaderAvailableRsaLength;

//!      
typedef struct
{
    BOOL    isSM;		    /*!< TRUE -    , FALSE -     */
    TRdrLoginInfoType auth_type;    /*!<  iSM,    ,  - 0 */
} TReaderInfoSmState;

#define READER_VALID_FUN_OK 0
#define READER_VALID_FUN_WRONG (-1)
#define READER_VALID_FUN_UNDEF 1

//!     
typedef struct 
{
    unsigned flags; /*!< [in] READER_CONNECT_CARRIER_FLAG_FORMAT   */
    TSupSysEList *media_list; /*!< [in]    */
    unsigned int applet_count; /*!< [out]       */
    TSupSysFindValidFun valid_fun; /*!< [in]    ,  media      .  READER_VALID_FUN_- */
    TSupSysFindInfo* rdr_info; /*!< [in] valid_fun callback info*/
} TReaderInfoConnectCarrier;

//!     
typedef struct 
{
    const TSupSysEContext *context; /*!<    (    ) */
    TSupSysInfoText name; /*!< [out]  enum_open  length             \0.
			              enum_next              \0 */
    TSupSysInfoUntyped add_info; /*!<   ,    ,    */ 
    TSupSysInfoText prototype; /*!<  :    RDR_FOLDER_ENUM_FLAG_NEW,       */ 
    unsigned flags; /*!<  . (\ref rdr_enum_flags) */ 
} TReaderInfoFolderEnum;

//!  / 
typedef struct
{
    TSupSysInfoText name; /*!<    (     (long_names == 0) */
    size_t mode_bits; /*!< not used (depricated) */
    TReaderInfoOpenFlags mode; /*!<  / */
} TReaderInfoFolderOpen;

//!    (SIMPLE)    READER_FUN_SIMPLE_LOGIN_TEXT
typedef struct
{
    TRdrLoginInfoType auth_type; /*!<    */
    TSupSysInfoText passwd; /*!<   */
    int retries; /*!< [out]    . ,          . */
} TReaderInfoLogin;

//!    (SIMPLE)    READER_FUN_SIMPLE_LOGIN_ASCII
typedef struct
{
    TRdrLoginInfoType auth_type; /*!<    */
    TSupSysInfoAsciiText passwd; /*!<   */
    int retries; /*!< [out]    . ,          . */
} TReaderInfoLoginAscii;


//!  /    
typedef struct 
{
    unsigned long sec_info; /*!<       */
    TSupSysInfoUntyped sec_descr; /*!<  PSECURITY_DESCRIPTOR */
} TReaderInfoSecDescrRW;

//!    (SIMPLE)    READER_FUN_PASSWD_CHANGE_TEXT
typedef struct
{
    TRdrLoginInfoType auth_type; /*!<    */
    TSupSysInfoText passwd; /*!<    */
    TRdrLoginInfoType set_auth_type; /*!<  ,    .  0,    */
    TSupSysInfoText set_passwd; /*!<   ,     */
} TReaderInfoPasswdChange;

//!    (SIMPLE)    READER_FUN_PASSWD_CHANGE_ASCII
typedef struct
{
    TRdrLoginInfoType auth_type; /*!<    */
    TSupSysInfoAsciiText passwd; /*!<    */
    TRdrLoginInfoType set_auth_type; /*!<  ,    .  0,    */
    TSupSysInfoAsciiText set_passwd; /*!<   ,     */
} TReaderInfoPasswdChangeAscii;


//!    (SIMPLE) 
typedef struct
{
    size_t mode_bits; /*!< not used (depricated) */ 
    TReaderInfoOpenFlags mode;  /*!<  /  */
    TSupSysInfoText name; /*!<    */
    TRdrFileNumber num; /*!<    */
} TReaderInfoOpen;

//!   
typedef struct
{
    TSupSysInfoText name; /*!<    */
    TRdrFileNumber num; /*!<    */
} TReaderInfoUnlink;

//!     
typedef struct
{
    size_t from; /*!< ,     .       info.info   . */
    TSupSysInfoUntyped info; /*!< info.info -    ; info.length     -   ;     -   . 
			             , ,       ,     ,  
				    info.length,     */
} TReaderInfoRead;

//!     
typedef struct
{
    size_t from; /*!< ,     .    -,   info.info. */
    TSupSysInfoUntyped info; /*!< info.info -    ; info.length     -   ;     -    
			        , ,       ,     ,  
			       info.length,     */
} TReaderInfoWrite;

//!     
typedef size_t TReaderInfoChSize;

//!      
typedef size_t TReaderInfoLength;

//!   
typedef size_t TReaderInfoFreeSpaceSize;

//!  -  
typedef BYTE TRdrHashValue[RDR_FKC_HASH_VALUE_SIZE_512];

//!      
typedef struct
{
    unsigned int hash_algid;	    //!< ALG_ID  - (CALG_SHA1/CALG_GR3411/CALG_GR3411_2012_256/CALG_GR3411_2012_512) 
    TSupSysEContext * handle;	    //!< [out]  (ID)     .
} TReaderFkcHashInit;

//!     
typedef struct
{
    TSupSysEContext * handle;	    //!<   ,   
    TSupSysInfoUntyped info;	    //!<  
    size_t hashed_len;		    //!< [out]    
} TReaderFkcHashData;

//!   -  
typedef struct
{
    TSupSysEContext * handle;	    //!<   ,   
    TRdrHashValue hashval;	    //!< [out] -,  
    size_t hash_len;	            //!< [out]  -
} TReaderFkcHashGetVal;


typedef TSupSysEContext * TReaderFkcHashDestroy; //!<    
typedef TRdrFkcSespakeCounters TReaderInfoSespakeCounters; //!<   SESPAKE
typedef TRdrFkcFolderEnumParam TReaderFkcFolderEnumParam; //!<  / 

//!         
typedef struct
{
    TProvCallCtx context; //!<       
    TCarrierCallbacks callbacks; //!<  ,     
} TReaderProviderInfo;

typedef enum {
    TRdrFkcSecureMessagingMode_CNT,
    TRdrFkcSecureMessagingMode_CBC
} TRdrFkcSecureMessagingMode;

typedef enum {
    TRdrFkcSecureMessagingCipher_28147,
    TRdrFkcSecureMessagingCipher_3412M
} TRdrFkcSecureMessagingCipher;

typedef enum {
    TRdrFkcSecureMessagingImit_28147,
    TRdrFkcSecureMessagingImit_3413M
} TRdrFkcSecureMessagingImit;

//!     
typedef struct _TRdrFkcSecureMessagingParams {
    BOOL padding; //!<    8  ISO 7816-4
    TRdrFkcSecureMessagingType sm_type; //!<  
    union {
	struct {
	    TRdrFkcSecureMessagingCipher cipher_algid; //!<  
	    TRdrFkcSecureMessagingImit imit_algid; //!<  
	    TRdrFkcSecureMessagingMode cipher_mode; //!<    
	} iso_params;
	struct {
	    void* dummy;
	} fkc_params;
    } params;
} TRdrFkcSecureMessagingParams;

//!    //
typedef struct
{
    TReaderFkcFolderEnumParam paramID; //!<   
    union {
	struct {
	    TRdrLoginInfoType auth_type; //!<  ,    
	    TReaderInfoSespakeCounters counters; //!<    BE- : cSESPAKE, cFail, cCFail.
	    BOOL has_counters; //!<    
	} sespake_counters; //!< TCEP_sespake_counters
	struct {
	    TCHAR * password;
	    size_t max_length;
	} root_password;				//!< TCEP_default_password
	DWORD security_level;				//!< TCEP_fkc_csp_interface_container (\ref csp_interface)
	TRdrFkcCarrierFlags fkc_flags;			//!< TCEP_fkc_flags
	TRdrUniversalCarrierFlags uni_flags;		//!< TCEP_uni_flags
	unsigned int auth_types;			//!< TCEP_auth_types
	TRdrLoginInfoType is_auth_type_blocked;		//!< TCEP_auth_state. 
	struct {
	    TCHAR * password;
	    size_t max_length;
	    DWORD auth_type;
	} any_password;					//!< TCEP_default_password_auth_type
	struct {
	    char * password;
	    size_t max_length;
	    DWORD auth_type;
	} any_password_ascii;				//!< TCEP_default_password_auth_type_ascii
	TRdrFkcSecureMessagingParams sm_params;         //!< TCEP_sm_params
    } info;
} TReaderInfoGetParam;

//!     //
typedef struct
{
    TReaderFkcFolderEnumParam paramID;
    union {
        TSupSysInfoUntyped hex_param;             //!< TCEP_header, TCEP_cloud_certificate, TCEP_cloud_extensions
	TSupSysInfoAsciiText string_param;        //!< TCEP_cloud_auth_server, TCEP_cloud_sign_server, TCEP_cloud_OAuth2_auth_token, TCEP_cloud_OAuth2_id_token
	DWORD dword_param;			  //!< TCEP_cloud_certificate_id, TCEP_cloud_permissions
    } info;
} TReaderInfoSetParam;

//!      
typedef enum {
    TReaderInfoPwdEncoding_default = 0,
    TReaderInfoPwdEncoding_UTF8 = 1
} TReaderInfoPwdEncoding;


//! ,     
typedef struct
{
    unsigned int uiRetries;	/*!<   ,       */
    size_t max_pwd_length;	/*!<     */
    size_t min_pwd_length; 	/*!<     */
    TReaderInfoPwdEncoding password_encoding; /*!<  */
} TReaderInfoAuthInfoPwd;


//! ,      SESPAKE
typedef struct
{
    BYTE flags;		/*!<  1   ,   group_id; 
			      2   ,     (salt, ind); 
			      4   ,    Qpw.
			      8   ,     SESPAKE.
			     */

    TRdrFkcEllipticPointParam group_id;  //!< ID   
    TReaderFkcRndmPtr salt; /*!<  salt*/
    BYTE ind;		    /*!<   ind*/
    TRdrFkcPoint * Qpw;	    /*!<  Qpw*/
    BOOL prehash_password;  /*!<     */
    BOOL dont_use_mq;       /*!<    SESPAKE        m/q*/
} TReaderInfoAuthSESPAKE;

//!  ,  .
typedef union
{
    TReaderInfoAuthInfoPwd info_pwd;
    TReaderInfoAuthSESPAKE info_sespake;
} TReaderInfoAuthInfoUnion;

//!  ,      
typedef struct 
{
    TRdrLoginInfoType auth_type; /*!<  ,     */
    TCHAR friendly_name[224]; /*!< unused */
    TReaderInfoAuthInfoUnion info; /*!< [out]   . */
} TReaderInfoAuthInfo;

//!     SESPAKE
typedef enum
{
    TRECc_first = 1,		/*!<   SESPAKE.    U1,  U2. */
    TRECc_second = 2		/*!<   SESPAKE.    HMACa,  HMACb. */
} TReaderSespakeChallengeClass;

//!  ,            SESPAKE
typedef union
{
    struct {
	TRdrFkcPoint * u2;		    //!<  U2,     .    .    #TRdrFkcCarrierFlags real_edwards_auth,    .
    } first;
     struct {
	BYTE * hmacB;                       //!<  HMAC-B,     .
    } second_12;
} TReaderSespakeChallenge2csp;


//!  ,            SESPAKE
typedef union
{
    struct {
	TRdrFkcPoint * u1;		    //!<  U1,     .    .    #TRdrFkcCarrierFlags real_edwards_auth,    .
    } first;
    struct {
	BYTE * hmacA;                       //!<  HMAC-A,     .
    } second_12;
} TReaderSespakeChallenge2fkc;

//! ,      SESPAKE 
typedef struct
{
    TRdrLoginInfoType auth_type;                     //!<   (ROOT/PUK/CONT)
    TRdrFkcTrID	transaction_id;	                     //!<     SESPAKE
    TReaderSespakeChallengeClass challenge_class;    //!<   SESPAKE
    TReaderSespakeChallenge2csp to_CSP;              //!< [out] ,     
    TReaderSespakeChallenge2fkc to_FKC;              //!< ,     
} TReaderInfoAuthChallenge;

/*! \} */

/*!
* \defgroup reader_external_interface    
*/

/*! 
 * \ingroup reader_external_interface 
 * \defgroup Reader_RDR_12     
 */

/*!
* \defgroup reader_interface    
*/


/*!
* \ingroup reader_interface
* \defgroup reader_interface_fkc_fun   
*/  


/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_KEY_GEN
* \brief   .
*
*         . ,    (#TRdrUniversalCarrierFlags functional_container && #TRdrFkcCarrierFlags genKey).
*      .  (#TRdrUniversalCarrierFlags folders),     .
*
* \sa \ref TReaderFkcKeyGen
*
*/  


/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_PASSWD_TERM
* \brief    .
*
*    ,     (, -,   ..).
*       . 
* \sa \ref TReaderInfoPasswdText
*
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_CARRIER_TYPE
* \brief    .
*
*    ,     .    (-  )    .
* \sa \ref TReaderInfoCarrierType
*
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_LOCK
* \brief      .
*
*   ,   .     :   ,    ,    .
*        ,      :  ,  "" ,    
*      .      READER_FUN_DISCONNECT_CARRIER.
*  ,         .
* \sa \ref TProvCallCtx 
*
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_UNLOCK
* \brief      . 
*
*       ,     READER_FUN_LOCK. 
*          .
*     .     ,    . 
*
*
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_CONNECT_CARRIER
* \brief ,    . 
*
* ,    .   ,       .
*       .    ,  . 
*    -       #RSCARD_FUN_CONNECT_CARRIER.
* \sa \ref TReaderInfoConnectCarrier
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_DISCONNECT_CARRIER
* \brief ,    .
*
*      ,      .
*     .    ,  .
*        ,   READER_FUN_LOCK
*      -    CPR_ERR_RDR.
*
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_LOCAL_MACHINE
* \brief  ,    . 
*
*      ,      .
*
*
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_GET_PARAM
* \brief    //.
*
* ,       //.
*      paramID,      #TRdrFkcFolderEnumParam.   -  ,    ERROR_NOT_SUPPORTED.
*
*
* \sa \ref TReaderInfoGetParam
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_FOLDER_PARAM_SET
* \brief    ,   CryptSetProvParam.
*
*        CLOUD.
*
*
* \sa \ref TReaderInfoSetParam 
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_AUTH_INFO
* \brief    . 
*
*     ,    .
*     (SESPAKE  SIMPLE)    SESPAKE (    group_id, salt  ind, Qpw),      (, ), 
*     . 
*
*
* \sa \ref TReaderInfoAuthInfo
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_SET_APP
* \brief   . 
*
*    int,    .       [0:n-1],  n -   
*  ,     #READER_FUN_CONNECT_CARRIER  #RSCARD_FUN_CONNECT_CARRIER.          .
*   / ,    ,      .   (, n=1),     . 
*   /       (  ),        ERROR_FILE_NOT_FOUND.
*
*
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_PASSWORD_TYPE
* \brief ,    . 
*
*   #READER_FUN_GET_PARAM c  TCEP_auth_types         (\ref rdr_auth_flags), 
*   ,   .   (\ref rdr_auth_algs)        #READER_FUN_PASSWORD_TYPE. 
*      : if ((*type & AUTH_TYPE_TYPE_MASK) == AUTH_TYPE_TYPE_ROOT) *type = AUTH_TYPE_TYPE_ROOT | AUTH_TYPE_AUTH_SIMPLE;
*
*
* \sa \ref TRdrLoginInfoType
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_PROVIDER_INFO
* \brief    .
*
*      ,     . 
*
*
* \sa \ref TReaderProviderInfo
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_ALGID_INFO
* \brief       .
*
*          (forUserKey == TRUE) /   SESPAKE (forUserKey == FALSE).
*      ,       #TRdrFkcEllipticPointParam,    .
*   algs    NULL,     . 
*
*
* \sa \ref TReaderInfoAlgIds 
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_OID_INFO
* \brief      OID     . 
* 
*    .   ,       
*  READER_FUN_ALGID_INFO      OID' .
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_SET_AUTH_INFO
* \brief     ()  SESPAKE.
*
*     Qpw, ind, salt, group_id   SESPAKE-. 
*      APDU-.             . 
*     :  ,  ,    (),    . 
*      ,   ,   . 
*
* \sa TReaderInfoAuthInfo
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_SET_SM_STATE
* \brief          (SM) .
*
*    BOOL    SM.    FALSE     ( SESPAKE)      .
*    TRUE    SESPAKE (  )    .       .
*    -  .    #READER_FUN_LOGOUT. 
*
*
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_GET_APPLET_TEXT_INFO
* \brief ,        . 
*
*    .  ,      , 
*    . 
*
* \sa \ref TSupSysInfoText
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_UNIQUE_GET
* \brief     .
*
* Unique   ,   ,     . : XTOKEN_11223344. 
*   text == NULL,         .    ,          ERROR_MORE_DATA.
*   text != NULL,   ,       (length + 1) TCHAR-. 
*       removable- (-  -).
*
* \sa \ref TSupSysInfoText
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_USER_DEFINED_NAME_GET
* \brief    ,  .
*
*   text == NULL,         .    ,          ERROR_MORE_DATA.
*   text != NULL,   ,       (length + 1) TCHAR-. 
*
* \sa \ref TSupSysInfoText
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_FOLDER_ENUM_OPEN
* \brief       .
*
*   - (USB-)       Folders,   ,   ,   #READER_FUN_FOLDER_ENUM_NEXT  
* #READER_FUN_FOLDER_ENUM_CLOSE   .        ,      #READER_FUN_FOLDER_ENUM_NEXT.
*     add_info,        .           
*     add_info,   #READER_FUN_FOLDER_ENUM_NEXT           . 
*       :             ,      ( #TRdrUniversalCarrierFlags long_names == 0).
*        RDR_FOLDER_ENUM_FLAG_OPEN,   -  RDR_FOLDER_ENUM_FLAG_NEW.     RDR_FOLDER_ENUM_FLAG_NEW,   prototype      
*  .       .  ,   -    .
*
*
* \sa \ref TReaderInfoFolderEnum
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_FOLDER_ENUM_NEXT
* \brief        . 
*
*       name,    .      ,    ,
*   #READER_FUN_FOLDER_ENUM_OPEN.     ,     ERROR_NO_MORE_ITEMS.
*
*
* \sa \ref TReaderInfoFolderEnum
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_FOLDER_ENUM_CLOSE
* \brief   .
*
*         .    ,   #READER_FUN_FOLDER_ENUM_OPEN. 
*
*  \sa \ref TReaderInfoFolderEnum
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_FOLDER_OPEN
* \brief  /   .
* 
*      (  long_names     ).    o_create,     . 
*       .       ,     NTE_TOKEN_KEYSET_STORAGE_FULL.     ,  NTE_EXISTS.
*      .  (long_names == FALSE)     #READER_FUN_FOLDER_ENUM_NEXT.       .
*
* 
* \sa \ref TReaderInfoFolderOpen
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_FOLDER_CLOSE
* \brief   .
*         .           ,    .
*       .    ,     APDU-.
*
* \sa \ref TReaderInfoFolderOpen
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_PASSWD_PHRASE
* \brief     .
*  ,    ,      .  ,  .      .
*
* \sa \ref TReaderInfoPasswdText 
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_RANDOM_GET
* \brief    .
*           .    ,   .     ,     .
* \sa \ref TSupSysInfoUntyped
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_GET_DEFAULT_FOLDER
* \brief        .
*   ,       .  ,         def.key   .
* \sa \ref TSupSysInfoText
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_SET_DEFAULT_FOLDER
* \brief         .
*   ,       .  ,         def.key   .
* \sa \ref TSupSysInfoText
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_SIMPLE_LOGIN
* \brief      .  .
*
*         char  BYTE,     TCHAR*->char*   ,
*    \ref READER_FUN_SIMPLE_LOGIN_ASCII,       char*.    -
*       TCHAR,   \ref READER_FUN_SIMPLE_LOGIN_TEXT.  -Win     , 
*       .
*
*      \ref READER_FUN_SIMPLE_LOGIN  \ref READER_FUN_SIMPLE_LOGIN_ASCII       
*   , ,      .
* \sa \ref TReaderInfoLogin
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_SIMPLE_LOGIN_ASCII
* \brief      .
*   ,   #READER_FUN_PASSWORD_TYPE  ,       SIMPLE-.       .
*   ,    ,    SCARD_W_WRONG_CHV.   ,   ,        .
*   ,    SCARD_W_CHV_BLOCKED.    ,    ERROR_SUCCESS.
*
*      \ref READER_FUN_SIMPLE_LOGIN  \ref READER_FUN_SIMPLE_LOGIN_ASCII       
*   , ,      .
*
*     ASCIIZ- (char*).
*
* \sa \ref TReaderInfoLoginAscii
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_SIMPLE_LOGIN_TEXT
* \brief      .
*   ,   #READER_FUN_PASSWORD_TYPE  ,       SIMPLE-.       .
*   ,    ,    SCARD_W_WRONG_CHV.   ,   ,        .
*   ,    SCARD_W_CHV_BLOCKED.    ,    ERROR_SUCCESS.
*
*       TCHAR.
*
*    \ref READER_FUN_SIMPLE_LOGIN,     .
*
* \sa \ref TReaderInfoLogin
*/


/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_LOGOUT
* \brief   .
*       .   SESPAKE    #READER_FUN_SET_SM_STATE   APDU.
*
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_SELF_LOGIN
* \brief   .
*   ,   #READER_FUN_PASSWORD_TYPE  ,       SELF-.   ,      
* . ,     . 
*
* \sa \ref TRdrLoginInfoType 
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_AUTH_CHALLENGE
* \brief    SESPAKE.
*   ,   #READER_FUN_PASSWORD_TYPE  ,       SESPAKE.    (   challenge_class). 
*       U1,  U2.       HMACa,  HMACb.          50.1.1152016.
*        ,  transaction_id   ,      . 
*
* \sa \ref TReaderInfoAuthChallenge
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_RESTORE_DEFAULT_ROOT
* \brief         ,      .
*   ,   #READER_FUN_GET_PARAM   TCEP_auth_types    AUTH_FLAG_TYPE_CAN_RESET_ROOT_DEF. 
*    .     .      ROOT    
*  , TCEP_auth_types    AUTH_FLAG_TYPE_IS_DEF_ROOT,  TCEP_default_password -   . 
*      ,     PUK (  ),     CPR_ERR_RDR_NEED_PUK_AUTH.
*
*     -   AUTH_FLAG_TYPE_HARDWARE_RESET_ROOT_DEF.            .
* ,       5      USB-,       . 
*
*/
 
/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_SEC_DESCR_READ
* \brief       Microsoft.
*       Windows.
*                       
*  \sa \ref TReaderInfoSecDescrRW
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_HASH_INIT
* \brief  .    \ref rdr_crypt_hash_init
*
* \sa \ref TReaderFkcHashInit
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_HASH_DATA
* \brief  .    \ref rdr_crypt_hash_data
*
* \sa \ref TReaderFkcHashData
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_HASH_GETVAL
* \brief  .    \ref rdr_crypt_hash_getval
*  \sa \ref TReaderFkcHashGetVal
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_HASH_DESTROY
* \brief  .    \ref rdr_crypt_hash_destroy
*
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_FOLDER_CLEAR
* \brief    . 
*     .      ,   ,   .
*              (, ,  ).
*  #TRdrUniversalCarrierFlags folders == 0       ,   ,    .
*
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_PASSWD_CHANGE
* \brief   SIMPLE-.
*  .
*
*         char  BYTE,     TCHAR*->char*   ,
*    \ref READER_FUN_PASSWD_CHANGE_ASCII,       char*.    -
*       TCHAR,   \ref READER_FUN_PASSWD_CHANGE_TEXT.
*  -Win     ,       .
*
*      ,     PUK (  ),     CPR_ERR_RDR_NEED_PUK_AUTH.
*
*      \ref READER_FUN_PASSWD_CHANGE  \ref READER_FUN_PASSWD_CHANGE_ASCII       
*   , ,      .
*
* \sa \ref TReaderInfoPasswdChange 
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_PASSWD_CHANGE_ASCII
* \brief   SIMPLE-.
*
*  ,        .
*      (   )       ASCIIZ- (char*).
*
*      ,     PUK (  ),     CPR_ERR_RDR_NEED_PUK_AUTH.
*
*      \ref READER_FUN_PASSWD_CHANGE  \ref READER_FUN_PASSWD_CHANGE_ASCII       
*   , ,      .
*
* \sa \ref TReaderInfoPasswdChangeAscii
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_PASSWD_CHANGE_TEXT
* \brief   SIMPLE-.
*
*  ,        .
*      (   )         TCHAR*.
*
*    \ref READER_FUN_PASSWD_CHANGE,     .
*
* \sa \ref TReaderInfoPasswdChange
*/


/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_OPEN
* \brief  /   .
*     ,      ().      o_private     
*      .     o_write      .      .
* <table>
* <tr><th> </th><th> </th><th>   </th><th></th></tr>
* <tr><td>1</td><td>masks.key</td><td>88</td><td> </td></tr>
* <tr><td>2</td><td>primary.key</td><td>135</td><td> </td></tr>
* <tr><td>3</td><td>header.key</td><td>10000+</td><td>     </td></tr>
* <tr><td>4</td><td>masks2.key</td><td>88</td><td> </td></tr>
* <tr><td>5</td><td>primary2.key</td><td>135</td><td> </td></tr>
* <tr><td>6</td><td>name.key</td><td>260</td><td>  </td></tr>
* <tr><td>7</td><td>def.key</td><td>260</td><td>    .    . </td></tr>
* <tr><td>8</td><td>certificate_kx.key</td><td>5000+</td><td>   exchange-.    csp_interface. (\ref csp_interface)</td></tr>
* <tr><td>9</td><td>certificate_sig.key</td><td>5000+</td><td>   signature-.    csp_interface. (\ref csp_interface)</td></tr>
* <tr><td>10</td><td>extensions.key</td><td></td>5000+<td>  .    csp_interface. (\ref csp_interface)</td></tr>
* </table>
*
* \sa \ref TReaderInfoOpen 
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_CLOSE
* \brief   .
*   ,   / .      .
*
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_UNLINK
* \brief   .
*       .          -   .    .
*
* \sa \ref TReaderInfoUnlink 
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_SEC_DESCR_WRITE
* \brief       Microsoft.
*       Windows.
*
* \sa \ref TReaderInfoSecDescrRW
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_CLEAR_TRIES
* \brief      .
*   ,   #READER_FUN_GET_PARAM   TCEP_auth_types    AUTH_FLAG_TYPE_CAN_RESET_COUNTERS. 
*         .     . 
*
* \sa \ref TRdrLoginInfoType 
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_SELF_CHANGE
* \brief   SELF-.
*   ,      . ,       .
*
* \sa \ref TRdrLoginInfoType 
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_READ
* \brief         . 
*   info.length ,    from.    info.length     .
*      ,       :   . from   
*  ,    .         0. 
*       .
* \sa \ref TReaderInfoRead
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_WRITE
* \brief         .
*   info.length   ,    from.    info.length      .
*      ,       :   . from   
*  ,    .      ,    0.
* \sa \ref TReaderInfoWrite
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_CHSIZE
* \brief    . 
*         .        .      , 
*     . 
* \sa \ref TReaderInfoChSize
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_LENGTH
* \brief      . 
*    "" ,    ,       .
* \sa \ref TReaderInfoLength
*/


/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_KEY_SET
* \brief      .   ,    #TRdrFkcCarrierFlags setKey.
*     .       k'=k+m.      .
*          2^32 (""   ). 
* , : for (j = 0; j < sign_params->secret_key_length / sizeof(uint32_t); j++) dfkc[j] -= mask[j];
*           .         ,
*                . 
*
* \sa \ref TReaderFkcKeySet
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_SIGNATURE
* \brief   .
*      .       (),    (r,s).
*       ,          #READER_FUN_HASH_INIT.
*
* \sa \ref TReaderFkcSignInfo
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_GET_FREE_SPACE
* \brief         
*  .
* \sa \ref TReaderFkcSignInfo
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_WEAK_SIGNATURE1
* \brief        .
*   \ref READER_FUN_SIGNATURE,      ,     w.
*
* \sa \ref TReaderFkcSignInfo, \ref READER_FUN_SIGNATURE, \ref READER_FUN_WEAK_SIGNATURE2
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_WEAK_SIGNATURE2
* \brief        .
*     (        ),   l, 
*     v.
*
* \sa \ref TReaderFkcSignInfo, \ref READER_FUN_WEAK_SIGNATURE1, \ref READER_FUN_SIGNATURE
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_KEY_GEN_RSA
* \brief   RSA-.*
*         . ,    (#TRdrUniversalCarrierFlags functional_container && #TRdrFkcCarrierFlags genKey).
*      .  (#TRdrUniversalCarrierFlags folders),     .
* \sa \ref TReaderFkcRsaKeyGen
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_EXPTMOD_RSA
* \brief       RSA.
*      .
*          (),    (s).
*       ,          #READER_FUN_HASH_INIT.
*         (),    (s).
* \sa \ref TReaderFkcRsaExptmodInfo
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_PUBLIC_KEY_RSA
* \brief     RSA.
*     csp_interface (\ref csp_interface).     . 
* \sa \ref TReaderFkcRsaPublicKeyGet
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_AVAILABLE_LENGTH_RSA
* \brief        RSA.
*      ,       RSA  .
* \sa \ref TReaderAvailableRsaLength
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_AGREEMENT_FULL
* \brief   VKO.
*      .      (Qb)  UKM(r,s). 
*    ,    K=H(m/q * UKM * d * Qb),  d -    ,  H -  ,
*    .     .
*      #TRdrFkcCarrierFlags dh_supported_algid  #TRdrFkcCarrierFlags ableDH.  ,     (  34.11-94/2012).
*  -   VKO : , ,  ().         ,    
*        .       2^32   . 
* , : for (j = 0; j < EXCHANGE_KEY_LENGTH / sizeof(uint32_t); j++) VKO_key_out[j] += mask[j]. 
*   VKO      , ..    .
*
* \sa \ref TReaderAgreeInfo
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_PUBLIC_KEY
* \brief    .
*     csp_interface (\ref csp_interface).     . 
* \sa \ref TReaderFkcPublicKeyGet
*/

/*! \ingroup reader_interface_fkc_fun
* \def READER_FUN_SET_2001
* \brief    ,   2001 .  csp_interface (\ref csp_interface)
*        ,  ,    ( 2012 
*  2001 )     .       .
*     ,       2001 . 
*   NTE_BAD_KEYSET,       2001 ,   ,
*     2012 .    ,    ,  ,
*        ,    
* NTE_BAD_KEYSET.
*/



/*! \ingroup rdr_ext_fkc_type
* \brief     .
*
* \ref READER_FUN_KEY_GEN
*/
typedef struct {
    TRdrFkcEllipticPointParam group_id;	//!< ID   
    int index;		    //!<  ,   .   0   ; 1  ,     .
    TRdrFkcPoint * public_key; //!<  -  ,   
    TKeyAlgType alg_type; //!<  ,      
    DWORD key_type;	  //!< AT_KEYEXCHANGE  AT_SIGNATURE (\ref csp_interface)
    DWORD alg_id;	  //!<    (\ref csp_interface)
    BOOL  is_able_dh;     //!<  ,        -. 
    char * oid;		    //!< OID     (\ref csp_interface)
    const BYTE * add_random_data;    //!<     .
    DWORD random_data_length;	    //!<    
    DWORD permissions;	  //!<   (\ref csp_interface)
} TReaderFkcKeyGen;

/*! \ingroup rdr_ext_fkc_type
* \brief      RSA.
*
* \ref READER_FUN_KEY_GEN_RSA
*/
typedef struct {
    DWORD rsa_len;		    //!<   RSA   
    long public_exp;		    //!<   RSA
    int index;			    //!<  ,   .   0   ; 1  ,     .
    TRdrFkcRsaKey *public_key;	    //!<       RSA
    DWORD key_type;		    //!< AT_KEYEXCHANGE  AT_SIGNATURE (\ref csp_interface)
    DWORD alg_id;		    //!<    (\ref csp_interface)
    BOOL  is_able_dh;		    //!<  ,        -. 
    const BYTE *add_random_data;    //!<     .
    DWORD random_data_length;	    //!<    
    DWORD permissions;		    //!<   (\ref csp_interface)
} TReaderFkcRsaKeyGen;

/*! \ingroup rdr_ext_fkc_type
* \brief      
*
* \ref READER_FUN_KEY_SET
*/
typedef enum {
    TSetKeyStep_first = 1,	/*!<   :    */
    TSetKeyStep_second = 2	/*!<   :    */
} TSetKeyStep;


/*! \ingroup rdr_ext_fkc_type
* \brief     .
*
* \ref READER_FUN_KEY_SET
*/
typedef struct
{
    TReaderFkcOrderPtr  dfkc; //!<  ,      (    ,   -     2^32)
    TRdrFkcPoint * public_key; //!<  ,     .
    int index;	    //!<     .   0   ; 1  ,     .     .
    DWORD key_length; //!<   .
    TRdrFkcEllipticPointParam group_id;	//!< ID   
    TSetKeyStep step; //!<    
    TKeyAlgType alg_type; //!<  ,      
    DWORD key_type;	  //!< AT_KEYEXCHANGE  AT_SIGNATURE (\ref csp_interface)
    DWORD alg_id;	  //!<    (\ref csp_interface)
    BOOL is_able_dh;	  //!<  ,        -. 
    char * oid;		  //!< OID     (\ref csp_interface)
    DWORD permissions;	  //!<   (\ref csp_interface)
} TReaderFkcKeySet;


/*! \ingroup rdr_ext_fkc_type
* \brief       . (\ref csp_interface)
*
*/
typedef struct
{
    DWORD key_type;		    //!< [in] AT_KEYEXCHANGE  AT_SIGNATURE
    struct {
	unsigned value : 1;
	unsigned id_g : 1;
	unsigned alg_id : 1;
	unsigned oid : 1;
	unsigned is_able_dh : 1;
	unsigned permissions : 1;
    } flags;			    //!< [in] ,  ,  . 
    TRdrFkcPoint * value;	    //!< [out]  ,    key_type
    TRdrFkcEllipticPointParam id_g; //!< [out]   
    DWORD alg_id;		    //!< [out]     - ALG_ID  CryptAPI.
    char * oid;			    //!< [out] OID   
    BOOL is_able_dh;		    //!< [out]  ,       -. 
    DWORD permissions;		    //!< [out]  
} TReaderFkcPublicKeyGet;

/*! \ingroup rdr_ext_fkc_type
* \brief     RSA   . (\ref csp_interface)
*
*/
typedef struct
{
    DWORD key_type;		    //!< [in] AT_KEYEXCHANGE  AT_SIGNATURE 
    TRdrFkcRsaKey *value;	    //!< [out]   RSA,    key_type
} TReaderFkcRsaPublicKeyGet;


/*! \ingroup rdr_ext_fkc_type
* \brief     
* \ref #READER_FUN_SIGNATURE
*/
typedef struct 
{
    int index;	//!<  
    struct {
	TReaderFkcOrderPtr e;  //!< in -   big-endian
	size_t e_length;       //!< in -    
	TReaderFkcOrderPtr r;  //!< out -   
	size_t r_length;       //!< out -  r  
	TReaderFkcOrderPtr s;  //!< out -   
	size_t s_length;       //!< out -  s  
    } Simple_Sign;
    TSupSysEContext * hash_ctx; //!< in -  ,    ,     
    DWORD key_type;		//!<  . 1 == AT_KEYEXCHANGE, 2 == AT_SIGNATURE. (\ref csp_interface) 
} TReaderFkcSignInfo;

/*! \ingroup rdr_ext_fkc_type
* \brief          RSA
* \ref #READER_FUN_EXPTMOD_RSA
*/
typedef struct
{
    int index;			//!< in -  
    struct {
	const BYTE* e;		//!< in -   ( / )  big-endian
	size_t e_length;	//!< in -     
	size_t pl_length;	//!< in -  ""   
	BYTE* s;		//!< out -   ( RSA/ )  big-endian
	size_t s_length;	//!< out -     
    } Simple_Sign;
    TSupSysEContext *hash_ctx;	//!< in -  ,    ,     
    DWORD key_type;		//!< in -  . 1 == AT_KEYEXCHANGE, 2 == AT_SIGNATURE (\ref csp_interface)
    DWORD hash_alg;		//!< in -    - ALG_ID  CryptAPI
} TReaderFkcRsaExptmodInfo;

/*! \ingroup rdr_ext_fkc_type
* \brief          
* \ref #READER_FUN_WEAK_SIGNATURE1
*/
typedef struct
{
    TRdrFkcTrID transaction_id; //!<  
    TReaderFkcSignInfo params;	//!<  
    TReaderFkcOrderPtr w;	//!< out -  w   
    size_t w_length;		//!< out -  w  
} TReaderFkcWeakSignFirstInfo;

/*! \ingroup rdr_ext_fkc_type
* \brief          
* \ref #READER_FUN_WEAK_SIGNATURE2
*/
typedef struct
{
    TRdrFkcTrID transaction_id; //!<  
    TReaderFkcOrderPtr l;	//!< in -   l   
    size_t l_length;		//!< in -  l  
    TReaderFkcOrderPtr v;	//!< out -  v   
    size_t v_length;		//!< out -  v  
    int index;         	        //!<  
} TReaderFkcWeakSignSecondInfo;


/*! \ingroup rdr_ext_fkc_type
* \brief      VKO
* 
* \ref #READER_FUN_AGREEMENT_FULL
*/
typedef struct 
{
    struct{
	int index;	    //!<  . ,  gen_key.
	TRdrFkcPoint *Qb;   //!<  ,      .
	size_t Qb_coord_size; //!<       (#RDR_FKC_COORD_SIZE_256  #RDR_FKC_COORD_SIZE_512)
	TReaderFkcUKMPtr ukm; //!< UKM
	size_t ukm_length; //!<  UKM   (#RDR_FKC_UKM_SIZE_256  #RDR_FKC_UKM_SIZE_512)
	TReaderFkcOrderPtr mask; //!<   ,      
	size_t mask_length; //!<     (#RDR_EXCHANGE_KEY_LENGTH  #RDR_EXCHANGE_KEY_512_LENGTH)
    } to_FKC;
    struct {
	TReaderFkcOrderPtr key;	    //!<    
	size_t key_length;          //!<      (#RDR_EXCHANGE_KEY_LENGTH  #RDR_EXCHANGE_KEY_512_LENGTH)
    } to_CSP;
    DWORD key_type;		//  . 1 == AT_KEYEXCHANGE, 2 == AT_SIGNATURE. (\ref csp_interface)
} TReaderAgreeInfo;

#endif /* !_READER_H */
