/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 165177 $
 * \date $Date:: 2017-10-26 13:15:08 +0300#$
 * \author $Author: frolov $
 * \brief   .
 */

#if !defined _RNDM_RNDM_H
#define _RNDM_RNDM_H

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif /* HAVE_LIMITS_H */
#include "reader/sup_syse.h"
#include "reader/std_decl.h"

#define rndm_context_free supsys_context_free

#define TRndmContext TSupSysEContext
#define TRndmHandle TSupSysEHandle

/*! \ingroup rndm_error
 * \brief .   . 
 *
 *   :   . 
 */
/*    , ,
1)  ,     .
2)   ,      .
   (DWORD)NTE_PROVIDER_DLL_FAIL*/
//#define RNDM_ERR_NOT_FOUND -> (DWORD)NTE_PROVIDER_DLL_FAIL

/*+      . +*/
// #define CPR_ERR_RNDM_RETCODE (CPR_ERR_RETCODE|0x2000)

//#define CPR_ERR_RNDM_RETCODE (CPR_ERR_RNDM_RETCODE|0x0001)

/*+          . +*/
//#define RNDM_ERR_INVALID -> (DWORD)CPR_ERR_RNDM_RETCODE

/*! \ingroup rndm_type 
 * \brief    .
 */
#define RNDM_TYPE_WINDOWLESS 0x1

/*! \ingroup rndm_type 
 * \brief  .
 */
#define RNDM_TYPE_REMOVABLE 0x2

/*! \ingroup rndm_type 
 * \brief   
 */
#define RNDM_TYPE_CERTIFIED 0x4

/*! \ingroup rndm_type
 * \brief  .
 */
#define RNDM_TYPE_HARD 0x8

/*! \ingroup rndm_type
 * \brief  
 */
#define RNDM_TYPE_FAPSI_GAMMA 0x10

/*! \ingroup rndm_type 
 * \brief    . 
 */
#define RNDM_TYPE_ANY_MASK 0 

/*! \ingroup rndm_type 
 * \brief     
 */
#define RNDM_TYPE_ANY_VALUE 0

/* **** **** typedef **** **** */

/*! \ingroup rndm_type 
 * \brief   . 
 */
typedef unsigned long TRndmType;

/*   . */
typedef unsigned TRndmLevel;

#if defined( __cplusplus )
extern "C" {
#endif



/*! 
 * \ingroup rndm_rndm           				
 * \brief    .
 * \param context [in]  
 * \param length [in]     
 * \param info [out]  
 * \return     .
 * \retval ERROR_SUCCESS   .
 * \retval (DWORD)ERROR_INVALID_PARAMETER    
 */
 DWORD rndm( TRndmContext *context, size_t length, 
    void *info ); 

/*!
 * \ingroup rndm_rndm
 * \brief    . 
 * \param context [in]  
 * \param ptype [out]  
 * \return    
 * \retval ERROR_SUCCESS   
 * \retval (DWORD)ERROR_INVALID_PARAMETER    
 * \retval (DWORD)NTE_PROVIDER_DLL_FAIL     
 * \retval "" 
 */
 DWORD rndm_type_get( const TRndmContext *context, 
    TRndmType *type ); 

/*!
 * \ingroup rndm_rndm
 * \brief      .
 * \param list [in] ,   
 * \param context [out]  
 * \param mask [in]   
 * \param value [in] ,  
 * \retun  
 * \retval ERROR_SUCCESS   
 * \retval (DWORD)NTE_NO_MEMORY   
 */
 DWORD rndm_find_mask(TSupSysEList *list,
    TRndmContext **context, TRndmType mask, TRndmType value );

/*!
 * \ingroup rndm_rndm
 * \brief     .
 * \param ctx [in]  
 * \param level [in]  
 * \retun  
 */
 DWORD rndm_level_set( const TRndmContext *ctx,
    TRndmLevel level );

/*!
 * \ingroup rndm_rndm
 * \brief     .
 * \param ctx [in]  
 * \retun \ref TRndmLevel  . 
 */
 TRndmLevel rndm_level_get( const TRndmContext *ctx);

#if defined _WIN32
/*!
 * \ingroup rndm_rndm
 * \brief   p	arent HWND. 
 * \param context [in]  .
 * \param hwnd [in] parent HWND.
 * \retval ERROR_SUCCESS HWND    HWND  .
 * \retval " " \ret rndm_err_code
 */
 DWORD rndm_set_hwnd( const TRndmContext *ctx,
    HWND hwnd );
#endif	/* _WIN32 */

/*   . */
 DWORD rndm_register_start(TSupSysEList **list);

#ifndef NO_SUP_PROPERTIES
 DWORD rndm_wnd_configure( HWND hwnd ); 
#endif /* !NO_SUP_PROPERTIES */


#if defined( __cplusplus )
}
#endif

#endif /* !_RNDM_RNDM_H */
