/*
 * Copyright(C) 2008  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 * \brief     .
 */

#include "ric_prj.h"

/*!
 * \brief     .
 * \param reader [in]  
 * \param card [in]  
 * \param unique_num [out]   
 * \return  
 * \retval ERROR_SUCCESS  
 * \retval (DWORD)SCARD_W_UNSUPPORTED_CARD    
 * \retval " " \ref scard_error
 */
DWORD trust_unique_num( 
    TRICContext *ctx, 
    unsigned char unique_num[4] )
{
    DWORD code;
    BYTE apdu_sel[] = { 0, 0xA4, 0x00, 0x0C};
    BYTE apdu_read[] = { 0x00, 0xb0, 0x00, 0x00 };
    unsigned char data[UNI_LEN] = {0};
    size_t data_len = sizeof (data);

    code = trust_select_application(ctx);
    if( code )
	return code;

    // Select s/n file.
    code = send_apdu( ctx, apdu_sel, (unsigned char *) "\x01\x00", 2, NULL, NULL);
    if( code )
	return code;

    code = send_apdu (ctx, apdu_read, NULL, 0, data, &data_len);
    if( code )
	return code;
    memcpy(unique_num,data,4);

    //   select file,   .
    if( ctx->file ) {
	size_t length;
	trust_select_file( ctx, ctx->file, &length );
    }
    return ERROR_SUCCESS;
}
/* end of file: $Id: mag_uni.c 127051 2015-09-09 12:08:20Z pav $ */
