/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 150304 $
 * \date $Date:: 2016-12-16 17:05:23 +0300#$
 * \author $Author: sagafyin $
 * \brief    .
 */

#include "ric_prj.h"

static DWORD get_flen( const TCHAR *path, unsigned char file_id, size_t *len );

/*!
 * \brief    .
 */
DWORD oscar2_file_length( 
    unsigned char file_id, 
    size_t *length, const TCHAR* connect )
{
    DWORD err;
    TCHAR *path; 

    if( file_id == 0 || file_id > 6 )
	return (DWORD)NTE_PROVIDER_DLL_FAIL;

    path = malloc((_tcslen(OSCAR2_PATH_CFG) + 
	_tcslen(connect) + _tcslen(BASE_FILE_CFG) + 1) * sizeof(TCHAR));
    if(!path)
	return (DWORD)NTE_NO_MEMORY;
    _tcscpy( path, OSCAR2_PATH_CFG );
    _tcscat( path, connect );
    _tcscat( path, BASE_FILE_CFG );

    //    
    if( file_id != 3 )
    {
	err = get_flen( path, file_id, length );
	free( path ); 
	if( err ) return err;
	return ERROR_SUCCESS;
    }

    //   - ,   ,    
    {
	size_t cur;
	err = get_flen( path, OSCAR2_FILE_NUMBERS[1][0], &cur );
	if( err ) { free( path ); return err; }
	*length -= cur;
    }
    free(path);
    return ERROR_SUCCESS;
}

DWORD get_flen( const TCHAR *path, unsigned char file_id, size_t *len )
{
    long param = 0;
    TCHAR *tst;
    DWORD code;

    tst = malloc((_tcslen(path) + 3) * sizeof(TCHAR));
    if( !tst )
	return (DWORD)NTE_NO_MEMORY;
    _sntprintf( tst, _tcslen( path ) + 3, _TEXT( "%s%1d" ), path, file_id );
    code = support_registry_get_long( tst, &param );
    free( tst );
    if( code )
	return code;
    if( param < 0 )
	return (DWORD)NTE_PROVIDER_DLL_FAIL;
    *len = (size_t)param;
    return ERROR_SUCCESS;
}

/* end of file: $Id: osc2_flen.c 150304 2016-12-16 14:05:23Z sagafyin $ */
