/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 207272 $
 * \date $Date:: 2020-02-26 10:26:19 +0300#$
 * \author $Author: sagafyin $
 * \brief   .
 */

#include "ric_prj.h"

/*! 
 * \ingroup ric_funs
 * \brief   .
 *
 *    Windows DLL  DLL instance,  
 *     .
 * \param context [in]  .  .
 * \param info [in/out]  #TSupResourceInstance
 * \sa #TSupResourceInstance, READER_FUN_INFO_INSTANCE, 
 *  TSupSysFunction
 */
DWORD ric_info_instance(
    TSupSysContext *context, 
    TSupSysInfo *info )
{
    TSupResourceInstance *inf = (TSupResourceInstance*)info;

    SUPSYS_PRE_INFO(info, TSupResourceInstance);
    UNUSED(context);
    *inf = RIC_RESOURCE;
    return ERROR_SUCCESS;
}

#define CARD_INFO_NAME_FUN(nickname,card_name) \
DWORD nickname##_info_name(TSupSysContext *context, TSupSysInfo *info)\
{\
    TSupSysInfoText *inf = (TSupSysInfoText*)info;\
    UNUSED(context);\
    if (!inf->text) {\
	inf->length = _tcslen(card_name);\
	return 0;\
    }\
    if (inf->length < _tcslen(card_name)) {\
	inf->length = _tcslen(card_name);\
	return (DWORD)ERROR_MORE_DATA;\
    }\
    _tcscpy(inf->text, card_name);\
    inf->length = _tcslen(card_name);\
\
    return ERROR_SUCCESS;\
}

CARD_INFO_NAME_FUN(ric, _TEXT("RIC"))
CARD_INFO_NAME_FUN(oscar, _TEXT("Oscar"))
CARD_INFO_NAME_FUN(oscar2, _TEXT("Oscar v.2"))
CARD_INFO_NAME_FUN(trust, _TEXT("Foros (Magistra)"))
CARD_INFO_NAME_FUN(trustd, _TEXT("Foros Debug"))
CARD_INFO_NAME_FUN(trusts, _TEXT("Foros SBRF/BGS"))

/*   */
DWORD ric_info_nickname(
    TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoNickname *inf = (TSupSysInfoNickname*)info;
    UNUSED(context);
    _tcscpy(inf->nickname, _TEXT("RIC"));
    return ERROR_SUCCESS;
}

DWORD oscar_info_nickname(
    TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoNickname *inf = (TSupSysInfoNickname*)info;
    UNUSED(context);
    _tcscpy(inf->nickname, _TEXT("OSCAR"));
    return ERROR_SUCCESS;
}

DWORD oscar2_info_nickname(
    TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoNickname *inf = (TSupSysInfoNickname*)info;
    UNUSED(context);
    _tcscpy(inf->nickname, _TEXT("OSCAR2"));
    return ERROR_SUCCESS;
}

DWORD trustd_info_nickname(
    TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoNickname *inf = (TSupSysInfoNickname*)info;
    UNUSED(context);
    _tcscpy(inf->nickname, _TEXT("TRUSTD"));
    return ERROR_SUCCESS;
}

DWORD trust_info_nickname(
    TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoNickname *inf = (TSupSysInfoNickname*)info;
    UNUSED(context);
    _tcscpy(inf->nickname, _TEXT("TRUST"));
    return ERROR_SUCCESS;
}


DWORD trusts_info_nickname(
    TSupSysContext *context, TSupSysInfo *info)
{
    TSupSysInfoNickname *inf = (TSupSysInfoNickname*)info;
    UNUSED(context);
    _tcscpy(inf->nickname, _TEXT("TRUSTS"));
    return ERROR_SUCCESS;
}
