/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 127051 $
 * \date $Date:: 2015-09-09 15:08:20 +0300#$
 * \author $Author: pav $
 * \brief     .
 */

#include "ric_prj.h"

/*!
 * \brief     .
 * \param reader [in]  
 * \param card [in]  
 * \param unique_num [out]   
 * \return  
 * \retval ERROR_SUCCESS  
 * \retval (DWORD)SCARD_W_UNSUPPORTED_CARD    
 * \retval " " \ref scard_error
 */
DWORD ric_unique_num( 
    TRICContext *ctx, 
    unsigned char unique_num[UNI_LEN] )
{
    BYTE apdu[] = { 0, 0xCA, 01, 00 };
    DWORD code;
    size_t out_len = UNI_LEN;

    code = send_apdu( ctx, apdu, NULL, 0, unique_num, &out_len );
    if( code )
	return code;
    if( out_len != 4 )
	return (DWORD)SCARD_W_UNSUPPORTED_CARD;
    return ERROR_SUCCESS;
}
/* end of file: $Id: ricuni.c 127051 2015-09-09 12:08:20Z pav $ */
