#ifndef CPPCADES_CP_PUBLICKEY_OBJECT_H_
#define CPPCADES_CP_PUBLICKEY_OBJECT_H_

#include "cppcades.h"
#include "CPPCadesCPOID.h"
#include "CPPCadesCPEncodedData.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPPublicKeyObject
{
public:
    CPPCadesCPPublicKeyObject(void);
    ~CPPCadesCPPublicKeyObject(void);

    HRESULT get_Algorithm(NS_SHARED_PTR::shared_ptr<CPPCadesCPOIDObject>& pVal);
    HRESULT get_Length(DWORD* pVal);
    HRESULT get_EncodedKey(NS_SHARED_PTR::shared_ptr<CPPCadesCPEncodedDataObject>& pVal);
    HRESULT get_EncodedParameters(NS_SHARED_PTR::shared_ptr<CPPCadesCPEncodedDataObject>& pVal);

    //internal use
    HRESULT put_Algorithm(CAtlStringA val);
    HRESULT put_EncodedKey(const CBlob& val);
    HRESULT put_EncodedParameters(const CBlob& val);
    HRESULT put_KeyLength(DWORD val);

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPPublicKeyObject);

    DWORD m_length;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPEncodedDataObject> m_encKey;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPEncodedDataObject> m_encParams;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPOIDObject> m_alg;
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_PUBLICKEY_OBJECT_H_

