#ifndef CPPCADES_CARDHOLDER_DATA_H_
#define CPPCADES_CARDHOLDER_DATA_H_
#include "cppcades.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCardholderDataObject
{
public:
    CPPCadesCardholderDataObject();
    ~CPPCadesCardholderDataObject();

    HRESULT get_SocialAccountNumber(CAtlString& pVal);
    HRESULT get_OMSNumber(CAtlString& pVal);
    HRESULT get_Name(CAtlString& pVal);
    HRESULT get_FirstName(CAtlString& pVal);
    HRESULT get_LastName(CAtlString& pVal);
    HRESULT get_SecondName(CAtlString& pVal);
    HRESULT get_CardIssuerAddress(CAtlString& pVal);
    HRESULT get_DateOfBirth(CAtlString& pVal);
    HRESULT get_PlaceOfBirth(CAtlString& pVal);
    HRESULT get_SexString(CAtlString& pVal);
    HRESULT get_Sex(CADESCOM_HUMAN_SEXES* pVal);

    // internal use
    HRESULT InitFromCryptProv(ATL2::CCryptProvEx& cryptProv);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCardholderDataObject);

    ATL2::CCryptProvEx m_cryptProv;

    CAtlString m_SocialAccountNumber;
    CAtlString m_OMSNumber;
    CAtlString m_Name;
    CAtlString m_FirstName;
    CAtlString m_LastName;
    CAtlString m_SecondName;
    CAtlString m_CardIssuerAddress;
    CAtlString m_DateOfBirth;
    CAtlString m_PlaceOfBirth;
    CAtlString m_SexString;
    CADESCOM_HUMAN_SEXES m_Sex;

};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif //CPPCADES_CARDHOLDER_DATA_H_
