#ifndef CPPCADES_RAW_SIGNATURE_OBJECT_H_
#define CPPCADES_RAW_SIGNATURE_OBJECT_H_

#include "cppcades.h"
#include "cplib/Blob.h"
#include "CPPCadesCPHashedData.h"
#include "CPPCadesCPCertificate.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesRawSignatureObject
{
public:
    CPPCadesRawSignatureObject(void);
    ~CPPCadesRawSignatureObject(void);

    HRESULT VerifyHash(
        const NS_SHARED_PTR::shared_ptr<CPPCadesCPHashedDataObject>& pHashedData,
        const CAtlString& signatureValue,
        const NS_SHARED_PTR::shared_ptr<CPPCadesCPCertificateObject>& pCertificate); 
    HRESULT SignHash(
        const NS_SHARED_PTR::shared_ptr<CPPCadesCPHashedDataObject>& pHashedData,
        const NS_SHARED_PTR::shared_ptr<CPPCadesCPCertificateObject>& pCertificate,
        CAtlString& signature);

    //internal use
private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesRawSignatureObject);
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_RAW_SIGNATURE_OBJECT_H_

