#ifndef CPP_ENROLL_CONTAINER_OBJECT_H_
#define CPP_ENROLL_CONTAINER_OBJECT_H_

#include "cppcades.h"
#include <atlcrypt2.h>
#include "CPPEnrollContainerKey.h"
#include "CPPEnrollCollections.h"

using namespace ATL;
using namespace CryptoPro::PKI::CAdES;

namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollContainerKeys;

class CPPEnrollContainer
{
public:
    CPPEnrollContainer(void);
    ~CPPEnrollContainer(void);
    HRESULT get_UniqueName(CAtlString& Val);
    HRESULT get_FQCN(CAtlString& Val);
    HRESULT get_Name(CAtlString& Val);
    HRESULT get_Media(CAtlString& Val);
    HRESULT get_Reader(CAtlString& Val);
    HRESULT get_Keys(NS_SHARED_PTR::shared_ptr<CPPEnrollContainerKeys>& pVal);

    HRESULT set_Silent(bool Val);

    HRESULT Delete();

    //internal use
    HRESULT Initialize(DWORD dwProvType, CAtlString sContainerName);
    HRESULT InitializeInternal();
    void CheckInitialized();

private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollContainer);
    CCryptProv m_hProv;
    CAtlString m_sContainerName;
    DWORD m_dwProvType;
    bool m_bSilent;
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_CONTAINER_OBJECT_H_
