#ifndef CPP_ENROLL_OBJECTID_OBJECT_H_
#define CPP_ENROLL_OBJECTID_OBJECT_H_

#include "cppcades.h"
#include "CPPEnrollEnumerations.h"
#include <atlcrypt2.h>

using namespace ATL;
namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollObjectId
{
public:
    CPPEnrollObjectId(void);
    CPPEnrollObjectId(LPCSTR oid);
    CPPEnrollObjectId(ALG_ID algId);
    ~CPPEnrollObjectId(void);
    HRESULT InitializeFromAlgorithmName(
        ObjectIdGroupId GroupId,
        ObjectIdPublicKeyFlags KeyFlags,
        AlgorithmFlags AlgFlags,
        const CAtlStringW& strAlgorithmName);
    HRESULT InitializeFromName(CERTENROLL_OBJECTID Name);
    HRESULT InitializeFromValue(const CAtlStringA& newVal);

    HRESULT get_FriendlyName(CAtlString& pVal);
    HRESULT get_Value(CAtlStringA& pVal);

    // internal use
    LPCSTR get_pszOID();

private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollObjectId);
    HRESULT CheckInitialized();
    PCCRYPT_OID_INFO m_pInfo;
    CAtlStringA m_oid;
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_OBJECTID_OBJECT_H_
