#ifndef CPPCADES_CP_VERSION_OBJECT_H_
#define CPPCADES_CP_VERSION_OBJECT_H_

#include "cppcades.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPVersionObject
{
public:
    CPPVersionObject(void);
    ~CPPVersionObject(void);

    HRESULT get_MajorVersion(unsigned int* pVal);
    HRESULT get_MinorVersion(unsigned int* pVal);
    HRESULT get_BuildVersion(unsigned int* pVal);
    HRESULT toString(CAtlString& Val);

    //internal
    HRESULT Initialize(DWORD dwMajorVersion, DWORD dwMinorVersion, 
        DWORD dwBuildVersion, bool bIsDebug);

private:
    DISALLOW_COPY_AND_ASSIGN(CPPVersionObject);
    CAtlStringA m_strVersion;
    DWORD m_dwMajorVersion;
    DWORD m_dwMinorVersion;
    DWORD m_dwBuildVersion;
    bool m_bDebug;
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_VERSION_OBJECT_H_
