<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 		xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		version='1.0'>



<xsl:template match="PKIMessage" name="PKIMessage">
<!-- Otkazala generacia CertificationRequest v Der2Xer. Pridetsya tak - Cherez PKIMessage-->

<xsl:choose>
 <xsl:when test="(count(//p10cr) &gt; 0 or count(//ir) &gt; 0 or count(//kur) &gt; 0 or count(//ccr) &gt; 0) and $printRequestAsCMP != 1">
      <xsl:call-template name="CertificationRequest">
	<xsl:with-param name = "PKI">true</xsl:with-param>
      </xsl:call-template>
 </xsl:when>
 <xsl:otherwise>

    <!-- Header  -->
  <fo:static-content flow-name="xsl-region-before">
    <fo:block>
    </fo:block>
  </fo:static-content>

      <!-- Footer -->

  <fo:static-content flow-name="xsl-region-after">
    <fo:block text-align="center" font-size="10pt" 	
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_paper</xsl:with-param> </xsl:call-template>			<!--  -->
      <fo:page-number/>
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_of</xsl:with-param> </xsl:call-template>
      <fo:page-number-citation ref-id="end of certificate"/>
    </fo:block>
  </fo:static-content>

	<!--    -->
  <fo:flow flow-name="xsl-region-body">
    <fo:block text-align="center"
	      font-family="Arial" font-size="14pt"      
	      space-before="32pt"
	      space-after="16pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIMessage_title</xsl:with-param> </xsl:call-template>         <!--  -->
    </fo:block>

            <!--     -->	  
    <xsl:call-template name="uc_title"/>

             <!--      .  -->
    <fo:block font-family="Times" font-size="10pt"
	      >

		<!--   CMP -->
    <xsl:for-each select="./header">  
	<xsl:call-template name="PKIHeader"/>
    </xsl:for-each>
    </fo:block>

		<!--   CMP -->
    <xsl:for-each select="./body">  
	<xsl:call-template name="PKIBody"/>
    </xsl:for-each>




	<!--   CMP  :  -->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="4pt"
	      space-after="2pt"
	      space-before.precedence="0"                           
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIMessage_sign</xsl:with-param> </xsl:call-template>                    <!--  -->
    </fo:block>

    <xsl:choose>
        <xsl:when test="count(//protection) &gt; 0">


		<!-- :-->
	    
            <xsl:for-each select="./header/protectionAlg">  
		<xsl:call-template name="SignatureAlgorithm"/>
	    </xsl:for-each>

	    <xsl:for-each select="./protection">  
		<xsl:call-template name="Signature"/>
	    </xsl:for-each>

	</xsl:when>

	<!--   -->
        <xsl:otherwise>
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIMessage_protection_none</xsl:with-param> </xsl:call-template>                       <!--  -->
	</xsl:otherwise>
    </xsl:choose>
    <fo:block id="end of certificate">
    </fo:block>
  </fo:flow>
 </xsl:otherwise>
 </xsl:choose>
</xsl:template>




<xsl:template match="PKIHeader" name="PKIHeader">
    <fo:block font-family="Times" font-size="10pt"			
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"				
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIHeader_title</xsl:with-param> </xsl:call-template>				<!--  -->
    </fo:block>


	<!--   :-->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"                                         
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIHeader_sender</xsl:with-param> </xsl:call-template>                             <!--  -->
    </fo:block>


	<!--   -->

    <fo:block font-family="Times" font-size="10pt"
	      >
      <xsl:for-each select="./sender">  
	<xsl:call-template name="GeneralName"/>
      </xsl:for-each>
    </fo:block>

	<!--    :-->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"                                         
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIHeader_senderKID</xsl:with-param> </xsl:call-template>                     <!--  -->
    </fo:block>

	<!--      -->
    <fo:block font-family="Times" font-size="10pt"			
	      >
      <xsl:call-template name="split">
	<xsl:with-param name="val">
	  <xsl:value-of select="senderKID"/>				<!--   -->
	</xsl:with-param>
      </xsl:call-template>
    </fo:block>


	<!--   :-->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"                                         
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIHeader_recipient</xsl:with-param> </xsl:call-template>                              <!--  -->
    </fo:block>

    <fo:block font-family="Times" font-size="10pt"
      >	
      <xsl:for-each select="./recipient">  
	<xsl:call-template name="GeneralName"/>
      </xsl:for-each>
    </fo:block>                                                        


	<!--    : -->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"                                         
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIHeader_messageTime</xsl:with-param> </xsl:call-template>                         <!--  -->
    </fo:block>


	<!--     -->
    <fo:block font-family="Times" font-size="10pt"
	      >
      <xsl:for-each select="./messageTime">  
	<xsl:call-template name="GeneralizedTime"/>
      </xsl:for-each>
     </fo:block>

	<!--   : -->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="10pt"
	      space-after="5pt"                                         
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIHeader_transactionID</xsl:with-param> </xsl:call-template>				<!--  -->
    </fo:block>


	<!--     -->
    <fo:block font-family="Times" font-size="10pt"                      
	      >
      <xsl:value-of select="transactionID"/>
    </fo:block>

    <xsl:if test="count(//generalInfo/InfoTypeAndValue[infoType = $OIDAuditLogEntry]) &gt; 0">
      <xsl:for-each select="./generalInfo/InfoTypeAndValue/infoValue/PKIAudit">  
	<xsl:call-template name="PKIAudit"/>
      </xsl:for-each>
    </xsl:if>
    
		<!--  -->

		<!--  -->
		<xsl:if test="count(//generalInfo/InfoTypeAndValue[infoType = $OIDPKIEntityOrganization]) &gt; 0">
			<xsl:for-each select="./generalInfo/InfoTypeAndValue/infoValue/PKIEntityOrganization">  
				<xsl:call-template name="PKIEntityOrganization"/>
			</xsl:for-each>
		</xsl:if>

		<!--  -->
		<xsl:if test="count(//generalInfo/InfoTypeAndValue[infoType = $OIDPKIEntityLicense]) &gt; 0">
			<xsl:for-each select="./generalInfo/InfoTypeAndValue/infoValue/PKIEntityLicense">  
				<xsl:call-template name="PKIEntityLicense"/>
			</xsl:for-each>
		</xsl:if>

		<!-- OID (Policy) -->
		<xsl:if test="count(//generalInfo/InfoTypeAndValue[infoType = $OIDPKIEntityPolicy]) &gt; 0">
			<xsl:for-each select="./generalInfo/InfoTypeAndValue/infoValue/PKIEntityOID">
				<xsl:call-template name="PKIEntityOID"/>
			</xsl:for-each>
		</xsl:if>

		<!-- WorkPlace (Official) -->
		<xsl:if test="count(//generalInfo/InfoTypeAndValue[infoType = $OIDPKIEntityOfficial]) &gt; 0">
			<xsl:for-each select="./generalInfo/InfoTypeAndValue/infoValue/PKIEntityWorkPlace">  
				<xsl:call-template name="PKIEntityWorkPlace"/>
			</xsl:for-each>
		</xsl:if>

		<!-- Certificate -->
		<xsl:if test="count(//generalInfo/InfoTypeAndValue[infoType = $OIDPKIEntityCertificate]) &gt; 0">
			<xsl:for-each select="./generalInfo/InfoTypeAndValue/infoValue/PKIEntityCertificate">  
				<xsl:call-template name="PKIEntityCertificate"/>
			</xsl:for-each>
		</xsl:if>

		<!--  -->
    
    
</xsl:template>




<xsl:template match="PKIAudit" name="PKIAudit">

	<!--     : -->
    <fo:block font-family="Times" font-size="10pt"			
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudit_header</xsl:with-param> </xsl:call-template>				<!--  -->
    </fo:block>

       <!--      -->
    <fo:block font-family="Times" font-size="10pt"                      
	      border-style="solid"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudit_session</xsl:with-param> </xsl:call-template>				<!--  -->
      <xsl:value-of select="session"/>                                  <!--  -->

	<!--     :   -->
    <fo:block font-family="Times" font-size="10pt"                      
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudit_counter</xsl:with-param> </xsl:call-template>                               <!--  -->
      <xsl:value-of select="counter"/>                                  <!--  -->
    </fo:block>
	<!--  :  -->
    <fo:block font-family="Times" font-size="10pt"			
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudit_type</xsl:with-param> </xsl:call-template>				<!--  -->

	<!--  -->
      <xsl:choose>
		<!--   -->
	      <xsl:when test="count(type/processCert) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_certmake</xsl:with-param> </xsl:call-template>
	      </xsl:when>

		<!--  COC -->
	      <xsl:when test="count(type/processCRL) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_sosmake</xsl:with-param> </xsl:call-template>
	      </xsl:when>

		<!--     -->
	      <xsl:when test="count(type/rejectCert) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_performdeny</xsl:with-param> </xsl:call-template>
	      </xsl:when>

		<!--   -->
	      <xsl:when test="count(type/revokeCert) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_certcallback</xsl:with-param> </xsl:call-template>
	      </xsl:when>

		<!--    -->
	      <xsl:when test="count(type/cessationCert) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_certstop</xsl:with-param> </xsl:call-template>
	      </xsl:when>

		<!--    -->
	      <xsl:when test="count(type/resumeCert) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_certresume</xsl:with-param> </xsl:call-template>
	      </xsl:when>

		<!--   -->
	      <xsl:when test="count(type/archiveCert) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_certarch</xsl:with-param> </xsl:call-template>
	      </xsl:when>

		<!--     -->
	      <xsl:when test="count(type/deleteCert) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_certunarch</xsl:with-param> </xsl:call-template>
	      </xsl:when>

		<!--   () -->
	      <xsl:when test="count(type/startSession) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_shiftbegin</xsl:with-param> </xsl:call-template>
	      </xsl:when>

		<!--     -->
	      <xsl:when test="count(type/affiliation) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_ulpkeychng</xsl:with-param> </xsl:call-template>
	      </xsl:when>

		<!--     -->
	      <xsl:when test="count(type/newAuthorizedPerson) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_newulkeyform</xsl:with-param> </xsl:call-template>
	      </xsl:when>
		<!--      -->
	      <xsl:when test="count(type/authorizedPersonStart) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_ulkeyenable</xsl:with-param> </xsl:call-template>
	      </xsl:when>
		<!--  .    -->
	      <xsl:when test="count(type/deleteKey) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_shiftenduldel</xsl:with-param> </xsl:call-template>
	      </xsl:when>
		<!--   () -->
	      <xsl:when test="count(type/stopSession) &gt; 0">
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_shiftend</xsl:with-param> </xsl:call-template>
	      </xsl:when>
		<!--    -->
	      <xsl:otherwise>
		      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIAudi_type_uncntype</xsl:with-param> </xsl:call-template>
	      </xsl:otherwise>
      </xsl:choose>
    </fo:block>
    </fo:block>
</xsl:template>



<!--     PKI  -->

<xsl:template match="PKIStatusInfo" name="PKIStatusInfo">

  <fo:block font-family="Times" font-size="10pt"                      
	      >                                                       <!--  -->


	<!--   Status -->

      <xsl:for-each select="./status">  
	<xsl:call-template name="PKIStatus"/>
      </xsl:for-each>


	<!--   statusString -->

      <fo:block font-family="Times" font-size="10pt"                      
	 >                                   
      	 <xsl:value-of select="statusString"/>
	 </fo:block>     


	<!--   failInfo -->
 	
      <xsl:for-each select="./failInfo">  
	<xsl:call-template name="PKIFailureInfo"/>
      </xsl:for-each>

  </fo:block>
</xsl:template>





<!--    PKI  -->

<xsl:template match="PKIStatus" name="PKIStatus">
    <fo:block font-family="Arial" font-size="14pt"                              
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      >
	<xsl:choose>

			<!--     -->
			<!--      -->			
		<xsl:when test="count(waiting) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIStatus_waiting</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!--     -->			
		<xsl:when test="count(rejection) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIStatus_rejection</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!--     -->			
		<xsl:when test="count(granted) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIStatus_granted</xsl:with-param> </xsl:call-template>
		</xsl:when>


			<!--  grantedWithMods -->			
		<xsl:when test="count(grantedWithMods) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIStatus_grantedWithMods</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!--  revocationWarning -->			
		<xsl:when test="count(revocationWarning) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIStatus_revocationWarning</xsl:with-param> </xsl:call-template>
		</xsl:when>

			<!--  revocationNotification -->			
		<xsl:when test="count(revocationNotification) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIStatus_revocationNotification</xsl:with-param> </xsl:call-template>
		</xsl:when>

	</xsl:choose>
    </fo:block>
</xsl:template>



<xsl:template match="PKIFailureInfo" name="PKIFailureInfo">
    <fo:block font-family="Arial" font-size="10pt"                              
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_header</xsl:with-param> </xsl:call-template>
        </fo:block>

	<fo:block font-family="Times" font-size="10pt"                
		border-style="solid"
		>

		<xsl:value-of select="."/>
			<!--     -->
			<!-- badAlg -->			
		<xsl:if test='substring(.,1,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_badAlg</xsl:with-param> </xsl:call-template>
		</xsl:if>

			<!-- badMessageCheck -->			
		<xsl:if test='substring(.,2,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_badMessageCheck</xsl:with-param> </xsl:call-template>              <!--  -->

		</xsl:if>

			<!-- badRequest -->			
		<xsl:if test='substring(.,3,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_badRequest</xsl:with-param> </xsl:call-template>              <!--  -->

		</xsl:if>

			<!-- badTime -->			
		<xsl:if test='substring(.,4,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_badTime</xsl:with-param> </xsl:call-template>              <!--  -->

		</xsl:if>

			<!-- badCertId -->			
		<xsl:if test='substring(.,5,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_badCertId</xsl:with-param> </xsl:call-template>              <!--  -->

		</xsl:if>

			<!-- badDataFormat -->	
		<xsl:if test='substring(.,6,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_badDataFormat</xsl:with-param> </xsl:call-template>           <!--  -->
		</xsl:if>

			<!-- wrongAuthority -->	
		<xsl:if test='substring(.,7,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_wrongAuthority</xsl:with-param> </xsl:call-template>           <!--  -->
		</xsl:if>

			<!-- incorrectData -->	
		<xsl:if test='substring(.,8,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_incorrectData</xsl:with-param> </xsl:call-template>           <!--  -->
		</xsl:if>

			<!-- missingTimeStamp -->	
		<xsl:if test='substring(.,9,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_missingTimeStamp</xsl:with-param> </xsl:call-template>           <!--  -->
		</xsl:if>

			<!-- badPOP -->	
		<xsl:if test='substring(.,10,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_badPOP</xsl:with-param> </xsl:call-template>           <!--  -->
		</xsl:if>

			<!-- timeNotAvailable -->	
		<xsl:if test='substring(.,15,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_timeNotAvailable</xsl:with-param> </xsl:call-template>        <!--  -->
		</xsl:if>

			<!-- unacceptedPolicy -->	
		<xsl:if test='substring(.,16,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_unacceptedPolicy</xsl:with-param> </xsl:call-template>        <!--  -->
		</xsl:if>

			<!-- unacceptedExtension -->	
		<xsl:if test='substring(.,17,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_unacceptedExtension</xsl:with-param> </xsl:call-template>     <!--  -->
		</xsl:if>

			<!-- addInfoNotAvailable -->	
		<xsl:if test='substring(.,18,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_addInfoNotAvailable</xsl:with-param> </xsl:call-template>     <!--  -->
		</xsl:if>

			<!-- systemFailure -->	
		<xsl:if test='substring(.,26,1) = 1'>
			<xsl:text> </xsl:text>
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIFailureInfo_systemFailure</xsl:with-param> </xsl:call-template>           <!--  -->
		</xsl:if>
        </fo:block>
</xsl:template>









<!--       PKI  -->

<xsl:template match="PKIBody" name="PKIBody">
    <fo:block text-align="center"
	 font-family="Arial" font-size="12pt"		
	 space-before="0pt"
	 space-after="16pt"
	 space-before.precedence="0"
	 space-after.precedence="3"
	 keep-with-next="always"
	 >

	 <xsl:choose>
	     <xsl:when test="count(ir) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_ir</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="ir">
			<xsl:call-template name="CertReqMessages"/>
		</xsl:for-each>
	     </xsl:when>



	     <xsl:when test="count(ip) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_ip</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="ip">
			<xsl:call-template name="CertRepMessage"/>
		</xsl:for-each>
	     </xsl:when>


		<!--    -->
	     <xsl:when test="count(cr) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_cr</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="cr">
			<xsl:call-template name="CertReqMessages"/>
		</xsl:for-each>
	     </xsl:when>

		<!--      -->
	     <xsl:when test="count(cp) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_cp</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="cp">
			<xsl:call-template name="CertRepMessage"/>
		</xsl:for-each>
	     </xsl:when>

		<!--     -->
	     <xsl:when test="count(kur) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_kur</xsl:with-param> </xsl:call-template>
        	<xsl:for-each select="kur">
			<xsl:call-template name="CertReqMessages"/>
		</xsl:for-each>
	     </xsl:when>

		<!--       -->
	     <xsl:when test="count(kup) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_kup</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="kup">
			<xsl:call-template name="CertRepMessage"/>
		</xsl:for-each>
	     </xsl:when>

		<!--    PKCS10 -->
	     <xsl:when test="count(p10cr) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_p10cr</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="p10cr">
			<xsl:call-template name="CertificationRequest"/>
		</xsl:for-each>
	     </xsl:when>

		<!--      -->
	     <xsl:when test="count(krr) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_krr</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="krr">
			<xsl:call-template name="CertReqMessages"/>
		</xsl:for-each>
	     </xsl:when>
		
		<!--       -->
	     <xsl:when test="count(krp) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_krp</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="krp">
			<xsl:call-template name="KeyRecRepContent"/>
		</xsl:for-each>
	     </xsl:when>

		<!--   - -->
	     <xsl:when test="count(ccr) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_ccr</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="ccr">
			<xsl:call-template name="CertReqMessages"/>
		</xsl:for-each>
	     </xsl:when>

		<!--      - -->
	     <xsl:when test="count(ccp) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_ccp</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="ccp">
			<xsl:call-template name="CertRepMessage"/>
		</xsl:for-each>
	     </xsl:when>

		<!--   /   -->
	     <xsl:when test="count(rr) &gt; 0">

	                  <!--    -->
		    <fo:block text-align="center"
			      font-family="Arial" font-size="12pt"              
			      space-before="0pt"
			      space-after	="16pt"
			      space-before.precedence="0"
			      space-after.precedence="3"
			      keep-with-next="always"
			      >
		      <xsl:choose>
			  <xsl:when test="count(//RevDetails[revocationReason = $revReasonHold]) &gt; 0">
				<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_rr_stop</xsl:with-param> </xsl:call-template>       <!--  -->
			  </xsl:when>
			  <xsl:otherwise>
				<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_rr_drop</xsl:with-param> </xsl:call-template>       <!--  -->
			  </xsl:otherwise>
		      </xsl:choose>
		    </fo:block>



		  <fo:block font-family="Times" font-size="10pt"			
			    text-align="left"
			    space-before="4pt"
			    space-after="2pt"
			    space-before.precedence="0"
			    space-after.precedence="3"
			    keep-with-next="always"
			    >

			    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_subject</xsl:with-param> </xsl:call-template>		<!--  --> 	
			  </fo:block>

				<!--   -->

			<fo:block font-family="Courier New" font-size="10pt"
			    text-align="left"
			    border-style="solid"
			    padding="3pt"
			    >
			    <xsl:for-each select="//RevDetails/certDetails/subject">  
				<xsl:call-template name="Name"/>
			    </xsl:for-each>
			</fo:block>		


				<!--   : -->
		    <xsl:for-each select="//RevDetails/certDetails/serialNumber">
		    <fo:block font-family="Times" font-size="10pt"                        
			    text-align="left"
			    space-before="4pt"
			    space-after="2pt"
			    space-before.precedence="0"
			    space-after.precedence="3"
			    keep-with-next="always"
			    >
			    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_rr_serialNumber</xsl:with-param> </xsl:call-template>					<!--  -->
		    </fo:block>


			    <!--    -->	
		    <fo:block font-family="Courier New" font-size="10pt"                      
			    text-align="left"
			    border-style="solid"
			    padding="3pt"
			    >
		    	   <xsl:value-of select="."/>
		    </fo:block>
		    </xsl:for-each>

		    <xsl:if test="count(//RevDetails[revocationReason = $revReasonHold]) &gt; 0 and count(//header/freeText) &gt; 0">
		        <fo:block font-family="Times" font-size="10pt"
			      text-align="left"
			      space-before="4pt"
			      space-after="2pt"
			      space-before.precedence="0"
			      space-after.precedence="3"
			      keep-with-next="always"
			      >
			    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_rr_stop_till</xsl:with-param> </xsl:call-template>          <!--  -->
		            <xsl:value-of select="//header/freeText"/>
			</fo:block>
		    </xsl:if>
	
	     </xsl:when>

		<!--   /  -->
	     <xsl:when test="count(rp) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_rp</xsl:with-param> </xsl:call-template>

		<xsl:for-each select="rp">
			<xsl:call-template name="RevRepContent"/>
		</xsl:for-each>
	     </xsl:when>

		<!--       -->
	     <xsl:when test="count(ckuann) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_ckuann</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="ckuann">
			<xsl:call-template name="CAKeyUpdAnnContent"/>
		</xsl:for-each>
	     </xsl:when>

		<!--        -->
	     <xsl:when test="count(crlann) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_crlann</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="crlann">
			<xsl:call-template name="CRLAnnContent"/>
		</xsl:for-each>
	     </xsl:when>

		<!--     -->
	     <xsl:when test="count(cann) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_cann</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="cann">
			<xsl:call-template name="CertAnnContent"/>
		</xsl:for-each>
	     </xsl:when>

		<!--     -->
	     <xsl:when test="count(rann) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_rann</xsl:with-param> </xsl:call-template>
		<xsl:for-each select="rann">
			<xsl:call-template name="RevAnnContent"/>
		</xsl:for-each>
	     </xsl:when>

		<!--      /    /   -->
	     <xsl:when test="count(genm) &gt; 0">

	        <xsl:choose>
		
			<!--      -->
		  <xsl:when test="count(//genm/InfoTypeAndValue[infoType = $genmOIDresumeCertReq]) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_genm_resume</xsl:with-param> </xsl:call-template>     <!--  -->
		  </xsl:when>

			<!--      -->
		  <xsl:when test="count(//genm/InfoTypeAndValue[infoType = $genmOIDchangeNameReq]) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_genm_edit</xsl:with-param> </xsl:call-template>       <!--  -->
		  </xsl:when>
		  <xsl:otherwise>
			<!--    -->
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_genm_common</xsl:with-param> </xsl:call-template>          <!--  -->
		  </xsl:otherwise>
	        </xsl:choose>


	      <xsl:value-of select="InfoTypeAndValue/infoValue"/>

		<xsl:for-each select="genm">
			<xsl:call-template name="GenMsgContent"/>
		</xsl:for-each>
	     </xsl:when>

		<!--     /     -->
	     <xsl:when test="count(genp) &gt; 0">
	      <xsl:choose>

			<!--      -->
		  <xsl:when test="count(//genp/InfoTypeAndValue[infoType = $genmOIDresumeCertRep]) &gt; 0">
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_genp</xsl:with-param> </xsl:call-template>      <!--  -->
		  </xsl:when>
		  <xsl:otherwise>
			<!--      -->
			<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_genp_common</xsl:with-param> </xsl:call-template>
		  </xsl:otherwise>
	      </xsl:choose>
	      <xsl:value-of select="InfoTypeAndValue/infoValue"/>

		<xsl:for-each select="genp">
			<xsl:call-template name="GenRepContent"/>
		</xsl:for-each>
	     </xsl:when>

		<!--       -->
	     <xsl:when test="count(conf) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_conf</xsl:with-param> </xsl:call-template>
	     </xsl:when>

		<!--   //  -->
	     <xsl:when test="count(error) &gt; 0">
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_error</xsl:with-param> </xsl:call-template>

		<xsl:for-each select="error">
			<xsl:call-template name="ErrorMsgContent"/>
		</xsl:for-each>

	     </xsl:when>

		<!--    : :  -->
	     <xsl:when test="count(pop) &gt; 0">
		  <fo:block font-family="Times" font-size="10pt"                
		    space-before="4pt"
		    space-after="2pt"
		    space-before.precedence="0"
		    space-after.precedence="3"
		    keep-with-next="always"
		    >
	            <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SK_own_prove</xsl:with-param> </xsl:call-template>			<!--  -->
		  </fo:block>

		  <fo:block font-family="Courier New" font-size="10pt"              
			border-style="solid"
			padding="3pt"
			>
		 	<xsl:choose>
		  	  <!--   :  -->
		          <xsl:when test="count(raVerified) &gt; 0">
				<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_checked_by</xsl:with-param> </xsl:call-template>			<!--  -->
	   	          </xsl:when>
		          <xsl:otherwise>
		               <xsl:apply-templates/>    				<!--     -->
		          </xsl:otherwise>
			</xsl:choose>

		  </fo:block>

		<xsl:for-each select="pop">
			<xsl:call-template name="ProofOfPossession"/>
		</xsl:for-each>
	     </xsl:when>

               	  <!--     -->
 	     <xsl:otherwise>
	  	  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PKIBody_unknown</xsl:with-param> </xsl:call-template>
	     </xsl:otherwise>
	
         </xsl:choose>

    </fo:block>
</xsl:template>
















<xsl:template name="GenRepContent" match="GenRepContent">
	<xsl:for-each select="./*">
		<xsl:call-template name="InfoTypeAndValue"/>
	</xsl:for-each>
</xsl:template>

<xsl:template name="InfoTypeAndValue" match="InfoTypeAndValue">
	<xsl:for-each select="./infoType">
		<xsl:call-template name="printOID"/>
	</xsl:for-each>

	<xsl:for-each select="./infoValue">
		<xsl:apply-templates/>
	</xsl:for-each>

</xsl:template>



<xsl:template name="CertReqMessages" match="CertReqMessages">
	<xsl:for-each select="./*">
		<xsl:call-template name="CertReqMsg"/>
	</xsl:for-each>
</xsl:template>

<xsl:template name="CertReqMsg" match="CertReqMsg">

    <fo:block text-align="left" font-size="10pt" 	
	      >

	<xsl:for-each select="certReq">
		<xsl:call-template name="CertRequest"/>
	</xsl:for-each>

	<xsl:for-each select="pop">
		<xsl:call-template name="ProofOfPossession"/>
	</xsl:for-each>

	<xsl:for-each select="regInfo/*">
		<xsl:call-template name="AttributeTypeAndValue"/>
	</xsl:for-each>
    </fo:block>

</xsl:template>

<xsl:template name="CertReqId" match="CertReqId">
	  <fo:block font-family="Times" font-size="10pt"                
		    space-before="4pt"
		    space-after="2pt"
		    space-before.precedence="0"
		    space-after.precedence="3"
		    keep-with-next="always"
		    >
	            <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertReqId_header</xsl:with-param> </xsl:call-template>
		    <xsl:value-of select="."/>
	  </fo:block>
</xsl:template>

<xsl:template name="CertRequest" match="CertRequest">
    <fo:block text-align="left" font-size="10pt" 	
	      >
	<xsl:for-each select="certReqId">
		<xsl:call-template name="CertReqId"/>
	</xsl:for-each>

	<xsl:for-each select="certTemplate">
		<xsl:call-template name="CertTemplate"/>
	</xsl:for-each>

	<xsl:for-each select="controls">
		<xsl:call-template name="Controls"/>
	</xsl:for-each>

    </fo:block>

</xsl:template>



<xsl:template name="CertRepMessage" match="CertRepMessage">
    <fo:block text-align="left" font-size="10pt" 	
	      >

	<xsl:for-each select="caPubs/*">
		<xsl:call-template name="Certificate"/>
	</xsl:for-each>

	<xsl:for-each select="response/*">
		<xsl:call-template name="CertResponse"/>
	</xsl:for-each>

    </fo:block>

</xsl:template>

<xsl:template name="CertResponse" match="CertResponse">

	<xsl:for-each select="certReqId">
		<xsl:call-template name="CertReqId"/>
	</xsl:for-each>

	<xsl:for-each select="status">
		<xsl:call-template name="PKIStatusInfo"/>
	</xsl:for-each>

	<xsl:for-each select="certifiedKeyPair">
		<xsl:call-template name="CertifiedKeyPair"/>
	</xsl:for-each>

	<xsl:for-each select="rspInfo">
		<xsl:value-of select="."/>
	</xsl:for-each>


</xsl:template>

<xsl:template name="KeyRecRepContent" match="KeyRecRepContent">
    <fo:block text-align="left" font-size="10pt" 	
	      >


	<xsl:for-each select="status">
		<xsl:call-template name="PKIStatusInfo"/>
	</xsl:for-each>

	<xsl:for-each select="newSigCert">
		<xsl:call-template name="Certificate"/>
	</xsl:for-each>

	<xsl:for-each select="caCerts/*">
		<xsl:call-template name="Certificate"/>
	</xsl:for-each>

	<xsl:for-each select="keyPairHist/*">
		<xsl:call-template name="CertifiedKeyPair"/>
	</xsl:for-each>

	<xsl:for-each select="rspInfo">
		<xsl:value-of select="."/>
	</xsl:for-each>
    </fo:block>

</xsl:template>

<xsl:template name="CertifiedKeyPair" match="CertifiedKeyPair">
	<xsl:for-each select="certOrEncCert">
		<xsl:call-template name="CertOrEncCert"/>
	</xsl:for-each>

	<xsl:for-each select="privateKey">
		<xsl:call-template name="EncryptedValue"/>
	</xsl:for-each>

	<xsl:for-each select="publicationInfo">
		<xsl:call-template name="PKIPublicationInfo"/>
	</xsl:for-each>

</xsl:template>

<xsl:template name="PKIPublicationInfo" match="PKIPublicationInfo">
	<xsl:for-each select="action">

		<xsl:if test=". = 0">
			<xsl:value-of select="."/>
		</xsl:if>

		<xsl:if test=". = 1">
			<xsl:value-of select="."/>
		</xsl:if>
	</xsl:for-each>

	<xsl:for-each select="pubInfos/*">
		<xsl:call-template name="SinglePubInfo"/>
	</xsl:for-each>

</xsl:template>


<xsl:template name="CertOrEncCert" match="CertOrEncCert">
	<xsl:for-each select="certificate">
		<xsl:call-template name="Certificate"/>
	</xsl:for-each>

	<xsl:for-each select="encryptedCert">
		<xsl:call-template name="EncryptedValue"/>
	</xsl:for-each>

</xsl:template>


<xsl:template name="RevRepContent" match="RevRepContent">
    <fo:block text-align="left" font-size="10pt" 	
	      >

	<xsl:for-each select="status/*">
		<xsl:call-template name="PKIStatusInfo"/>
	</xsl:for-each>

	<xsl:for-each select="revCerts">
		<xsl:call-template name="CertId"/>
	</xsl:for-each>

	<xsl:for-each select="crls">
		<xsl:call-template name="CertificateList"/>
	</xsl:for-each>

    </fo:block>

</xsl:template>

<xsl:template name="CRLAnnContent" match="CRLAnnContent">
    <fo:block text-align="left" font-size="10pt" 	
	      >

	<xsl:for-each select="./*">
		<xsl:call-template name="CertificateList"/>
	</xsl:for-each>
    </fo:block>

</xsl:template>

<xsl:template name="CertAnnContent" match="CertAnnContent">
    <fo:block text-align="left" font-size="10pt" 	
	      >

		<xsl:call-template name="Certificate"/>
    </fo:block>

</xsl:template>

<xsl:template name="RevAnnContent" match="RevAnnContent">
    <fo:block text-align="left" font-size="10pt" 	
	      >

	<xsl:for-each select="status">
		<xsl:call-template name="PKIStatus"/>
	</xsl:for-each>

	<xsl:for-each select="certId">
		<xsl:call-template name="CertId"/>
	</xsl:for-each>

	<xsl:for-each select="willBeRevokedAt">
	  <fo:block font-family="Times" font-size="10pt"                
		    space-before="4pt"
		    space-after="2pt"
		    space-before.precedence="0"
		    space-after.precedence="3"
		    keep-with-next="always"
		    >
	            <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_RevAnnContent_willBeRevokedAt</xsl:with-param> </xsl:call-template>

		    <xsl:call-template name="GeneralizedTime"/>
	  </fo:block>
		

	</xsl:for-each>

	<xsl:for-each select="badSinceDate">
	  <fo:block font-family="Times" font-size="10pt"                
		    space-before="4pt"
		    space-after="2pt"
		    space-before.precedence="0"
		    space-after.precedence="3"
		    keep-with-next="always"
		    >
	            <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_RevAnnContent_badSinceDate</xsl:with-param> </xsl:call-template>
		    <xsl:call-template name="GeneralizedTime"/>
	  </fo:block>

	</xsl:for-each>

	<xsl:for-each select="crlDetails">
		<xsl:call-template name="Extensions"/>
	</xsl:for-each>

    </fo:block>

</xsl:template>

<xsl:template name="GenMsgContent" match="GenMsgContent">
    <fo:block text-align="left" font-size="10pt" 	
	      >

	<xsl:for-each select="./*">
		<xsl:call-template name="InfoTypeAndValue"/>
	</xsl:for-each>
    </fo:block>

</xsl:template>

<xsl:template name="ErrorMsgContent" match="ErrorMsgContent">
    <fo:block text-align="left" font-size="10pt" 	
	      >

	<xsl:for-each select="pKIStatusInfo">
		<xsl:call-template name="PKIStatusInfo"/>
	</xsl:for-each>

	<xsl:for-each select="errorCode">
		<fo:block font-family="Times" font-size="10pt"                
		    space-before="4pt"
		    space-after="2pt"
		    space-before.precedence="0"
		    space-after.precedence="3"
		    keep-with-next="always"
		    >
	            <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ErrorMsgContent_errorCode</xsl:with-param> </xsl:call-template>
	  	</fo:block>


		<fo:block font-family="Times" font-size="10pt"                
		    border-style="solid"
		    >
                    <xsl:value-of select="."/>
	  	</fo:block>
	</xsl:for-each>


	<xsl:for-each select="errorDetails">
		<xsl:call-template name="PKIFreeText"/>
	</xsl:for-each>
    </fo:block>


</xsl:template>

<xsl:template name="PKIFreeText" match="PKIFreeText">
	<xsl:for-each select="./*">
		<xsl:value-of select="."/>
	</xsl:for-each>
</xsl:template>

<xsl:template name="CAKeyUpdAnnContent" match="CAKeyUpdAnnContent">
    <fo:block text-align="left" font-size="10pt" 	
	      >

	<xsl:for-each select="oldWithNew">
		<xsl:call-template name="Certificate"/>
	</xsl:for-each>

	<xsl:for-each select="newWithOld">
		<xsl:call-template name="Certificate"/>
	</xsl:for-each>

	<xsl:for-each select="newWithNew">
		<xsl:call-template name="Certificate"/>
	</xsl:for-each>
    </fo:block>

</xsl:template>



 </xsl:stylesheet>
