<?xml version="1.0" encoding="windows-1251"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:msxsl="urn:schemas-microsoft-com:xslt"
	version='1.0'>

	<xsl:variable name="OIDPKIEntityOrganization">1.2.643.2.2.41.8</xsl:variable>
	<xsl:variable name="OIDPKIEntityLicense">1.2.643.2.2.41.9</xsl:variable>
	<xsl:variable name="OIDPKIEntityPolicy">1.2.643.2.2.41.10</xsl:variable>
	<xsl:variable name="OIDPKIEntityOfficial">1.2.643.2.2.41.11</xsl:variable>
	<xsl:variable name="OIDPKIEntityCertificate">1.2.643.2.2.41.12</xsl:variable>


	<xsl:template name="printCertificateType">
		<xsl:variable name="ID" select="."/>
		<xsl:variable name="result" select="document($reestr_file)/reestr/CertType/*[@id = $ID]/*[name()=$lang]"/>
		<xsl:choose>
			<xsl:when test="string-length($result) != 0">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="printCertificateStatus">
		<xsl:variable name="ID" select="."/>
		<xsl:variable name="result" select="document($reestr_file)/reestr/CertStatus/*[@id = $ID]/*[name()=$lang]"/>
		<xsl:choose>
			<xsl:when test="string-length($result) != 0">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="printLicenseStatus">
		<xsl:variable name="ID" select="."/>
		<xsl:variable name="result" select="document($reestr_file)/reestr/LicenseStatus/*[@id = $ID]/*[name()=$lang]"/>
		<xsl:choose>
			<xsl:when test="string-length($result) != 0">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="printWorkplaceStatus">
		<xsl:variable name="ID" select="."/>
		<xsl:variable name="result" select="document($reestr_file)/reestr/WorkplaceStatus/*[@id = $ID]/*[name()=$lang]"/>
		<xsl:choose>
			<xsl:when test="string-length($result) != 0">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="printTitleType">
		<xsl:variable name="ID" select="."/>
		<xsl:variable name="result" select="document($reestr_file)/reestr/TitleType/*[@id = $ID]/*[name()=$lang]"/>
		<xsl:choose>
			<xsl:when test="string-length($result) != 0">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="printOrganizationType">
		<xsl:variable name="ID" select="."/>
		<xsl:variable name="result" select="document($reestr_file)/reestr/OrganizationType/*[@id = $ID]/*[name()=$lang]"/>
		<xsl:choose>
			<xsl:when test="string-length($result) != 0">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="printOrganizationStatus">
		<xsl:variable name="ID" select="."/>
		<xsl:variable name="result" select="document($reestr_file)/reestr/OrganizationStatus/*[@id = $ID]/*[name()=$lang]"/>
		<xsl:choose>
			<xsl:when test="string-length($result) != 0">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="printOIDType">
		<xsl:variable name="ID" select="."/>
		<xsl:variable name="result" select="document($reestr_file)/reestr/OIDType/*[@id = $ID]/*[name()=$lang]"/>
		<xsl:choose>
			<xsl:when test="string-length($result) != 0">
				<xsl:value-of select="$result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="."/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!--   :  -->
	<xsl:template match="PKIEntityCertificate" name="PKIEntityCertificate">

		<fo:block font-family="Times" font-size="10pt"
			space-before="10pt"
			space-after="5pt"
			space-before.precedence="0"
			space-after.precedence="3"
			keep-with-next="always"
			>
			<xsl:call-template name="printTEXT">
				<xsl:with-param name="textID"></xsl:with-param>
			</xsl:call-template>
		</fo:block>

		<fo:block font-family="Times" font-size="10pt"                      
			border-style="solid"
			>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">: </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="SubjectDN"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">: </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="IssuerDN"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Serial"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:for-each select="./CertType">
					<xsl:call-template name="printCertificateType"/>
				</xsl:for-each>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:for-each select="./CertStatus">
					<xsl:call-template name="printCertificateStatus"/>
				</xsl:for-each>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
			</fo:block>
			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="split">
					<xsl:with-param name="val">
						<xsl:value-of select="PublicKey"/>
					</xsl:with-param>
				</xsl:call-template>
			</fo:block>

			<!--   
			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">  : </xsl:with-param> 
				</xsl:call-template>
			</fo:block>
			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="split">
					<xsl:with-param name="val">
						<xsl:value-of select="BLOB"/>
					</xsl:with-param>
				</xsl:call-template>
			</fo:block>
			-->

		</fo:block>

	</xsl:template>


	<!--   :  -->
	<xsl:template match="PKIEntityTitle" name="PKIEntityTitle">

		<fo:block font-family="Times" font-size="10pt"                      
			border-style="solid"
			>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="TitleCode"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Name"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:for-each select="./Type">
					<xsl:call-template name="printTitleType"/>
				</xsl:for-each>
			</fo:block>

		</fo:block>

	</xsl:template>


	<!--   :  -->
	<xsl:template match="PKIEntityPerson" name="PKIEntityPerson">

		<fo:block font-family="Times" font-size="10pt"                      
			border-style="solid"
			>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">, , : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="FIO"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="PostAddress"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">: </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Phone"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:for-each select="./BirthDate">  
					<xsl:call-template name="GeneralizedTime"/>
				</xsl:for-each>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="PassportSeria"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="PassportNumber"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">  : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="PassportIssuer"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:for-each select="./PassportDate">  
					<xsl:call-template name="GeneralizedTime"/>
				</xsl:for-each>
			</fo:block>

		</fo:block>

	</xsl:template>



	<!--   :   -->
	<xsl:template match="PKIEntityLicenseDomain" name="PKIEntityLicenseDomain">

		<fo:block font-family="Times" font-size="10pt"                      
			border-style="solid"
			>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Code"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Name"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="AppDomain"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Description"/>
			</fo:block>

		</fo:block>

	</xsl:template>

	<!--   : OID -->
	<xsl:template match="PKIEntityOID" name="PKIEntityOID">

		<fo:block font-family="Times" font-size="10pt"                      
			border-style="solid"
			>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Name"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Value"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="SymbolCode"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">  : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="RegOrgCode"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:for-each select="./Type">
					<xsl:call-template name="printOIDType"/>
				</xsl:for-each>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">   : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="URL"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Description"/>
			</fo:block>

		</fo:block>

	</xsl:template>


	<!--   : LegalForm ()-->
	<xsl:template match="PKIEntityLegalForm" name="PKIEntityLegalForm">

		<fo:block font-family="Times" font-size="10pt"                      
			border-style="solid"
			>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Code"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Name"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Description"/>
			</fo:block>

		</fo:block>

	</xsl:template>



	<!--   : PropertyForm ( )-->
	<xsl:template match="PKIEntityPropertyForm" name="PKIEntityPropertyForm">

		<fo:block font-family="Times" font-size="10pt"                      
			border-style="solid"
			>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Code"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Name"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Description"/>
			</fo:block>

		</fo:block>

	</xsl:template>



	<!--   :  -->
	<xsl:template match="PKIEntityLicense" name="PKIEntityLicense">

		<fo:block font-family="Times" font-size="10pt"
			space-before="10pt"
			space-after="5pt"
			space-before.precedence="0"
			space-after.precedence="3"
			keep-with-next="always"
			>
			<xsl:call-template name="printTEXT">
				<xsl:with-param name="textID"></xsl:with-param>
			</xsl:call-template>
		</fo:block>
		
		<fo:block font-family="Times" font-size="10pt"                      
			border-style="solid"
			>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Serial"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:for-each select="./ValidFrom">  
					<xsl:call-template name="GeneralizedTime"/>
				</xsl:for-each>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:for-each select="./ValidTo">  
					<xsl:call-template name="GeneralizedTime"/>
				</xsl:for-each>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="IssuerOrg"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="Comment"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">: </xsl:with-param> 
				</xsl:call-template>
				<xsl:for-each select="./State">
					<xsl:call-template name="printLicenseStatus"/>
				</xsl:for-each>
			</fo:block>

			<!--   -->
			<fo:block font-family="Times" font-size="10pt"
				space-before="10pt"
				space-after="5pt"
				space-before.precedence="0"
				space-after.precedence="3"
				keep-with-next="always"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param>
				</xsl:call-template>
			</fo:block>
			
			<xsl:for-each select="PKIEntityLicenseDomain">
				<xsl:call-template name="PKIEntityLicenseDomain"/>
			</xsl:for-each>

		</fo:block>

	</xsl:template>




	<!--   :   -->
	<xsl:template match="PKIEntityWorkPlace" name="PKIEntityWorkPlace">

		<fo:block font-family="Times" font-size="10pt"
			space-before="10pt"
			space-after="5pt"
			space-before.precedence="0"
			space-after.precedence="3"
			keep-with-next="always"
			>
			<xsl:call-template name="printTEXT">
				<xsl:with-param name="textID"> </xsl:with-param>
			</xsl:call-template>
		</fo:block>
		
		<fo:block font-family="Times" font-size="10pt"                      
			border-style="solid"
			>

			<!--  -->
			<fo:block font-family="Times" font-size="10pt"
				space-before="10pt"
				space-after="5pt"
				space-before.precedence="0"
				space-after.precedence="3"
				keep-with-next="always"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">: </xsl:with-param>
				</xsl:call-template>
			</fo:block>
			<xsl:for-each select="PKIEntityPerson">
				<xsl:call-template name="PKIEntityPerson"/>
			</xsl:for-each>

			<!--  -->
			<fo:block font-family="Times" font-size="10pt"
				space-before="10pt"
				space-after="5pt"
				space-before.precedence="0"
				space-after.precedence="3"
				keep-with-next="always"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">: </xsl:with-param>
				</xsl:call-template>
			</fo:block>
			<xsl:for-each select="PKIEntityTitle">
				<xsl:call-template name="PKIEntityTitle"/>
			</xsl:for-each>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">: </xsl:with-param> 
				</xsl:call-template>
				<xsl:for-each select="./PersonStatus">
					<xsl:call-template name="printWorkplaceStatus"/>
				</xsl:for-each>
			</fo:block>

			<!--  -->
			<!--
			<fo:block font-family="Times" font-size="10pt"
				space-before="10pt"
				space-after="5pt"
				space-before.precedence="0"
				space-after.precedence="3"
				keep-with-next="always"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">: </xsl:with-param>
				</xsl:call-template>
			</fo:block>
			<xsl:for-each select="PKIEntityCertificate">
				<xsl:call-template name="PKIEntityCertificate"/>
			</xsl:for-each>
			-->
		</fo:block>

	</xsl:template>




	<!--   :  -->
	<xsl:template match="PKIEntityOrganization" name="PKIEntityOrganization">

		<fo:block font-family="Times" font-size="10pt"
			space-before="10pt"
			space-after="5pt"
			space-before.precedence="0"
			space-after.precedence="3"
			keep-with-next="always"
			>
			<xsl:call-template name="printTEXT">
				<xsl:with-param name="textID"></xsl:with-param>
			</xsl:call-template>
		</fo:block>
		
		<fo:block font-family="Times" font-size="10pt"                      
			border-style="solid"
			>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:for-each select="./Type">
					<xsl:call-template name="printOrganizationType"/>
				</xsl:for-each>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">  : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="OrgDN"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">  : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="OfficialName"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="PostAddress"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="LegalAddress"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">  : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="CaType"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">  : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="ProviderType"/>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:for-each select="./Status">
					<xsl:call-template name="printOrganizationStatus"/>
				</xsl:for-each>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:for-each select="./RegDateTime">  
					<xsl:call-template name="GeneralizedTime"/>
				</xsl:for-each>
			</fo:block>

			<fo:block font-family="Times" font-size="10pt"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param> 
				</xsl:call-template>
				<xsl:value-of select="RegID"/>
			</fo:block>

			<!--   -->
			<fo:block font-family="Times" font-size="10pt"
				space-before="10pt"
				space-after="5pt"
				space-before.precedence="0"
				space-after.precedence="3"
				keep-with-next="always"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param>
				</xsl:call-template>
			</fo:block>
			<xsl:for-each select="PKIEntityLegalForm">
				<xsl:call-template name="PKIEntityLegalForm"/>
			</xsl:for-each>
			

			<!--   .  -->
			<fo:block font-family="Times" font-size="10pt"
				space-before="10pt"
				space-after="5pt"
				space-before.precedence="0"
				space-after.precedence="3"
				keep-with-next="always"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">  . : </xsl:with-param>
				</xsl:call-template>
			</fo:block>
			<xsl:for-each select="PKIEntityPropertyForm">
				<xsl:call-template name="PKIEntityPropertyForm"/>
			</xsl:for-each>

			<!--  -->
			<fo:block font-family="Times" font-size="10pt"
				space-before="10pt"
				space-after="5pt"
				space-before.precedence="0"
				space-after.precedence="3"
				keep-with-next="always"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">: </xsl:with-param>
				</xsl:call-template>
			</fo:block>
			<xsl:for-each select="PKIEntityLicense">
				<xsl:call-template name="PKIEntityLicense"/>
			</xsl:for-each>

			<!--   -->
			<fo:block font-family="Times" font-size="10pt"
				space-before="10pt"
				space-after="5pt"
				space-before.precedence="0"
				space-after.precedence="3"
				keep-with-next="always"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID"> : </xsl:with-param>
				</xsl:call-template>
			</fo:block>
			<xsl:for-each select="PKIEntityOID">
				<xsl:call-template name="PKIEntityOID"/>
			</xsl:for-each>

			<!--  -->
			<fo:block font-family="Times" font-size="10pt"
				space-before="10pt"
				space-after="5pt"
				space-before.precedence="0"
				space-after.precedence="3"
				keep-with-next="always"
				>
				<xsl:call-template name="printTEXT">
					<xsl:with-param name="textID">: </xsl:with-param>
				</xsl:call-template>
			</fo:block>
			<xsl:for-each select="PKIEntityTitle">
				<xsl:call-template name="PKIEntityTitle"/>
			</xsl:for-each>

		</fo:block>

	</xsl:template>



	<!--    -->
	<xsl:template match="ReestrCard" name="ReestrCard">
		<!--    -->
		<fo:flow flow-name="xsl-region-body">
			<fo:block text-align="center"
				font-family="Arial" font-size="14pt"      
				space-before="32pt"
				space-after="16pt"
				space-before.precedence="0"
				space-after.precedence="3"
				keep-with-next="always"
				>
					<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">  </xsl:with-param> </xsl:call-template>
			</fo:block>
			<!--   -->

			<!--  -->
			<xsl:for-each select="PKIEntityOrganization">
				<xsl:call-template name="PKIEntityOrganization"/>
			</xsl:for-each>

			<!--  -->
			<xsl:for-each select="PKIEntityLicense">
				<xsl:call-template name="PKIEntityLicense"/>
			</xsl:for-each>

			<!-- OID (Policy) -->
			<xsl:for-each select="PKIEntityOID">
				<xsl:call-template name="PKIEntityOID"/>
			</xsl:for-each>
			
			<!-- WorkPlace (Official) -->
			<xsl:for-each select="PKIEntityWorkPlace">
				<xsl:call-template name="PKIEntityWorkPlace"/>
			</xsl:for-each>

			<!-- Certificate -->
			<xsl:for-each select="PKIEntityCertificate">
				<xsl:call-template name="PKIEntityCertificate"/>
			</xsl:for-each>

		</fo:flow>
	</xsl:template>


</xsl:stylesheet>


