#ifndef CPPCADES_CLOUDCSPCONFIG_OBJECT_H_
#define CPPCADES_CLOUDCSPCONFIG_OBJECT_H_

#include "cppcades.h"
#include "CPPCadesCPCertificate.h"
#include <cplib/Blob.h>
#include "cpcsp/WinCryptEx.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCloudCSPConfigObject
{
public:
    CPPCadesCloudCSPConfigObject(void);
    ~CPPCadesCloudCSPConfigObject(void);

    HRESULT set_Auth(CAtlString val);
    HRESULT set_Rest(CAtlString val);
    HRESULT set_DocStore(CAtlString val);
    HRESULT set_LocalMachine(BOOL val);
    HRESULT SaveCloudServerSettings();
    HRESULT SetCloudCertificateToStore(NS_SHARED_PTR::shared_ptr<CPPCadesCPCertificateObject> pVal);

private:
    CAtlString m_sAuth;
    CAtlString m_sRest;
    CAtlString m_sDocStore;
    CAtlString m_sUnique;
    BOOL m_bLocalMachine;
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCloudCSPConfigObject);
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CLOUDCSPCONFIG_OBJECT_H_

