#ifndef CPP_CADES_SIGNED_XML_H_
#define CPP_CADES_SIGNED_XML_H_
#include "cppcades.h"
#include "CPPCadesCollections.h"
#include "CPPCadesCPSigner.h"
#include "CPPCadesContent.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {


class CPPCadesSignedXMLObject
{
public:
    CPPCadesSignedXMLObject();
    ~CPPCadesSignedXMLObject();

#ifndef UNIX
    HRESULT put_Content(const BSTR& pVal);
    HRESULT get_Content(CComBSTR& pVal);
#endif // UNIX

    HRESULT put_Content(const CStringBlob& pVal);
    HRESULT get_Content(CStringBlob& pVal);

    HRESULT put_SignatureType(CADESCOM_XML_SIGNATURE_TYPE signatureType);
    HRESULT put_SignatureOptions(CADESCOM_XADES_ADDITIONAL_OPTIONS signatureOptions);
    HRESULT put_DigestMethod(const CStringBlob& pVal);
    HRESULT put_SignatureMethod(const CStringBlob& pVal);

    HRESULT get_Signers(NS_SHARED_PTR::shared_ptr<CPPCadesCPSignersObject>& pVal);

    HRESULT Sign(const NS_SHARED_PTR::shared_ptr<CPPCadesCPSignerObject>& pSigner,
        CStringBlob& pXPath, CStringBlob& pVal);
#ifndef UNIX
    HRESULT Verify(const BSTR& SignedMessage, BSTR& pXPath);
#endif // UNIX
    HRESULT Verify(const CStringBlob& SignedMessage, CStringBlob& pXPath);

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesSignedXMLObject);    
    HRESULT VerifyImpl(CStringBlob& pXPath);
    //   CadesSignedXML    
    void ResetState();
    HRESULT LoadLibs();
    void UnLoadLibs();

    CADESCOM_XML_SIGNATURE_TYPE m_signatureType;
    CADESCOM_XADES_ADDITIONAL_OPTIONS m_signatureOptions;
#ifndef UNIX
#pragma warning(push)
#pragma warning(disable: 4251)
#endif
    CStringBlob m_content; 
    CStringBlob m_signatureMethod;
    CStringBlob m_digestMethod;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPSignersObject> m_pSigners;
    std::vector<SigInfo> m_sigInfos;
#ifndef UNIX
#pragma warning(pop)
#endif
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif //CPP_CADES_SIGNED_XML_H_
