#ifndef CPP_ENROLL_CRYPT_ATTRIBUTE_OBJECT_H_
#define CPP_ENROLL_CRYPT_ATTRIBUTE_OBJECT_H_

#include "cppcades.h"
#include "CPPEnrollEnumerations.h"
#include "CPPEnrollObjectId.h"
#include "CPPEnrollX509Attribute.h"
#include "CPPEnrollCollections.h"

using namespace ATL;
namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollX509Attributes;

class CPPEnrollCryptAttribute
{
public:
    CPPEnrollCryptAttribute(void);
    ~CPPEnrollCryptAttribute(void);
    HRESULT InitializeFromObjectId(NS_SHARED_PTR::shared_ptr<CPPEnrollObjectId>& pObjectId);
    HRESULT InitializeFromValues(NS_SHARED_PTR::shared_ptr<CPPEnrollX509Attributes>& pValues);
    HRESULT AddAttrValue(CBlob* pCryptAttrBlob);

    //internal
    HRESULT get_CryptAttributeStruct(CRYPT_ATTRIBUTE& cryptAttr);
    NS_SHARED_PTR::shared_ptr<CPPEnrollObjectId> GetOid();

protected:
    NS_SHARED_PTR::shared_ptr<CPPEnrollObjectId> m_pOid;
    NS_SHARED_PTR::shared_ptr<CPPEnrollX509Attributes> m_pValues;
    std::vector<CRYPT_ATTR_BLOB> m_attrValues;
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollCryptAttribute);
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_CRYPT_ATTRIBUTE_OBJECT_H_
