#ifndef PLUGINCONFIGURATION_H_
#define PLUGINCONFIGURATION_H_
#include "CPPTrustedSites.h"

namespace CryptoPro{
namespace PKI {
namespace CAdES {

///  
class CPPPluginConfiguration
{
public:
    CPPPluginConfiguration();
    HRESULT GetSites(NS_SHARED_PTR::shared_ptr<CPPTrustedSites>& pTrustedSites);
    HRESULT GetSitesGroupPolicy(std::set<std::wstring> &sites);
    HRESULT IsUntrustedSitesDisabled(bool &disabled);
    bool IsValidUrl(CAtlString sUrl);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPPluginConfiguration);
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif //PLUGINCONFIGURATION_H_
