#pragma warning(disable:4996)

#include <iterator>
#include <vector>
#include <iostream>
#include <wchar.h>
#include <cstdlib>

#ifdef _WIN32
#include <tchar.h>
#else
#include <cstdio>
#include "reader/tchar.h"
#endif

#include "cades.h"

/*
   CADES_BES  CADES_X_LONG_TYPE_1  
    SDK.      
  sign.dat ( SimplifiedSignCadesBes, LowlevelSignCadesBes). sign.dat
    .      adv_sign.dat. 
  OCSP     .
*/

using namespace std;

#include "../samples_util.h"

int main(void) {
    vector<unsigned char> message;
    //    
    if (ReadFileToVector("sign.dat", message)) {
        cout << "Reading signature from file \"sign.dat\" failed" << endl;
        return -1;
    }

    if (message.empty()) {
        cout << "File \"sign.dat\" is empty. Nothing to enhance" << endl;
        return -1;
    }

    //  
    CADES_SERVICE_CONNECTION_PARA tspConnectionPara = {sizeof(tspConnectionPara)};
    tspConnectionPara.wszUri = SERVICE_URL_2012; //   -     

    CADES_SIGN_PARA cadesSignPara = {sizeof(cadesSignPara)};
    cadesSignPara.dwCadesType = CADES_X_LONG_TYPE_1; //     CADES_X_LONG_TYPE_1
    cadesSignPara.pTspConnectionPara = &tspConnectionPara;

    CADES_ENHANCE_MESSAGE_PARA para = {sizeof(para)};
    para.dwMsgEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING;
    para.pCadesSignPara = &cadesSignPara;

    PCRYPT_DATA_BLOB pSignedMessage = 0;
    //  ,    CADES_BES,    CADES_X_LONG_TYPE_1
    if (!CadesEnhanceMessage(&para, 0, &message[0], (unsigned long) message.size(), &pSignedMessage)) {
        cout << "CadesEnhanceMessage() failed" << endl;
        return -1;
    }

    message.resize(pSignedMessage->cbData);
    copy(pSignedMessage->pbData, pSignedMessage->pbData + pSignedMessage->cbData, message.begin());

    //   CADES_X_LONG_TYPE_1   adv_sign.dat
    if (SaveVectorToFile<unsigned char>("adv_sign.dat", message)) {
        cout << "Signature was not saved" << endl;
        return -1;
    }

    //  
    if (!CadesFreeBlob(pSignedMessage)) {
        cout << "CadesFreeBlob() failed" << endl;
        return -1;
    }

    cout << "Signature was enhanced and saved successfully." << endl;

    return 0;
}
