#ifndef CPPCADES_CPEXTENSION_OBJECT_H_
#define CPPCADES_CPEXTENSION_OBJECT_H_

#include "cppcades.h"
#include "CPPCadesCPOID.h"
#include "CPPCadesCPEncodedData.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPExtensionObject
{
public:
    CPPCadesCPExtensionObject();
    ~CPPCadesCPExtensionObject();

    HRESULT Initialize(CAtlStringA sOID, BOOL bCritical, CBlob Value);
    HRESULT get_OID(NS_SHARED_PTR::shared_ptr<CPPCadesCPOIDObject>& pVal);
    HRESULT get_EncodedData(NS_SHARED_PTR::shared_ptr<CPPCadesCPEncodedDataObject>& pVal);
    HRESULT get_IsCritical(BOOL* pVal);
    void CheckValidState();

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPExtensionObject);
    NS_SHARED_PTR::shared_ptr<CPPCadesCPOIDObject> m_pOID;
    NS_SHARED_PTR::shared_ptr<CPPCadesCPEncodedDataObject> m_encData;
    BOOL m_bCritical;
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_CRL_OBJECT_H_
