#ifndef CPP_ENROLL_EXTENSION_OBJECT_H_
#define CPP_ENROLL_EXTENSION_OBJECT_H_

#include "cppcades.h"
#include "CPPEnrollEnumerations.h"
#include "CPPEnrollObjectId.h"
#include "CPPEnrollCollections.h"

using namespace ATL;
namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollObjectIds;
class CPPEnrollCertificatePolicies;
class CPPEnrollAlternativeNames;

class CPPEnrollX509Extension
{
public:
    CPPEnrollX509Extension(void);
    ~CPPEnrollX509Extension(void);
    HRESULT Initialize(NS_SHARED_PTR::shared_ptr<CPPEnrollObjectId>& pObjectId,
        EncodingType Encoding,
        CAtlString& strEncodedData);
    HRESULT put_Critical(bool newVal);
#ifndef UNIX
    HRESULT CPPEnrollX509Extension::get_RawData(EncodingType Encoding,
        CComBSTR& rawData);
#endif // !UNIX
    HRESULT get_RawData(EncodingType Encoding,
        CStringBlob& rawData);
    HRESULT get_ObjectId(NS_SHARED_PTR::shared_ptr<CPPEnrollObjectId>& pObjectId);

    // web-disabled
    HRESULT get_Critical(bool* pVal);

    //internal
    HRESULT get_CertExtensionStruct(CERT_EXTENSION& certExt);
    HRESULT initFromCertExtensionStruct(const PCERT_EXTENSION pExtension);
    NS_SHARED_PTR::shared_ptr<CPPEnrollObjectId> GetOid();

protected:
    CStringBlob m_value;
    bool m_bCritical;
    NS_SHARED_PTR::shared_ptr<CPPEnrollObjectId> m_pOid;
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509Extension);
};

class CPPEnrollX509ExtensionKeyUsage : public CPPEnrollX509Extension
{
public:
    CPPEnrollX509ExtensionKeyUsage(void);
    ~CPPEnrollX509ExtensionKeyUsage(void);

    HRESULT InitializeEncode(X509KeyUsageFlags UsageFlags);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509ExtensionKeyUsage);
};

class CPPEnrollX509ExtensionEnhancedKeyUsage : public CPPEnrollX509Extension
{
public:
    CPPEnrollX509ExtensionEnhancedKeyUsage(void);
    ~CPPEnrollX509ExtensionEnhancedKeyUsage(void);

    HRESULT InitializeEncode(NS_SHARED_PTR::shared_ptr<CPPEnrollObjectIds>& pVal);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509ExtensionEnhancedKeyUsage);
};

class CPPEnrollX509ExtensionTemplate : public CPPEnrollX509Extension
{
public:
    CPPEnrollX509ExtensionTemplate(void);
    ~CPPEnrollX509ExtensionTemplate(void);

    HRESULT InitializeEncode(
        NS_SHARED_PTR::shared_ptr<CPPEnrollObjectId>& pTemplateOid,
        DWORD MajorVersion,
        DWORD MinorVersion);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509ExtensionTemplate);
};

class CPPEnrollX509ExtensionSmimeCapabilities : public CPPEnrollX509Extension
{
public:
    CPPEnrollX509ExtensionSmimeCapabilities(void);
    ~CPPEnrollX509ExtensionSmimeCapabilities(void);

    HRESULT InitializeEncode(NS_SHARED_PTR::shared_ptr<CPPEnrollObjectIds>& pVal);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509ExtensionSmimeCapabilities);
};

class CPPEnrollX509ExtensionSubjectKeyIdentifier : public CPPEnrollX509Extension
{
public:
    CPPEnrollX509ExtensionSubjectKeyIdentifier(void);
    ~CPPEnrollX509ExtensionSubjectKeyIdentifier(void);

    HRESULT InitializeEncode(CStringBlob& pSubjectKeyIdentifier);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509ExtensionSubjectKeyIdentifier);
};

class CPPEnrollX509ExtensionCertificatePolicies : public CPPEnrollX509Extension
{
public:
    CPPEnrollX509ExtensionCertificatePolicies(void);
    ~CPPEnrollX509ExtensionCertificatePolicies(void);

    HRESULT InitializeEncode(NS_SHARED_PTR::shared_ptr<CPPEnrollCertificatePolicies>& pVal);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509ExtensionCertificatePolicies);
};

class CPPEnrollX509ExtensionSubjectSignTool : public CPPEnrollX509Extension
{
public:
    CPPEnrollX509ExtensionSubjectSignTool(void);
    ~CPPEnrollX509ExtensionSubjectSignTool(void);

    HRESULT InitializeEncode();
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509ExtensionSubjectSignTool);
};

class CPPEnrollX509ExtensionIdentificationKind : public CPPEnrollX509Extension
{
public:
    CPPEnrollX509ExtensionIdentificationKind(void);
    ~CPPEnrollX509ExtensionIdentificationKind(void);

    HRESULT InitializeEncode(DWORD dwIdentificationKind);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509ExtensionIdentificationKind);
};

class CPPEnrollX509ExtensionAlternativeNames : public CPPEnrollX509Extension
{
public:
    CPPEnrollX509ExtensionAlternativeNames(void);
    ~CPPEnrollX509ExtensionAlternativeNames(void);

    HRESULT InitializeEncode(NS_SHARED_PTR::shared_ptr<CPPEnrollAlternativeNames>& pVal);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509ExtensionAlternativeNames);
};


} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_EXTENSION_OBJECT_H_
